<?php
//shortcode for user info & login-logout
add_shortcode( 'CIP-HELPER', 'cip_helprt_userinfo_login_logout_cb' );
function cip_helprt_userinfo_login_logout_cb( $attr ){
	$args = shortcode_atts( array(
		'type' => 'link'
	), $attr );
	$type = $args['type'];
	$html = "";
	ob_start();
	if( $type == 'info' ){
		if( is_user_logged_in() ){
			global $current_user;
			$user_name = $current_user->user_login ;
			$user_email = $current_user->user_email ;
			$user_roles = $current_user->roles;
			$user_role = array_shift($user_roles);
			$UserData = get_user_by( 'id', get_current_user_id() );
			if( in_array( "member", $UserData->roles ) ){
				$userEmail=$_SESSION['refAccount'];
				if(!$_SESSION['refAccount'] && count($UserData->roles) == 1)
				{
					wp_logout();
					$url=site_url();
					wp_redirect( $url );
					exit;
				}
				if($userEmail=="csrholder@gmail.com")
				{
					$_SESSION['refAccount']	= "";
					wp_logout();
					$url=site_url();
					wp_redirect( $url );
					exit;
				}
				
				
				if($userEmail){
					?><p class='ciphelper_user_info' style="color:#fff;text-align:right;"><?php echo sprintf( __('Welcome %s ', CIP_TXTDOMAIN), $_SESSION['refAccount'] ); ?></p><?php
				}
				else{
					?><p class='ciphelper_user_info' style="color:#fff;text-align:right;"><?php echo sprintf( __('Welcome %s ', CIP_TXTDOMAIN), $user_email ); ?></p><?php
				}
			}else{
			?><p class='ciphelper_user_info' style="color:#fff;text-align:right;"><?php echo sprintf( __('Welcome %s (%s)', CIP_TXTDOMAIN), $user_email, $user_role ); ?></p><?php
			}
		}
	}else{
		?><div class="ciphelper_loginlog"><?php
		if( is_user_logged_in() ){
			?><a class="ciphelper_link_button" href="<?php echo get_permalink( 1067 ); ?>"><?php _e('Login', CIP_TXTDOMAIN); ?></a><?php
		}else{
			?><a class="ciphelper_link_button" href="<?php echo wp_logout_url( site_url() ); ?>"><?php _e('Logout', CIP_TXTDOMAIN); ?></a><?php
		}
		?></div><?php
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('SM-ALL-USERS-LISTING','sm_all_users_listing_cb');
function sm_all_users_listing_cb(){
	$html = "";
	ob_start();
	$args = array(
	    'role__in'  =>	array('supportagent','supportmanager'),
	    'exclude'	=>	array( get_current_user_id() ),
	);
	$users = get_users( $args );
	if( ( isset($_GET['action']) && $_GET['action'] === 'edit' ) && ( isset($_GET['uid']) && is_numeric( $_GET['uid'] ) ) ){ //edit user
		$getEditUser = get_user_by( 'id', $_GET['uid'] );
		if( $getEditUser && ( in_array( "supportmanager", $getEditUser->roles ) || in_array( "supportagent", $getEditUser->roles ) ) ){
			$role = $getEditUser->roles;
			$cip_user_status = get_user_meta( $getEditUser->ID, 'cip_user_status', true );
			$phonenumber = get_user_meta( $getEditUser->ID, 'phonenumber', true );
			$user_status = 1;
			$user_status_label = __('Active', CIP_TXTDOMAIN);
			if( $cip_user_status === 'deactive' ){
				$user_status = 0;
				$user_status_label = __('Deactive', CIP_TXTDOMAIN);
			}
		?>
		<form name="smsa_update_usr" id="smsa_update_usr">
			<div class="row">
				<div class="col">
					<div class="form-group">
				    	<label for="firstname"><?php _e('First Name',CIP_TXTDOMAIN) ?></label>
				    	<input type="text" class="form-control" id="firstname" name="firstname" value="<?php echo $getEditUser->first_name; ?>" >
				  	</div>
				</div>
				<div class="col">
					<div class="form-group">
				    	<label for="lastname"><?php _e('Last Name',CIP_TXTDOMAIN) ?></label>
				    	<input type="text" class="form-control" id="lastname" name="lastname" value="<?php echo $getEditUser->last_name; ?>" >
				  	</div>
				</div>
			</div>
			<div class="row">
				<div class="col">
					<div class="form-group">
				    	<label for="phonenumber"><?php _e('Phone Number',CIP_TXTDOMAIN) ?></label>
				    	<input type="text" class="form-control" id="phonenumber" name="phonenumber" value="<?php echo $phonenumber; ?>" >
				  	</div>
				</div>
				<div class="col">
					<div class="form-group">
				    	<label for="status"><?php _e('Status',CIP_TXTDOMAIN) ?></label>
				    	<select name="user_status">
							<option value="active" <?php selected( $user_status , 1 ); ?>><?php _e('Active',CIP_TXTDOMAIN); ?></option>
							<option value="deactive" <?php selected( $user_status , 0 ); ?>><?php _e('Deactive',CIP_TXTDOMAIN); ?></option>
						</select>
				  	</div>
				</div>
			</div>
			<div class="row">
				<div class="col">
					<div class="form-group">
				    	<label for="email"><?php _e('Email',CIP_TXTDOMAIN) ?></label>
				    	<input type="email" class="form-control" id="email" name="email" value="<?php echo $getEditUser->user_email; ?>" disabled>
				  	</div>
				</div>
				<div class="col">
					<div class="form-group">
				    	<label for="userrole"><?php _e('Role',CIP_TXTDOMAIN) ?></label>
				    	<input type="text" class="form-control" id="userrole" name="userrole" value="<?php echo $role[0]; ?>" disabled>
				  	</div>
				</div>
			</div>
			<input type="hidden" name="action" value="sasm_update_profile_act" />
			<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XupdatesasmprofX_'); ?>" />
			<input type="hidden" name="sasmuid" value="<?php echo $_GET['uid']; ?>">
	  		<button type="submit" class="btn btn-primary"><?php _e('Update',CIP_TXTDOMAIN); ?></button>
	  		<p><span class="form_response"></span></p>
		</form>
		<?php
		}
	}else{ // listing users
		if( $users && current_user_can('supportagent') ){
			wp_enqueue_style( 'cip-css' );
			wp_enqueue_style( 'bs-table' );
			wp_enqueue_style( 'bs-sticky-header' );
			wp_enqueue_style( 'bs-datepicker' );
			wp_enqueue_script('bs-table');
			wp_enqueue_script('bs-sticky-header');
			wp_enqueue_script('bs-table-filter-control');
			wp_enqueue_script('tbl-ex-js');
			wp_enqueue_script('jspdf');
			wp_enqueue_script('pdf-autotable-js');
			wp_enqueue_script('ex-js');
			wp_enqueue_script('bs-datepicker');
			?>
			<table id="cip_sasm_table"
		  data-filter-control="true"
		  data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="true" data-show-columns-toggle-all="true" data-show-export="true" data-click-to-select="true" class="table table-bordered">
		  <thead>
				<tr>
					<th data-field="firstname" data-sortable="true" data-filter-control="input" class="firstname"><?php _e('First Name',CIP_TXTDOMAIN); ?></th>
					<th data-field="lastname" data-sortable="true" data-filter-control="input" class="lastname"><?php _e('Last Name',CIP_TXTDOMAIN); ?></th>
					<th data-field="email" data-sortable="true" data-filter-control="input" class="email"><?php _e('Email',CIP_TXTDOMAIN); ?></th>
					<th data-field="user_role" data-sortable="true" data-filter-control="input" class="user_role"><?php _e('Role',CIP_TXTDOMAIN); ?></th>
					<th data-field="status" data-sortable="true" data-filter-control="select" class="status" data-filter-custom-search="BsTableFilterStatus"><?php _e('Status',CIP_TXTDOMAIN); ?></th>
					<th data-field="action" class="action" data-force-hide="true"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
				</tr>
			</thead>
		  	<?php
			foreach( $users as $user ){
				$role = $user->roles;
				$editLink = add_query_arg( array(
				    'action' => 'edit',
				    'uid' => $user->ID,
				), get_the_permalink() );
				$cip_user_status = get_user_meta( $user->ID, 'cip_user_status', true );
				$user_status = 1;
				$user_status_label = __('Active', CIP_TXTDOMAIN);
				if( $cip_user_status === 'deactive' ){
					$user_status = 0;
					$user_status_label = __('Deactive', CIP_TXTDOMAIN);
				}
			?><tr>
				<td><?php echo $user->first_name; ?></td>
				<td><?php echo $user->last_name; ?></td>
				<td><?php echo $user->user_email; ?></td>
				<td><?php echo $role[0]; ?></td>
				<td><?php echo $user_status_label; ?></td>
				<td>
					<a href="<?php echo $editLink; ?>" title="edit"><i class="fas fa-edit"></i></a>
				</td>
			</tr><?php
			}
			?>
		</table>
		<?php }else{
		?><h2><?php _e('No records found', CIP_TXTDOMAIN); ?></h2><?php
		}
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CIP-SMSA-PROFILE-VIEW','cip_smsa_profile_view');
function cip_smsa_profile_view(){
	$html = "";
	ob_start();
	$getEditUser = wp_get_current_user();
	$role = $getEditUser->roles;
	$cip_user_status = get_user_meta( $getEditUser->ID, 'cip_user_status', true );
	$phonenumber = get_user_meta( $getEditUser->ID, 'phonenumber', true );
	$user_status = 1;
	$user_status_label = __('Active', CIP_TXTDOMAIN);
	if( $cip_user_status === 'deactive' ){
		$user_status = 0;
		$user_status_label = __('Deactive', CIP_TXTDOMAIN);
	}
	wp_enqueue_style( 'cip-css' );
	?>
	<div class="container">
		<form name="smsaown_update_usr" id="smsaown_update_usr">
			<div class="row">
				<div class="col">
					<div class="form-group">
				    	<label for="firstname"><?php _e('First Name',CIP_TXTDOMAIN) ?></label>
				    	<input type="text" class="form-control" id="firstname" name="firstname" value="<?php echo $getEditUser->first_name; ?>" >
				  	</div>
				</div>
				<div class="col">
					<div class="form-group">
				    	<label for="lastname"><?php _e('Last Name',CIP_TXTDOMAIN) ?></label>
				    	<input type="text" class="form-control" id="lastname" name="lastname" value="<?php echo $getEditUser->last_name; ?>" >
				  	</div>
				</div>
			</div>
			<div class="row">
				<div class="col">
					<div class="form-group">
				    	<label for="phonenumber"><?php _e('Phone Number',CIP_TXTDOMAIN) ?></label>
				    	<input type="text" class="form-control" id="phonenumber" name="phonenumber" value="<?php echo $phonenumber; ?>" >
				  	</div>
				</div>
				<div class="col">
					<div class="form-group">
				    	<label for="status"><?php _e('Status',CIP_TXTDOMAIN) ?></label>
				    	<input type="text" class="form-control" id="userrole" name="userrole" value="<?php echo $user_status_label; ?>" disabled>
				  	</div>
				</div>
			</div>
			<div class="row">
				<div class="col">
					<div class="form-group">
				    	<label for="email"><?php _e('Email',CIP_TXTDOMAIN) ?></label>
				    	<input type="email" class="form-control" id="email" name="email" value="<?php echo $getEditUser->user_email; ?>" disabled>
				  	</div>
				</div>
				<div class="col">
					<div class="form-group">
				    	<label for="userrole"><?php _e('Role',CIP_TXTDOMAIN) ?></label>
				    	<input type="text" class="form-control" id="userrole" name="userrole" value="<?php echo $role[0]; ?>" disabled>
				  	</div>
				</div>
			</div>
			<input type="hidden" name="action" value="own_update_profile_act" />
			<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XupdateownprofX_'); ?>" />
	  		<button type="submit" class="btn btn-primary"><?php _e('Update',CIP_TXTDOMAIN); ?></button>
	  		<p><span class="form_response"></span></p>
		</form>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
// Register a new Support Manager shortcode: [cr_support_manager_registration]
add_shortcode( 'cr_support_manager_registration', 'cors_support_manager_register' );
function cors_support_manager_register(){
    require("support_registrationmanager.php");
    
    //Calling Register Support Manager Function
    cors_support_manager_registration_function();
}
// Register a new Support Agent shortcode: [cr_support_agent_registration]
add_shortcode( 'cr_support_agent_registration', 'cors_support_agent_register' );
function cors_support_agent_register() {
    require("support_registrationagent.php");
    
    //Calling Register Support Agent Function
    cors_support_agent_registration_function();
}
add_shortcode('SM-IMPORT-EXPORT-CLEAR-TH','sm_import_export_clear_th_cb');
function sm_import_export_clear_th_cb(){
	$html = "";
	ob_start();
	$smUserData = get_user_by( 'id', get_current_user_id() );
	if( $smUserData && in_array( "supportagent", $smUserData->roles ) ){
		if( $_GET['importth'] == 'yes' ){
			echo do_shortcode( '[CIP-SM-TOKEN-HOLDER-IMPORT]' );
		}else if( $_GET['importprocess'] == 'yes' ){
			echo do_shortcode( '[CIP-SM-TOKEN-HOLDER-IMPORT-PROCESS]' );
		}else if( $_GET['importmi'] == 'yes' ){
			echo do_shortcode( '[CIP-SM-MEMBER-INVOICE-IMPORT]' );
		}else if( $_GET['partialexport'] == 'yes' ){
			echo do_shortcode( '[CIP-PARTIAL-EXPORT]' );
		}else if( $_GET['partialclear'] == 'yes' ){
			echo do_shortcode( '[CIP-PARTIAL-CLEAR]' );
		}elseif( $_GET['partialimportth'] == 'yes' ){
			echo do_shortcode( '[CIP-SM-PARTIAL-TOKEN-HOLDER-IMPORT]' );
		}else{
			$exportLink = add_query_arg( 'action', 'export_smtokenholder_act', admin_url('admin-post.php') );
			$exportMILink = add_query_arg( 'action', 'export_smmemberinvoice_act', admin_url('admin-post.php') );
			$importLink = add_query_arg( 'importth', 'yes', get_permalink() );
			$importMILink = add_query_arg( 'importmi', 'yes', get_permalink() );
			
			$partialExportPage = add_query_arg( 'partialexport', 'yes', get_permalink() );
			$partialClearPage = add_query_arg( 'partialclear', 'yes', get_permalink() );
			$partialImportPage = add_query_arg( 'partialimportth', 'yes', get_permalink() );
		?>
		<style>.routine_maintenance_mode .custom-control-label { line-height: unset; text-transform: none; }</style>
		<div class="row">
			
			<div class="col-lg-4 col-md-6 col-12 text-center">
                <div class="boxDiv">
                <form class="routine_maintenance_frm" id="routine_maintenance_frm">
					<p style="margin-bottom:0;"><?php _e('Live Site Maintenance Mode',CIP_TXTDOMAIN); ?></p>
					<div class="custom-control custom-switch routine_maintenance_mode">
				      <input type="checkbox" class="custom-control-input" id="routine_maintenance_mode" name="routine_maintenance_mode" value="1" <?php echo checked( get_option('cip_routine_maintenance_mode'), 1 ); ?> />
				      <label class="custom-control-label" for="routine_maintenance_mode"><?php _e('Enable/Disable',CIP_TXTDOMAIN); ?></label>
				    </div>
					<input type="hidden" name="action" value="routine_maintenance_mode_act">
					<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XYroutinemaintenancemodeYX_'); ?>">
					<p><span class="form_response"></span></p>
				</form>
				<form class="site_maintenance_frm" id="site_maintenance_frm">
					<div class="custom-control custom-switch site_maintenance_frm">
					<p style="margin-bottom:0;"><?php _e('Whole Site Maintenance Mode',CIP_TXTDOMAIN); ?></p>
					  <input type="checkbox" class="custom-control-input" id="site_maintenance_mode" name="site_maintenance_mode" value="1" <?php echo checked( get_option('cip_site_maintenance_mode'), 1 ); ?> />
				      <label class="custom-control-label" for="site_maintenance_mode"><?php _e('Enable/Disable',CIP_TXTDOMAIN); ?></label>
				    </div>
					<input type="hidden" name="action" value="site_maintenance_mode_act">
					<input type="hidden" name="_sitemicro" value="<?php echo wp_create_nonce('_XYsite_maintenance_modeYX_'); ?>">
					<p><span class="form_response"></span></p>
				</form>
				
				<!-- <form class="retirement_maintenance_frm" id="retirement_maintenance_frm">
					<div class="custom-control custom-switch retirement_maintenance_frm">
					<p style="margin-bottom:0;"><?php _e('Retirement Maintenance Mode',CIP_TXTDOMAIN); ?></p>
					  <input type="checkbox" class="custom-control-input" id="retirement_maintenance_mode" name="retirement_maintenance_mode" value="1" <?php echo checked( get_option('cip_retirement_maintenance_mode'), 1 ); ?> />
				      <label class="custom-control-label" for="retirement_maintenance_mode"><?php _e('Enable/Disable',CIP_TXTDOMAIN); ?></label>
				    </div>
					<input type="hidden" name="action" value="retirement_maintenance_mode_act">
					<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XYretirement_maintenance_modeYX_'); ?>">
					<p><span class="form_response"></span></p>
				</form> -->
                </div>
			</div>
			
			<div class="col-lg-4 col-md-6 col-12 text-center">
                <div class="boxDiv">
                    <a href="<?php echo $exportMILink; ?>" class="btn btn-outline-primary" target="_blank"><?php _e('Export Member Invoices',CIP_TXTDOMAIN); ?></a>
					<a href="<?php echo $importMILink; ?>" class="btn btn-outline-primary mt-2"><?php _e('Import Member Invoices',CIP_TXTDOMAIN); ?></a>
				
                </div>
            </div>
			<div class="col-lg-4 col-md-6 col-12 text-center">
                <div class="boxDiv">
                    <?php $support_mode = ( !empty( get_option('cip_support_ticket_mode') ) ) ? get_option('cip_support_ticket_mode') : 'test' ; ?>
                    <form class="smsupport_endpoint" id="smsupport_endpoint" style="padding:10px;">
                        <input type="hidden" name="action" value="smsupport_endpoint_act">
                        <input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XYsmsupportendpointYX_'); ?>">
                        <div class="form-group">
                            <label for="support_ticket_mode"><?php _e('Support Ticket Mode'); ?></label>
                            <select class="form-control" name="support_ticket_mode" id="support_ticket_mode">
                                <option value="disable" <?php echo selected( $support_mode, 'disable' ); ?>><?php _e('Disable', CIP_TXTDOMAIN); ?></option>
                                <option value="live" <?php echo selected( $support_mode, 'live' ); ?>><?php _e('Live', CIP_TXTDOMAIN); ?></option>
                                <option value="test" <?php echo selected( $support_mode, 'test' ); ?>><?php _e('Test', CIP_TXTDOMAIN); ?></option>
                            </select>
                        </div>
                        <p><span class="form_response"></span></p>
                    </form>
                </div>
			</div>
		</div>
		<?php
		}
	}
	$html .= ob_get_clean();
	return $html;
}
//support manager import member invoice
add_shortcode('CIP-SM-MEMBER-INVOICE-IMPORT','cip_sm_member_invoice_import_cb');
function cip_sm_member_invoice_import_cb(){
	$html = "";
	ob_start();
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	?>
	<div class="container-fluid">
	    <div class="row justify-content-center">
	        <div class="col-10 col-sm-9 col-md-7 col-lg-10 col-xl-10 text-center p-0 mt-3 mb-2">
	            <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
	                <h2 id="heading"><?php _e('Import Member Invoice',CIP_TXTDOMAIN); ?></h2>
	                <form name="sm_import_mi_frm" class="sm_import_mi_frm" id="msform">
	                    <!-- progressbar -->
	                    <ul id="progressbar">
	                        <li class="active" id="fileupload" style="width:48%"><strong><?php _e('Choose file',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="confirm" style="width:48%"><strong><?php _e('Finish',CIP_TXTDOMAIN) ?></strong></li>
	                    </ul>
	                    <div class="progress">
	                        <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuemin="0" aria-valuemax="100"></div>
	                    </div> <br> <!-- fieldsets -->
	                    <fieldset>
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 1, 2); ?></h2>
	                                </div>
	                            </div>
	                            
	                            <label class="fieldlabels"><?php _e('Choose file',CIP_TXTDOMAIN); ?></label> <input type="file" name="mi_csv_file" accept=".csv"  required />
	                        </div>
	                        <input type="button" name="next" class="next action-button" value="Next" />
	                    
	                    </fieldset>
	                    <fieldset>
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 2, 2); ?></h2>
	                                </div>
	                            </div>
	                            <div class="row justify-content-center">
	                                <div class="col-12 text-center import_update_response"></div>
	                            </div>
	                            <?php
	                            $user_id = get_current_user_id();
	                            $filename = $user_id . '_' . 'cip_import.log';
								$logFile = CIP_PLUGIN_BASE.$filename;
								$importLink = add_query_arg( 'importmi', 'yes', get_permalink() );
								?>
	                            <div class="row justify-content-center">
	                            	<a class="btn btn-success mr-5" href="<?php echo $importLink; ?>"><?php echo __('Reupload file',CIP_TXTDOMAIN); ?></a>
		                            <?php if( file_exists( $logFile ) ){ ?>
		                            	<a class="btn btn-info" href="<?php echo CIP_PLUGIN_FOLDER.$filename; ?>" download><?php echo __('Download log',CIP_TXTDOMAIN); ?></a>
		                            <?php } ?>
	                            </div>
	                        </div>
	                    </fieldset>
	                    <input type="hidden" name="action" value="cip_sm_import_mi_csv_act" />
	                    <input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxYSMmiimportMSYxCIP_'); ?>" />
	                </form>
	            </div>
	        </div>
	    </div>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
//support manager import token holders
add_shortcode('CIP-SM-LOGS-VIEW','cip_sm_logs_view_cb');
function cip_sm_logs_view_cb(){
	$html = "";
	ob_start();
	global $wpdb;
	$logTable = $wpdb->prefix.'cip_logs';
	$getLogs = $wpdb->get_results( "SELECT * FROM $logTable WHERE log_type != 'api_track' ORDER BY id desc LIMIT 10" );
	if( current_user_can('supportagent') && $getLogs ){
			wp_enqueue_style( 'cip-css' );
			wp_enqueue_style( 'bs-table' );
			wp_enqueue_style( 'bs-sticky-header' );
			wp_enqueue_style( 'bs-datepicker' );
			wp_enqueue_script('bs-table');
			wp_enqueue_script('bs-sticky-header');
			wp_enqueue_script('bs-table-filter-control');
			?>
			<div class="log-cs-table">
			<table id="cip_logs_table" data-filter-control="true" data-show-search-clear-button="true" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="true" data-show-columns-toggle-all="true" data-show-export="false" data-click-to-select="true" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
		  <thead>
				<tr>
					<th data-field="logs" data-sortable="true" data-filter-control="input" class="logs"><?php _e('Logs',CIP_TXTDOMAIN); ?><div class="log_data"><div></th>
					<th data-field="user_type" data-sortable="true" data-filter-control="select" class="user_type" data-filter-data="var:filterLogType"><?php _e('Log Type',CIP_TXTDOMAIN); ?></th>
					<th data-field="_date" data-sortable="true" data-filter-control="input" class="_date"><?php _e('Date',CIP_TXTDOMAIN); ?></th>
				</tr>
			</thead>
	  	</table>
		</div>
		  <div class="modal fade" id="logsFilterModal" tabindex="-1" role="dialog" aria-labelledby="logsFilterModal" aria-hidden="true">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">
			<form class="filter_by_logs" name="filter_by_logs" id="filter_by_logs">
				<div class="modal-body">
					<div class="form-group">
						<label for="filter_by_condition_logs">Filter by condition</label>
						<select class="form-control" name="filter_condition_type_logs" id="filter_condition_type_logs">
							<option value=""><?php _e(' ', CIP_TXTDOMAIN); ?></option>
							<option value="logged"><?php _e('Logged', CIP_TXTDOMAIN); ?></option>
							<option value="import csv"><?php _e('Import', CIP_TXTDOMAIN); ?></option>
							<option value="update csv "><?php _e('Update csv ', CIP_TXTDOMAIN); ?></option>
							<option value="update profile"><?php _e('Update profile', CIP_TXTDOMAIN); ?></option>
							<option value="export invoices"><?php _e('Export invoices', CIP_TXTDOMAIN); ?></option>
							<option value="maintenance mode"><?php _e('Maintenance mode', CIP_TXTDOMAIN); ?></option>
							<option value="clear member invoice"><?php _e('Clear member invoice', CIP_TXTDOMAIN); ?></option>
							<option value="price added"><?php _e('Price added', CIP_TXTDOMAIN); ?></option>
							<option value="package"><?php _e('Package', CIP_TXTDOMAIN); ?></option>
							<option value="province"><?php _e('Province', CIP_TXTDOMAIN); ?></option>
							<option value="bank accounts"><?php _e('Bank account', CIP_TXTDOMAIN); ?></option>
							<option value="withdrawal"><?php _e('Withdrawal', CIP_TXTDOMAIN); ?></option>
							<option value="deposit"><?php _e('Deposit', CIP_TXTDOMAIN); ?></option>
						</select>
						<textarea name="filter_condition_value_logs_bulk" id="filter_condition_value_logs_bulk" class="form-control mt-2" rows="3" placeholder="<?php _e('Write Here', CIP_TXTDOMAIN ); ?>"></textarea>
					</div>
				</div>
				<div class="modal-footer">
		        	<button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
		        	<button type="button" class="btn btn-secondary filter_csr_cancel" onclick="jQuery('#logsFilterModal').modal('hide');"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
				</div>
			</form>
			<script>
				jQuery(window).on("load",function(){
					jQuery(".logs .filter-control").on("click",function(){
						jQuery('#logsFilterModal').modal({
							show: true
						});
					});
					function log_data_update() {
						var $pool_ref = jQuery('input.bootstrap-table-filter-control-logs[type="search"]');
						let eve = jQuery.Event("keyup");
						console.log("test2");
						eve.which = 13
						eve.keyCode = 13
						$pool_ref.trigger(eve);
						jQuery('#logsFilterModal').modal('hide');
						var filterNoteForm = jQuery('#filter_by_logs');
						var condition_type_text = filterNoteForm.find('select[name="filter_condition_type_logs"] option:selected').text();
						var condition_type = filterNoteForm.find('select[name="filter_condition_type_logs"] option:selected').val();
						var condition_type_value = filterNoteForm.find('select#filter_condition_value_logs_bulk').val();
						var condition_type_value_bulk = filterNoteForm.find('textarea#filter_condition_value_logs_bulk').val();
						var filterText = condition_type_text;
						if( condition_type_value != "" || condition_type_value_bulk != '' ){
							if( condition_type == 'is_exactly_simple' ){
								filterText += ': '+condition_type_value_bulk;
							}else{
								filterText += ': '+condition_type_value_bulk;
							}
						}
						if( condition_type_text == 'None' ){
							filterText = "";
						}
						if(filterText == ' : '){
							filterText = "";
						}
						jQuery('body').find('.log_data').show();
						jQuery('body').find('.log_data').text( filterText );
					};
					jQuery(".log-cs-table [name='clearSearch']").on("click",function(e){
						document.getElementById("filter_by_logs").reset();
						jQuery('body').find('.log_data').hide();
						log_data_update();
					});
					jQuery(document).on('click', '.filter_by_logs .filter_csr_ok', function(){ //pool ref
						log_data_update();
					});
				});
			</script>
		    </div>
		  </div>
		</div>
	<?php }
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CIP-SM-VATAPI-LOGS-VIEW','cip_sm_euvatapi_logs_view_cb');
function cip_sm_euvatapi_logs_view_cb(){
	$html = "";
	ob_start();
	global $wpdb;
	$logTable = $wpdb->prefix.'cip_logs';
	$getLogs = $wpdb->get_var( "SELECT COUNT(id) FROM $logTable WHERE log_type = 'api_track' ORDER BY id desc" );
	if( current_user_can('supportagent') && $getLogs ){
			wp_enqueue_style( 'cip-css' );
			wp_enqueue_style( 'bs-table' );
			wp_enqueue_style( 'bs-sticky-header' );
			wp_enqueue_style( 'bs-datepicker' );
			wp_enqueue_script('bs-table');
			wp_enqueue_script('bs-sticky-header');
			wp_enqueue_script('bs-table-filter-control');
			?>
			<table id="euvatapi_logs_table" data-filter-control="false" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
			<thead>
				<tr>
					<th data-field="id" data-sortable="true" data-filter-control="input" class="id"><?php _e('ID',CIP_TXTDOMAIN); ?></th>
					<th data-field="logs" data-sortable="true" data-filter-control="input" class="logs"><?php _e('Logs',CIP_TXTDOMAIN); ?></th>
					<th data-field="log_type" data-sortable="true" data-filter-control="select" class="log_type" data-filter-custom-search="BsTableFilterStatus"><?php _e('Log Type',CIP_TXTDOMAIN); ?></th>
					<th data-field="_date" data-sortable="true" data-filter-control="input" class="_date"><?php _e('Date',CIP_TXTDOMAIN); ?></th>
				</tr>
			</thead>
			<tbody>
			</tbody>
		</table>
	<?php }
	$html .= ob_get_clean();
	return $html;
}
//REGISTER USER SHORTCODE
add_shortcode( 'CIP_user_register', 'CIP_user_register' );
function CIP_user_register() {
    require("user_registration.php");
    //Calling Register User Function
    CIP_user_registration_function();
}
//REGISTER BUY PACKAGE SHORTCODE
add_shortcode( 'CIP_buy_package', 'CIP_buy_package' );
function CIP_buy_package() {
    require("buy.php");
    //Calling Register User Function
    cip_buy_package_function();
}
//REGISTER CREATE BANK ACCOUNT BY SM SHORTCODE
add_shortcode( 'SM_add_bank_account', 'SM_add_bank_account' );
function SM_add_bank_account() {
    require("SM_Bank_Accounts_management/create_account_form.php");
    //Calling CREATE BANK ACCOUNT Function
    sm_create_account_form();
}
//REGISTER MANAGE/UPDATE BANK ACCOUNT BY SM SHORTCODE
add_shortcode( 'SM_manage_bank_account', 'SM_manage_bank_account' );
function SM_manage_bank_account() {
    require("SM_Bank_Accounts_management/sm_manage_account_details.php");
    //Calling CREATE BANK ACCOUNT Function
    sm_manage_account_details();
}
//REGISTER CREATE BANK ACCOUNT BY SM SHORTCODE
add_shortcode( 'sm_show_account_details', 'sm_show_account_details_function' );
function sm_show_account_details_function() {
    require("SM_Bank_Accounts_management/show_account_details.php");
    //Calling CREATE BANK ACCOUNT Function
    sm_show_account_details();
}
//REGISTER Show Single BANK ACCOUNT Details BY SM SHORTCODE
add_shortcode( 'sm_view_single_account', 'sm_show_single_account_details_function' );
function sm_show_single_account_details_function() {
    require("SM_Bank_Accounts_management/sm_view_single_account.php");
    //Calling CREATE BANK ACCOUNT Function
    sm_view_single_account();
}
//REGISTER Show Member Invoices  BY SA SHORTCODE
add_shortcode( 'sa_view_member_invoice', 'sa_view_member_invoice' );
function sa_view_member_invoice() {
    require("SA_pro_forma_invoices/sa_show_invoices.php");
    sa_member_invoice();
}
// REDIRECTION TO DIFFERENT PAGES AFTER LOGIN BASED ON USER ROLE
add_action('template_redirect', 'cors_after_login_redirect');
function cors_after_login_redirect() {
	$current_user = wp_get_current_user();
    $user_roles = $current_user->roles;
    $user_role = array_shift($user_roles);
	$sa_url = get_permalink( get_page_by_title( 'Support Agent Dashboard' ) );
	$sm_url = get_permalink( get_page_by_title( 'Support Manager Dashboard' ) );
	$member_url = get_permalink( get_page_by_title( 'CSR Holder Dashboard' ) );
	$site = get_site_url();
    if ( is_user_logged_in() ) {
   	  if( is_page('Lobby')) {
   		  if ($user_role == 'supportagent') {
   			  wp_redirect($sa_url);
   		  }
   		 else if($user_role == 'supportmanager'){
   			  wp_redirect($sm_url);
   		  }
   		  else if($user_role == 'member'){
   			  wp_redirect($member_url);
   		  }
  	  }
    }
}
// END CODE SECTION
// Register a cip_member_invoice shortcode: [cip_member_invoice]
add_shortcode( 'cip_member_invoice', 'cip_member_invoice_function' );
function cip_member_invoice_function(){
    require("member_invoices.php");
    //Calling Register Support Manager Function
    cip_member_invoice();
}
add_shortcode( 'cip_member_invoice_server_side', 'cip_member_invoice_server_side_function' );
function cip_member_invoice_server_side_function(){
    $html = "";
    global $wpdb;
    $wpdb_prefix = $wpdb->prefix;
    $invoice= $wpdb_prefix.'cip_member_invoice';
    $e_mail=$_SESSION['refAccount'];
	$body = [
		'email'	=>	$e_mail,
	];
	$response_user = amplivo_api_send_requests( $body, 'get-user-data');
	$result_user = $response_user['result'];
	$registrationDate = $result_user['registration_date'];
	$registrationTimestamp = strtotime($registrationDate);
	
    wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'bs-datepicker' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('tbl-ex-js');
	wp_enqueue_script('jspdf');
	wp_enqueue_script('pdf-autotable-js');
	wp_enqueue_script('ex-js');
	wp_enqueue_script('bs-datepicker');
	ob_start();
    if( (isset( $_GET['fromdate'] ) && isset( $_GET['todate'] )) && (!empty( $_GET['fromdate'] ) && !empty( $_GET['todate'] )) ){
        $invoice_record = ("SELECT * FROM $invoice WHERE ( STR_TO_DATE(Date,'%d-%m-%y') >= STR_TO_DATE('" . $_GET['fromdate'] . "', '%d-%m-%y') AND STR_TO_DATE(Date,'%d-%m-%y') <= STR_TO_DATE('" . $_GET['todate'] . "', '%d-%m-%y') ) WHERE Email='$e_mail' AND Status = 'Paid'");
    }else{
        $invoice_record = "SELECT * FROM $invoice WHERE Email='$e_mail' AND Status = 'Paid' ORDER BY `id` DESC";
    }
    $invoice_result = $wpdb->get_results($invoice_record);
            ?>
            <style>
                .canada-text-div {
                    position: absolute;
                    height: 60px;
                    text-align: right;
                    display: flex;
                    align-items: center;
                    width: calc(100% - 220px);
                    justify-content: flex-end;
                }
                .canada-text-div a{
                    color: #1c3750;
                    font-weight: 600;
                }
            </style>
			<?php
				// Set the comparison date (April 25, 2024)
				$comparisonDate = "2024-05-1";
				$comparisonTimestamp = strtotime($comparisonDate);
				if ($registrationTimestamp < $comparisonTimestamp) {
			?>
            <div class="canada-text-div">For transactions before 1st May 2024 visit &nbsp;<a href="<?php echo get_ampliov_link_url(); ?>">https://amplivo.com</a></div>
		   	<?php
				}
			?>
			<div class="scroll">
			
            <table id="member_invoice_list"  data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-sortable="true" data-toggle="table" data-show-columns="true" data-show-columns-toggle-all="true" data-show-toggle="false" data-show-export="true" data-export-types="['csv', 'pdf']" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
            <thead>
				<tr>
					<th data-field="id" data-filter-control="input" data-sortable="true" class="id" data-switchable="false" data-width="50" data-width-unit="px"><?php _e('#', CIP_TXTDOMAIN); ?></th>
					<th data-field="token" data-filter-control="select" data-filter-data="var:pricetypeselect" data-sortable="true" class="token"><?php _e('Token', CIP_TXTDOMAIN); ?></th>
                    <th data-field="InvoiceNumber" data-filter-control="input" data-sortable="true" class="InvoiceHash"><?php _e('Invoice #', CIP_TXTDOMAIN); ?></th>
                    <th data-field="PaidDate" data-filter-control="input" data-sortable="true" class="InvoiceDate"><?php _e('Date', CIP_TXTDOMAIN); ?></th>
                    <th data-field="Package" data-filter-control="input" data-filter-custom-search="BsTableFilterStatus" data-sortable="true" class="frequency"><?php _e('Frequency', CIP_TXTDOMAIN); ?></th>
                    <th data-field="Description" data-filter-control="input" data-sortable="true" class="Description"><?php _e('Description', CIP_TXTDOMAIN); ?></th>
                    <th data-field="username" data-visible="false" data-filter-control="input" data-sortable="true" class="Username"><?php _e('Username', CIP_TXTDOMAIN); ?></th>
                    <th data-field="Name" data-visible="false" data-filter-control="input" data-sortable="true" class="Name"><?php _e('Name', CIP_TXTDOMAIN); ?></th>
                    <th data-field="Address1" data-visible="false" data-filter-control="input" data-sortable="true" class="Address"><?php _e('Address', CIP_TXTDOMAIN); ?></th>
                    <th data-field="Kgs" data-filter-control="input" data-sortable="true" class="kgs"><?php _e('Kgs', CIP_TXTDOMAIN); ?></th>
                    <th data-field="csr" data-filter-control="input" data-sortable="true" class="csr"><?php _e('CSR', CIP_TXTDOMAIN); ?></th>
                    <th data-field="GrossAmount" data-filter-control="input" data-sortable="true" class="Price"><?php _e('(€) Price', CIP_TXTDOMAIN); ?></th>
                    <th data-field="PriceCAD" data-filter-control="input" data-sortable="true" class="PriceCAD"><?php _e('Price (CAD)', CIP_TXTDOMAIN); ?></th>
                    <th data-field="ExchangeRate" data-filter-control="input" data-sortable="true" class="ExchangeRate"><?php _e('Exchange rate', CIP_TXTDOMAIN); ?></th>
                    <th data-field="GSTPrice" data-filter-control="input" data-sortable="true" class="GSTCAD"><?php _e('GST/HST (CAD)', CIP_TXTDOMAIN); ?></th>
                    <th data-field="QSTPrice" data-filter-control="input" data-sortable="true" class="QSTCAD"><?php _e('PST (CAD)', CIP_TXTDOMAIN); ?></th>
                    <th data-field="TotalCAD" data-filter-control="input" data-sortable="true" class="TotalCAD"><?php _e('Total (CAD)', CIP_TXTDOMAIN); ?></th>
                    <th data-field="giftcode" data-filter-control="input" data-sortable="true" class="giftcode"><?php _e('Gift code', CIP_TXTDOMAIN); ?></th>
                    <!-- <th data-field="giftcode_status" data-filter-control="input" data-sortable="true" class="giftcode_status"><?php _e('Gift code status', CIP_TXTDOMAIN); ?></th> -->
                   						
                    <th data-field="action" data-switchable="false">Action</th>																												
				</tr>
            </thead>
            </table><br>
			  </div>  	
			  <script>
			
			var pricetypeselect = {
				'CSR':'CSR',
				'CSR25':'CSR25',
			};
		</script>		      

        <?php   
        $html .= ob_get_clean();
        echo $html;
}
add_shortcode( 'cip_sa_member_invoice_server_side', 'cip_sa_member_invoice_server_side_function' );
function cip_sa_member_invoice_server_side_function(){
    $html = "";
    global $wpdb;
    $wpdb_prefix = $wpdb->prefix;
    $invoice= $wpdb_prefix.'cip_member_invoice';
    $e_mail=$_SESSION['refAccount'];
	$body = [
		'email'	=>	$e_mail,
	];
	$response_user = amplivo_api_send_requests( $body, 'get-user-data');
	$result_user = $response_user['result'];
	$registrationDate = $result_user['registration_date'];
	$registrationTimestamp = strtotime($registrationDate);
	
    wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'bs-datepicker' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_style( 'daterangepicker-style' );
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('tbl-ex-js');
	wp_enqueue_script('jspdf');
	wp_enqueue_script('pdf-autotable-js');
	wp_enqueue_script('ex-js');
	wp_enqueue_script('bs-datepicker');
	wp_enqueue_script('dr-moment');

	wp_enqueue_script('daterangepicker-script');

	ob_start();
    if( (isset( $_GET['fromdate'] ) && isset( $_GET['todate'] )) && (!empty( $_GET['fromdate'] ) && !empty( $_GET['todate'] )) ){
        $invoice_record = ("SELECT * FROM $invoice WHERE ( STR_TO_DATE(Date,'%d-%m-%y') >= STR_TO_DATE('" . $_GET['fromdate'] . "', '%d-%m-%y') AND STR_TO_DATE(Date,'%d-%m-%y') <= STR_TO_DATE('" . $_GET['todate'] . "', '%d-%m-%y') ) WHERE Email='$e_mail' AND Status = 'Paid'");
    }else{
        $invoice_record = "SELECT * FROM $invoice WHERE Email='$e_mail' AND Status = 'Paid' ORDER BY `id` DESC";
    }
    $invoice_result = $wpdb->get_results($invoice_record);
		?>
		<style>
			.canada-text-div {
				position: absolute;
				height: 60px;
				text-align: right;
				display: flex;
				align-items: center;
				width: calc(100% - 220px);
				justify-content: flex-end;
			}
			.canada-text-div a{
				color: #1c3750;
				font-weight: 600;
			}
			button#download_invoice_report_and_summery_button {
			    position: absolute;
			    top: 10px;
			    right: 182px;
			}
			.daterangepicker.ltr.show-calendar.opensleft button.applyBtn.btn.btn-sm.btn-primary {
		        padding: 8px 30px !important;
			    text-transform: capitalize !important;
			    font-weight: bold !important;
			    font-size: 12px !important;
			}
			.daterangepicker.ltr.show-calendar.opensleft button.btn {
			    font-family: "Poppins", Sans-serif !important;
			}
		</style>
		<?php
			// Set the comparison date (April 25, 2024)
			$comparisonDate = "2024-05-1";
			$comparisonTimestamp = strtotime($comparisonDate);
			if ($registrationTimestamp < $comparisonTimestamp) {
		?>
		<!-- <div class="canada-text-div">For transactions before 1st May 2024 visit &nbsp;<a href="<?php echo get_ampliov_link_url(); ?>">https://amplivo.com</a></div> -->
		<?php
			}
		?>
		<div class="scroll export_invoice_table_body">
		<button id="export_invoice_button" class="btn btn-primary"><i class="fas fa-file-download"></i></button>
		<button id="download_invoice_report_and_summery_button" class="btn btn-primary">Download Invoice Report</button>
		<table id="sa_member_invoice_list"  data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-sortable="true" data-toggle="table" data-show-columns="true" data-show-columns-toggle-all="true" data-show-toggle="false" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
				<thead>
					<tr>
						<th data-field="id" data-filter-control="input" data-sortable="true" class="id" data-switchable="false" data-width="50" data-width-unit="px"><?php _e('#', CIP_TXTDOMAIN); ?></th>
						<th data-field="token" data-filter-control="select" data-filter-data="var:pricetypeselect" data-sortable="true" class="token"><?php _e('Token', CIP_TXTDOMAIN); ?></th>
						<th data-field="InvoiceNumber" data-filter-control="input" data-sortable="true" class="inumber"><?php _e('Invoice #', CIP_TXTDOMAIN); ?></th>
						<th data-field="PaidDate" data-filter-control="input" data-sortable="true" class="pdate"><?php _e('Date', CIP_TXTDOMAIN); ?></th>
						<th data-field="Package" data-filter-control="input" data-filter-custom-search="BsTableFilterStatus" data-sortable="true" class="frequency"><?php _e('Frequency', CIP_TXTDOMAIN); ?></th>
						<th data-field="Description" data-filter-control="input" data-sortable="true" class="Description"><?php _e('Description', CIP_TXTDOMAIN); ?></th>
						<th data-field="Email" data-filter-control="input" data-sortable="true" class="email"><?php _e('Email', CIP_TXTDOMAIN); ?></th>
						<th data-field="username" data-filter-control="input" data-sortable="true" class="Username"><?php _e('Username', CIP_TXTDOMAIN); ?></th>
						<th data-field="FirstName" data-filter-control="input" data-sortable="true" class="Name"><?php _e('Name', CIP_TXTDOMAIN); ?></th>
						<th data-field="Address1" data-filter-control="input" data-sortable="true" class="Address"><?php _e('Address', CIP_TXTDOMAIN); ?></th>
							<th data-field="State" data-filter-control="input" data-sortable="true" class="State"><?php _e('State', CIP_TXTDOMAIN); ?></th>
						
						<th data-field="Kgs" data-filter-control="input" data-sortable="true" class="kgs"><?php _e('Kgs', CIP_TXTDOMAIN); ?></th>
						<th data-field="csr" data-filter-control="input" data-sortable="true" class="csr"><?php _e('CSR', CIP_TXTDOMAIN); ?></th>
						<th data-field="GrossAmount" data-filter-control="input" data-sortable="true" class="price"><?php _e('(€) Price', CIP_TXTDOMAIN); ?></th>

						<th data-field="ExchangeRate" data-filter-control="input" data-sortable="true" class="ExchangeRate"><?php _e('Exchange rate', CIP_TXTDOMAIN); ?></th>
						<th data-field="PriceCAD" data-filter-control="input" data-sortable="true" class="PriceCAD"><?php _e('Price (CAD)', CIP_TXTDOMAIN); ?></th>
						<th data-field="GSTCAD" class="GSTCAD"><?php _e('GST/HST (CAD)', CIP_TXTDOMAIN); ?></th>
						<th data-field="QSTCAD" class="QSTCAD"><?php _e('PST (CAD)', CIP_TXTDOMAIN); ?></th>

						<th data-field="TotalCAD" data-filter-control="input" data-sortable="true" class="TotalCAD"><?php _e('Total (CAD)', CIP_TXTDOMAIN); ?></th>

						<th data-field="giftcode" data-filter-control="input" data-sortable="true" class="giftcode"><?php _e('Gift code', CIP_TXTDOMAIN); ?></th>
						<!-- <th data-field="giftcode_status" data-filter-control="input" data-sortable="true" class="giftcode_status"><?php _e('Gift code status', CIP_TXTDOMAIN); ?></th> -->

						
                        <!-- <th data-field="status" data-filter-control="select" data-sortable="true" data-filter-data="var:archivestatusoption" class="status"><?php _e('Status', CIP_TXTDOMAIN); ?></th> -->
                        <th data-field="status"  data-sortable="true" class="status"><?php _e('Status', CIP_TXTDOMAIN); ?></th>
						<!--<th data-field="ArchiveStatus" data-filter-control="select" data-sortable="true" data-filter-data="var:archivestatusoption" class="archive_status"><?php _e('Archive status', CIP_TXTDOMAIN); ?></th>-->
						<th data-field="action" data-switchable="false"><?php _e('Action', CIP_TXTDOMAIN); ?></th>	

					</tr>
					</thead>
			</table><br>
		<style>
			.custom-switch .custom-control-label::before,.custom-switch .custom-control-label::after{
				margin-top: 0 !important;
			}
			.GSTCAD,.QSTCAD {
				vertical-align: top !important;
			}
		</style>
		<script>
			var archivestatusoption = {
				'Paid':'Paid',
				'Un-Paid':'Un-Paid',
			};
			var pricetypeselect = {
				'CSR':'CSR',
				'CSR25':'CSR25',
			};

		</script>
			</div>  			      

	<?php   
	$html .= ob_get_clean();
	echo $html;
}
// Register a view_invoice shortcode: [view_invoice]
add_shortcode( 'view_invoice', 'view_invoice_function' );
function view_invoice_function(){
   if(isset($_GET['key'])){
	$id = $_GET['key'];
	$path = get_site_url();
	?>
	<div style="text-align:center;">
		<a class="ml-2" title="View Invoice" target="_blank" href="<?php echo $path; ?>/wp-content/plugins/cip-helper/includes/pdf/download_pdf.php/?key=<?php echo $id; ?>&paid=1" style="color:#fff;text-decoration:none;">View Invoice</a>
	</div>
	<script type = "text/javascript" >  
		function preventBack() { window.history.forward(); }  
		setTimeout("preventBack()", 0);  
		window.onunload = function () { null };  
	</script>
	<?php
	}
}
add_shortcode( 'YOUR-GIFT-CODE', 'view_invoice_your_gift_code_function' );
function view_invoice_your_gift_code_function(){
   $html = "";
   ob_start();
	if(isset($_GET['key'])){
		$id = $_GET['key'];
		global $wpdb;
		$tableInvoice = $wpdb->prefix.'cip_member_invoice';
		$getGiftCodeData = $wpdb->get_row("SELECT * FROM $tableInvoice WHERE `UniqueKey`='". $id ."'");
		if( $getGiftCodeData ){
			?><p>Your Gift code is <?php echo $getGiftCodeData->giftcode; ?></p>
			  <p>To redeem your gift code visit <a href="<?php echo  get_ampliov_link_url();?>" style="color: #1c3750;"><strong>amplivo.com</strong></a></p>
			<?php
		}
	}
	$html .= ob_get_clean();
	return $html;
}
//support manager api control
add_shortcode('SM-VAT-API-SETTING-OPTION','cip_sm_vat_api_setting_option_cb');
function cip_sm_vat_api_setting_option_cb(){
	$html = "";
	ob_start();
	if( current_user_can('supportagent') ){
		$euvatapi_access_key = ( !empty( get_option('euvatapi_access_key') ) ) ? get_option('euvatapi_access_key') : '9d5cb137a12069fb87aada7a82dc21a3' ;
		$euvatapi_ip_address = ( !empty( get_option('euvatapi_ip_address') ) ) ? get_option('euvatapi_ip_address') : '' ;
		$selling_price_csr = ( !empty( get_option('selling_price_csr') ) ) ? get_option('selling_price_csr') : 0.025 ;
		$selling_kgs = ( !empty( get_option('selling_kgs') ) ) ? get_option('selling_kgs') : 1;
		$selling_price_csr_inc = ( !empty( get_option('selling_price_csr_inc') ) ) ? get_option('selling_price_csr_inc') : 0;
		//echo $selling_price_csr_inc;
		$amplivo_api_mode = ( !empty( get_option('amplivo_api_mode') ) ) ? get_option('amplivo_api_mode') : 'test';
	?>
	<form name="sm_api_settings" id="sm_api_settings">
		
		<div class="row">
			<div class="col-6">
				<div class="form-group">
					<label for="amplivo_api_mode"><?php echo __("API Mode" , "corsair-login"); ?></label>
					<select id="amplivo_api_mode" name="amplivo_api_mode" class="regular-text form-control">
						<option value="test" <?php echo selected( $amplivo_api_mode, 'test' ); ?>><?php _e('Test', CIP_TXTDOMAIN); ?></option>
						<option value="live" <?php echo selected( $amplivo_api_mode, 'live' ); ?>><?php _e('Live', CIP_TXTDOMAIN); ?></option>
					</select>
				</div>
			</div>
		</div>
		
		<div class="row">
			<div class="col-6">
				<div class="form-group">
					<label for="amplivo_api_test_source_url"><?php echo __("Amplivo Test API Source" , "corsair-login"); ?></label>
					<input type="text" id="amplivo_api_test_source_url" name="amplivo_api_test_source_url"  value="<?php echo get_option( 'amplivo_api_test_source_url' ); ?>" class="regular-text form-control" pattern=".*\S+.*"/>
				</div>
			</div>
			<div class="col-6">
				<div class="form-group">
					<label for="amplivo_api_live_source_url"><?php echo __("Amplivo Live API Source" , "corsair-login"); ?></label>
					<input type="text" id="amplivo_api_live_source_url" name="amplivo_api_live_source_url"  value="<?php echo get_option( 'amplivo_api_live_source_url' ); ?>" class="regular-text form-control" pattern=".*\S+.*"/>
				</div>
			</div>
		</div>
		
		<div class="row">
			<div class="col-6">
				<div class="form-group">
					<label for="amplivo_api_auth_username"><?php echo __("Amplivo API Auth Username" , "corsair-login"); ?></label>
					<input type="text" id="amplivo_api_auth_username" name="amplivo_api_auth_username"  value="<?php echo get_option( 'amplivo_api_auth_username' ); ?>" class="regular-text form-control" pattern=".*\S+.*"/>
				</div>
			</div>
			<div class="col-6">
				<div class="form-group">
					<label for="amplivo_api_auth_pwd"><?php echo __("Amplivo API Auth Password" , "corsair-login"); ?></label>
					<input type="text" id="amplivo_api_auth_pwd" name="amplivo_api_auth_pwd"  value="<?php echo get_option( 'amplivo_api_auth_pwd' ); ?>" class="regular-text form-control" pattern=".*\S+.*"/>
				</div>
			</div>
		</div>
		<div class="form-group hide">
			<label for="selling_price_csr"><?php _e('Selling Price of CSR', CIP_TXTDOMAIN); ?></label>
			<input type="number" class="form-control" step="0.00001" id="selling_price_csr" value="<?php echo $selling_price_csr; ?>" disabled>
		</div>
		<div class="form-group" style="display:none;">
			<label for="selling_kgs"><?php _e('Kgs by 1 EUR', CIP_TXTDOMAIN); ?></label>
			<input type="number" class="form-control" step="0.01" name="selling_kgs" id="selling_kgs" value="<?php echo $selling_kgs; ?>">
		</div>
		<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
		<input type="hidden" name="action" value="cip_sm_api_settings_act" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsmapisettingxCIP_'); ?>" />
		<p class="form_response"></p>
	</form>
	<?php
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('SM-CSR-SCHEDULER','cip_sm_csr_scheduler_cb');
function cip_sm_csr_scheduler_cb(){
    if( current_user_can( 'supportagent' ) ){
	$html = "";
	global $wpdb;
	$tableScheduler = $wpdb->prefix.'csr_scheduler';
	wp_enqueue_style( 'jquery-ui-style' );
	wp_enqueue_style( 'jquery-ui-timepicker-style' );
	wp_enqueue_script('jquery-ui');
	wp_enqueue_script('jquery-ui-timepicker');
	wp_enqueue_script('jquery-ui-sliderAccess');
	wp_enqueue_script('moment');
	wp_enqueue_style( 'bs-table' );
	ob_start();
	$add_csr_url = add_query_arg( 'action', 'add', get_permalink() );
	if( isset( $_GET['action'] ) && $_GET['action'] == 'add' ){	// add csr plans
	?>
	<div class="row">
	<div class="col-12">
		<form name="cip_schedule_changer" id="cip_schedule_changer">
		<div class="form-row">
			<div class="form-group col-md-12">
				<label for="selling_price_csr"><?php _e('Selling Price of CSR*',CIP_TXTDOMAIN); ?></label>
				<input type="number" step="0.00001" class="form-control" name="selling_price_csr" id="selling_price_csr" />
			</div>
			<div class="form-group col-md-12">
				<label for="price_type"><?php _e('Type*',CIP_TXTDOMAIN); ?></label>
				<select name="price_type" class="form-select">
					<option value="" selected disabled><?php _e('Choose option',CIP_TXTDOMAIN); ?></option>
					<option value="prompt"><?php _e('Prompt',CIP_TXTDOMAIN); ?></option>
					<option value="scheduled"><?php _e('Scheduled',CIP_TXTDOMAIN); ?></option>
				</select>
			</div>
			<div class="form-group col-md-8 time_schedule" style="display:none;">
				<label for="schedule_time"><?php _e('Schedule date*',CIP_TXTDOMAIN); ?></label>
				<input type="text" class="form-control" name="schedule_time" id="schedule_time" />
				<input type="hidden" class="form-control" name="schedule_time_alt" id="schedule_time_alt" />
			</div>
			<div class="form-group col-md-2 time_schedule" style="display:none;">
				<label for="schedule_hours"><?php _e('Hours*',CIP_TXTDOMAIN); ?></label>
				<select name="schedule_hours" class="form-control">
					<?php for ($h = 0; $h < 24; $h++) printf("<option value=\"%02d\"" . (!$h ? " selected" : "") . ">%02d</option>", $h, $h); ?>
				</select>
			</div>
			<div class="form-group col-md-2 time_schedule" style="display:none;">
				<label for="schedule_minutes"><?php _e('Minutes*',CIP_TXTDOMAIN); ?></label>
				<select name="schedule_minutes" class="form-control">
					<?php for ($m = 0; $m < 60; $m++) printf("<option value=\"%02d\"" . (!$m ? " selected" : "") . ">%02d</option>", $m, $m); ?>
				</select>
			</div>
		</div>
		<button type="submit" class="btn btn-primary"><?php _e('Add', CIP_TXTDOMAIN); ?></button>
		<input type="hidden" name="action" value="cip_add_csr_scheduler" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsmCSRScheduleraddxCIP_'); ?>" />
		<p class="form_response"></p>
		</form>
	</div>
	</div>
	<?php
	}else if( isset( $_GET['action'] ) && $_GET['action'] == 'edit' && $_GET['pid'] != "" ){	// add saving plans
	}else{ //display added saving plans
	?>
	<!-- <div class="row add_new_sm_csr_scheduler">
		<div class="col-12 text-right mt-3">
			<a href="<?php echo $add_csr_url; ?>" class="btn btn-primary"><?php _e('Add New',CIP_TXTDOMAIN); ?></a>
		</div>
	</div> -->
	<?php
		$getSchedulers = $wpdb->get_results("SELECT * FROM $tableScheduler order by id desc");
		wp_enqueue_style( 'cip-css' );
		wp_enqueue_style( 'bs-table' );
		wp_enqueue_style( 'bs-sticky-header' );
		wp_enqueue_script('bs-table');
		wp_enqueue_script('bs-sticky-header');
		wp_enqueue_script('bs-table-filter-control');
		?>
		<table id="cip_saving_plans_table"
		data-filter-control="true"
		data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="true" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered">
		<thead>
			<tr>
				<th data-field="id" data-sortable="false" class="plan_id"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
				<th data-field="csr_price" data-sortable="true" data-filter-control="input" class="csr_price"><?php _e('CSR Price',CIP_TXTDOMAIN); ?></th>
				<th data-field="type" data-sortable="true" data-filter-control="input" class="type"><?php _e('Type',CIP_TXTDOMAIN); ?></th>
				<th data-field="create_date" data-sortable="true" data-filter-control="input" class="create_date"><?php _e('Created',CIP_TXTDOMAIN); ?></th>
				<th data-field="start_date" data-sortable="true" data-filter-control="input" class="start_date"><?php _e('Start date',CIP_TXTDOMAIN); ?></th>
				<th data-field="status" data-sortable="false" data-filter-control="false" class="status"><?php _e('Status',CIP_TXTDOMAIN); ?></th>
				<!-- <th data-field="action" data-sortable="false" data-filter-control="false" class="action"><?php _e('Action',CIP_TXTDOMAIN); ?></th> -->
			</tr>
		</thead>
	<?php
		$loopCount = 1;
		if( $getSchedulers ){
			foreach( $getSchedulers as $getScheduler ){
				$delete_link = '';
				$edit_plan_url = add_query_arg( ['action' => 'edit','sid' => $getScheduler->id], get_permalink() );
				if( $getScheduler->status == 'pending' ){
					$delete_link = '<a class="mr-2 del_scheduler" href="javascript:void(0);" data-toggle-tt="tooltip" data-placement="top" title="'.__('Delete',CIP_TXTDOMAIN).'"><i class=" fa fa-trash"></i></a>';
				}
				
				$create_date = '-';
				try {
					$createDateObj = DateTime::createFromFormat( 'Y-m-d H:i', $getScheduler->create_date );
					$create_date = $createDateObj->format('d/m/Y H:i');
				} catch (\Throwable $th) {
					$create_date = '-';
				}
				$start_date = '-';
				try {
					$startDateObj = DateTime::createFromFormat( 'Y-m-d H:i', $getScheduler->start_date );
					$start_date = $startDateObj->format('d/m/Y H:i');
				} catch (\Throwable $th) {
					$start_date = '-';
				}
				
			?>
			<tr data-schedular="<?php echo $getScheduler->id; ?>">
				<td><?php echo $loopCount; ?></td>
				<td><?php echo $getScheduler->csr_price; ?></td>
				<td><?php echo $getScheduler->price_type; ?></td>
				<td><?php echo $create_date; ?></td>
				<td><?php echo $start_date; ?></td>
				<td><?php echo $getScheduler->status; ?></td>
			</tr>
			<?php
			$loopCount++;
			}
		}
		?>
	</table>
	<?php
	}
	$html .= ob_get_clean();
	return $html;
    }
}
add_shortcode( 'MEMBER-DASHBOARD-NOTIFICATION', 'cip_member_dashboard_notification_callback' );
function cip_member_dashboard_notification_callback(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	ob_start();
	$html = "";
	$html .= ob_get_clean();
	return $html;
}
add_shortcode( 'PROVINCE-LISTING-MANAGE', 'cip_province_listing_manage_callback' );
function cip_province_listing_manage_callback(){
	global $wpdb;
	$tableCanadaProvince = $wpdb->prefix.'canada_province';
	$html = "";
	ob_start();
	$getCanadaProvinces = $wpdb->get_results("SELECT * FROM $tableCanadaProvince WHERE 1 ORDER BY `name` ASC");
	if( $getCanadaProvinces ){
	?><form name="province_vat_rates" id="province_vat_rates"><div class="row"><?php
		foreach( $getCanadaProvinces as $canadaProvinces ){
			$labelId = 'province_'.$canadaProvinces->id;
			?>
			<div class="col-md-3">
				<div class="form-group">
					<label for="<?php echo $labelId; ?>"><?php echo $canadaProvinces->name; ?></label>
					<input type="text" name="vat_rates[<?php echo $canadaProvinces->id; ?>]" class="form-control vat_rate_field" id="<?php echo $labelId; ?>" value="<?php echo $canadaProvinces->vat_rate; ?>" />
				</div>
			</div>
			<?php
		}
	?>
	<div class="col-md-12"><button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN) ?></button></div>
	</div>
	<input type="hidden" name="action" value="province_vat_rate_update_act" />
	<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxVatRateUpdateyCIP_'); ?>" />
	</form><?php
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode( 'BUY-PACKAGE', 'buy_package_form_callback' );
function buy_package_form_callback(){
	wp_enqueue_style( 'cip-css' );
    $html = "";
    ob_start();
	if( !is_user_logged_in() ){
// 		echo do_shortcode('[corsair-login]');
	}else{
		global $wpdb;
		$tablePackages = $wpdb->prefix.'sa_packages';
		$getPackages = $wpdb->get_results("SELECT * FROM $tablePackages WHERE `active`=1 ORDER BY `euro_amount` ASC");
		$current_user = wp_get_current_user();
		$ocaBalance = 0;
		$body = [
			'email'	=>	$current_user->user_email
		];
		$response = amplivo_api_send_requests( $body, 'get-oca-balance');
		if( $response['success'] == true ){
			$ocaBalance = $response['result'];
		}

		if (strpos($ocaBalance, '.') !== false) {
			$parts = explode('.', $ocaBalance);		
			$integerPart = $parts[0];
			$decimalPart = substr($parts[1], 0, 2);

			$finalocaBalanceValue = $integerPart . '.' . $decimalPart;
		}else
		{
			$finalocaBalanceValue = number_format($ocaBalance, 2 );
		}
		
		 // check users 2FA status
	    $body = ['email'    =>  $current_user->user_email];
	    $userFAData = amplivo_api_send_requests( $body, 'authcode');
	    
	    $userFaActive = false;
	    $userFaAuthCode = '';
	    if($userFAData['status'] == 'success')
	    {
	        if($userFAData['data']['isActive'] == 1)
	        {
	            $userFaActive = true;
	            $_SESSION['user_fa_authcode_amplio_for_buy_package'] = $userFAData['data']['authcode'];
	        }
	    }
	    

	    $amplivo_api_mode = get_option( 'amplivo_api_mode' );
		
		$sourceUrl = ( $amplivo_api_mode == 'live' ) ? 'https://amplivo.com/' : 'https://cloudhorizon.sandbox.jox.hu/';

	    // check users 2FA status

		?>
		<div class="bpf_top_right" style="flex-wrap:wrap; justify-content: space-between; align-items: center;">
		<h4><?php _e('<span class="text-danger">*</span> Prices exclude local taxes', CIP_TXTDOMAIN); ?> </h4>	
			<div class="bpf_top_box">
				<h4><?php _e('OCA balance =', CIP_TXTDOMAIN); ?> </h4>
				<p><?php echo sprintf( __('€%s', CIP_TXTDOMAIN), $finalocaBalanceValue ); ?></p>
			</div>
		</div>
		<?php if( $getPackages ){ ?>
		<div class="bpf_grid">
		<?php
		foreach( $getPackages as $getPackage ){
			$deactiveClass = "";
			$encryptId = base64_encode($getPackage->id . md5('123QCIP_Buy_Packages_CIPQ321'));
			if( $ocaBalance < $getPackage->euro_amount ){
				$deactiveClass = 'deactive';
				$encryptId = "";
			}
			if( $getPackage->euro_amount > 0 ){
				$csrAmount = cip_convert_csr_by_price( $getPackage->euro_amount );
				$csrKgs = cip_convert_kgs_by_price( $getPackage->euro_amount );
			?>
			<div class="bpf_grid_item <?php echo $deactiveClass; ?>">
				<div class="bpf_grid_info">
					<!-- <h2><?php echo sprintf( __('Plastic Neutrality Package %s Euros<br>', CIP_TXTDOMAIN), round( $getPackage->euro_amount ) ); ?></h2> -->
					<h2><?php echo sprintf( __('%s', CIP_TXTDOMAIN), $getPackage->heading ); ?></h2>
					<!-- <h2><?php echo sprintf( __('PNP - %s', CIP_TXTDOMAIN), round( $getPackage->euro_amount ) ); ?></h2> -->
					<!-- <p class="bpg_gi_dec"><?php echo $getPackage->description; ?></p> -->
					<p class="bpg_gi_dec">
					<?php 
					$description_array = explode("[BR]",$getPackage->description);
					foreach($description_array as $description_item){
						if($description_item != ''){
							if(str_contains($description_item, '[Price]') || str_contains($description_item, '[KG]')){
								$searchdescription = array("[Price]", "[KG]");
								// description to replace with
								$replacedescription = array("€".round( $getPackage->euro_amount ), number_format( $csrKgs )."kg");
								// Performing the replacement
								$replacedString = str_replace($searchdescription, $replacedescription, $description_item);
								echo sprintf( __('<span><strong class="text-danger">*</strong>%s</span>', CIP_TXTDOMAIN), $replacedString );
							}else{
								echo sprintf( __('<span><strong class="text-danger">*</strong>%s</span>', CIP_TXTDOMAIN), $description_item );
							}
						}
					}
					// if(str_contains($getPackage->description, 'Business License')){
					// 	echo sprintf( __('
					// 	<span style="padding-left: 0px !important;">%s</span>', CIP_TXTDOMAIN), $getPackage->description );
					// }else{
					// echo sprintf( __('
					// 	<span><strong class="text-danger">*</strong> Plastic Neutrality Package €%s</span>
					// 	<span><strong class="text-danger">*</strong> %skg of Plastic Waste removal service</span>', CIP_TXTDOMAIN), round( $getPackage->euro_amount ),number_format( $csrKgs ) );
					// }
					?>
					</p>
					<!-- <p class="bpg_gi_bdec"><?php echo sprintf( __('CSR : %s', CIP_TXTDOMAIN), number_format( $csrAmount ) ); ?></p> -->
				</div>
				<?php
				if($userFaActive){
					?>
						<div class="bpf_grid_bottom">
							<div><p><?php echo sprintf( __('€%s', CIP_TXTDOMAIN), number_format( $getPackage->euro_amount, 2 ) ); ?></p></div>
							<div><a href="javascript:void(0);" <?php if( !empty( $encryptId ) ){ ?> data-pkgid="<?php echo $encryptId; ?>" <?php } ?> data-kgs="<?php echo $csrKgs; ?>"><?php _e('Buy Now', CIP_TXTDOMAIN); ?></a></div>
						</div>					
					<?php
				}else{
					?>
					<div class="bpf_grid_bottom">
						<div><p><?php echo sprintf( __('€%s', CIP_TXTDOMAIN), number_format( $getPackage->euro_amount, 2 ) ); ?></p></div>
						<div><a href="javascript:void(0);" data-sourceurl="<?=$sourceUrl?>" class="fa_authantication_not_activated"><?php _e('Buy Now', CIP_TXTDOMAIN); ?></a></div>
					</div>	
					<?php
				}
				?>
			</div>
			<?php
			}
		}
		?>
		</div>
		<div class="modal fade" id="buyPackageTxnPwdModal" tabindex="-1" role="dialog">
			<div class="modal-dialog modal-dialog-centered" role="document">
		    	<div class="modal-content">
		      		<div class="modal-body">
					</div>
		    	</div>
		  	</div>
		</div>
		<?php } ?>
		<?php
	}
	$html .= ob_get_clean();
    return $html;
}
add_shortcode('SM-EMAIL-SEND-SWITCH-SETTINGS','cip_sm_email_send_switch_settings_cb');
function cip_sm_email_send_switch_settings_cb(){
	$html = "";
	$email_notification_toggle_login = ( !empty( get_option('email_notification_toggle_login') ) ) ? get_option('email_notification_toggle_login') : 0 ;
	$email_notification_toggle_deposit = ( !empty( get_option('email_notification_toggle_deposit') ) ) ? get_option('email_notification_toggle_deposit') : 0 ;
	$email_notification_toggle_withdrawal_request = ( !empty( get_option('email_notification_toggle_withdrawal_request') ) ) ? get_option('email_notification_toggle_withdrawal_request') : 0 ;
	$email_notification_toggle_2fa_enabled_disabled = ( !empty( get_option('email_notification_toggle_2fa_enabled_disabled') ) ) ? get_option('email_notification_toggle_2fa_enabled_disabled') : 0 ;
	$email_notification_toggle_otp_enabled_disabled = ( !empty( get_option('email_notification_toggle_otp_enabled_disabled') ) ) ? get_option('email_notification_toggle_otp_enabled_disabled') : 0 ;
	$email_notification_toggle_sa_register = ( !empty( get_option('email_notification_toggle_sa_register') ) ) ? get_option('email_notification_toggle_sa_register') : 0 ;
	$email_notification_toggle_sm_register = ( !empty( get_option('email_notification_toggle_sm_register') ) ) ? get_option('email_notification_toggle_sm_register') : 0 ;
	ob_start();
	?>
	<form name="sm_email_sending_switch_frm" id="sm_email_sending_switch_frm">
		<h5><?php 
		// _e('Email send0ing switch', CIP_TXTDOMAIN); 
		?></h5>
		<div class="row">
			<div class="col-md-6">
				<div class="form-group">
					<div class="custom-control custom-switch">
						<input type="checkbox" class="custom-control-input" name="email_notification_switch_toggle_login" id="email_notification_switch_toggle_login" value="1" <?php checked( 1, $email_notification_toggle_login, true ); ?>>
						<label class="custom-control-label" for="email_notification_switch_toggle_login"><?php _e('Login', CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Users email notification about login', CIP_TXTDOMAIN) ); ?> </label>
					</div>
				</div>
				<div class="form-group">
					<div class="custom-control custom-switch">
						<input type="checkbox" class="custom-control-input" name="email_notification_switch_toggle_otp_enabled_disabled" id="email_notification_switch_toggle_otp_enabled_disabled" value="1" <?php checked( 1, $email_notification_toggle_otp_enabled_disabled, true ); ?>>
						<label class="custom-control-label" for="email_notification_switch_toggle_otp_enabled_disabled"><?php _e('OTP enabled / disabled', CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Users email notification about OTP status change', CIP_TXTDOMAIN) ); ?></label>
					</div>
				</div>
				<div class="form-group">
					<div class="custom-control custom-switch">
						<input type="checkbox" class="custom-control-input" name="email_notification_switch_toggle_2fa_enabled_disabled" id="email_notification_switch_toggle_2fa_enabled_disabled" value="1" <?php checked( 1, $email_notification_toggle_2fa_enabled_disabled, true ); ?>>
						<label class="custom-control-label" for="email_notification_switch_toggle_2fa_enabled_disabled"><?php _e('2FA enabled / disabled', CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Users email notification about 2FA status change', CIP_TXTDOMAIN) ); ?></label>
					</div>
				</div>
			</div>
		</div> 
		<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
		<input type="hidden" name="action" value="cip_sm_email_sending_switch_settings_act" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsm_csr_email_sending_switch_settingxCIP_'); ?>" />
		</form>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('sign_up_page_redirect_cb','sign_up_page_redirect_cb');
function sign_up_page_redirect_cb(){
	?>
	<h4 dir="auto" style="text-align: center; color: #000;">Thank you for your interest in Amplivo</h4>
	<p dir="auto" style="text-align: center;">Amplivo Canada registrations are managed on <a href="<?php echo get_ampliov_link_url(); ?>" target="_blank" rel="nofollow noopener noreferrer ugc">Amplivo.com</a></p>
	<p dir="auto" style="text-align: center;">You will now be redirected to <a title="‌" href="<?php echo get_ampliov_link_url(); ?>" target="_blank" rel="nofollow noopener noreferrer ugc">Amplivo.com</a> to complete the registration process.</p>
	<p dir="auto" style="text-align: center;">If you are not redirected in 10 seconds <a href="<?php echo get_ampliov_link_url(); ?>sign-up" target="_blank" rel="noopener">click here</a></p>
	<?php
}
add_shortcode('SUPPORT-FORM-CHECK-LOGIN-OR-NOT','support_form_check_login_or_not_cb');
function support_form_check_login_or_not_cb(){
	$html = "";
	ob_start();
	if(is_user_logged_in())
	{
	?>
		<div style="padding:50px 0px 200px 0px;text-align: center;">
			<h4 dir="auto" style="color: #000;">Thank you for your interest in Amplivo</h4>
			<p dir="auto">As you are currently logged in, you have the ability to establish a connection with our support team at <a href="<?php echo get_ampliov_link_url(); ?>support" target="_blank" rel="nofollow noopener noreferrer ugc">Amplivo.com</a></p>
			<p dir="auto">You will now be redirected to <a title="" href="<?php echo get_ampliov_link_url(); ?>support" target="_blank" rel="nofollow noopener noreferrer ugc">Amplivo.com</a> to contact support.</p>
			<p dir="auto">If you are not redirected in 10 seconds <a href="<?php echo get_ampliov_link_url(); ?>sign-up" target="_blank" rel="noopener">click here</a></p>
		</div>
		<style type="text/css">
			#contact_support{
				display: none !important;
			}
		</style>
	 <script type="text/javascript">
        setTimeout(function() {
            window.location.href = '<?php echo get_ampliov_link_url(); ?>support';
        }, 10000);
    </script>
    <?php
	}
	else{
	?>
	<style type="text/css">
			#contact_support{
				display: none !important;
			}
			#contact_support.showform{
				display: block !important;
			}
		</style>
		<div style="padding:50px 0px 200px 0px;display: flex;justify-content: center;" id="support_form_check_login_or_not">
			<form name="support_form_check_login_or_not" class="card shadow bg-white rounded" style="width: 50%;padding: 35px;">
				<p>Are you registered user?</p>
				<div style="display: flex;align-items: center;justify-content: start;gap: 10px;">
					<input type="radio" id="yes" name="check_is_register_or_not" value="yes">
					<label for="yes">Yes</label><br>
				</div>
				<div style="display: flex;align-items: center;justify-content: start;gap: 10px;">
					<input type="radio" id="no" name="check_is_register_or_not" value="no">
					<label for="no">No</label><br>
				</div>
			</form>
		</div>
	<script type="text/javascript">
		jQuery(document).on('change','input[name=check_is_register_or_not]',function(){
			if(jQuery(this).val() == 'yes')
			{
				Swal.fire({ type: 'warning', title: 'Prior to submitting a support ticket, kindly log in to your account.', text: '',allowOutsideClick: true}).then(function(){window.location.href = window.location.origin+'/content/operations/login'});
			}
			else{
				jQuery('#contact_support').css('display','block !important')
				jQuery('#contact_support').addClass('showform')
				jQuery('#support_form_check_login_or_not').hide();
			}
		})
	</script>
	<?php
	}	
	$html .= ob_get_clean();
	return $html;
}

// add_shortcode('MY-TRANSACTIONS-PAGE-FOR-DEPOSIT-WITHDRAWALS','my_trasactions_page_for_deposit_withdrawals');
function my_trasactions_page_for_deposit_withdrawals(){
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-datepicker' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'daterangepicker-style' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('dr-moment');
	wp_enqueue_script('bs-datepicker');
	wp_enqueue_script('daterangepicker-script');
	global $wpdb;
	$table_name = $wpdb->prefix . 'request_deposit';
	$current_user = wp_get_current_user();
    $user_email = $current_user->user_email;
	$records = $wpdb->get_results("SELECT * FROM ".$table_name." WHERE email = '".$user_email."'");
	$w_table_name = $wpdb->prefix . 'withdrawal_requests';
	
	$w_records = $wpdb->get_results("SELECT * FROM ".$w_table_name." WHERE email = '".$user_email."'");
	$html = "";
	ob_start();
	?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://unpkg.com/bootstrap-table@1.22.1/dist/bootstrap-table.min.css">
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://unpkg.com/bootstrap-table@1.22.1/dist/bootstrap-table.min.js"></script>
    <script src="https://unpkg.com/bootstrap-table@1.22.1/dist/extensions/filter-control/bootstrap-table-filter-control.min.js"></script>
    	<?php
		$member_transaction_w_detail_table_url = add_query_arg( [
			'action'	=>	'cip_memeber_trasaction_w_list_loader',
			'pageid'	=>	get_the_ID(),
		], admin_url( 'admin-ajax.php' ) );
		$member_transaction_w_detail_table_usdt_url = add_query_arg( [
			'action'	=>	'cip_memeber_trasaction_w_list_usdt_loader',
			'pageid'	=>	get_the_ID(),
		], admin_url( 'admin-ajax.php' ) );
	?>
	<style>
		.daterangepicker .drp-calendar{
			max-width: 100% !important;
		}
	</style>
	<div class=" member_transaction__detail_table-container">
		
		<div class="titls-rw text-center">
			<h2>Withdrawal</h2>
		</div>
		<div id="customToolbar_table" style="margin-top: -55px; padding-bottom: 10px;">
			<div class="d-flex jus" style="column-gap: 10px; justify-content: flex-end;">
				<!-- <select id="mtdt_de_toggle" style="display: inline-block; width: auto;">
					<option value="">ALL</option>
					<option value="USDT">USDT</option>
					<option value="CAD">CAD</option>
				</select> -->
				<button type="button" class="btn btn-secondary mtdt_de_toggle active" value="">ALL</button>
				<button type="button" class="btn btn-secondary mtdt_de_toggle" value="USDT">USDT</button>
				<button type="button" class="btn btn-secondary mtdt_de_toggle" value="CAD">CAD</button>
			</div>
		</div>
		<!-- <div class="" style="text-align: center; margin-bottom: 15px;">
			<span>Deposit</span>
			<label class="switch">
				<input type="checkbox" id="swich_table_r_w" onchange="jQuery('.member_transaction__detail_table-body,.member_transaction_w_detail_table-body').toggle();">
				<span class="slider round"></span>
			</label>
			<span>Withdrawal</span>
		</div> -->
		
		<div class="member_transaction_w_detail_table-body">
			<!-- <section id="de_cad_only"> -->
				
				<table id="member_transaction_w_detail_table" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
				<thead>
					<tr>
						<th data-field="id" data-sortable="true" class="id" data-switchable="false" data-width="50" data-width-unit="px"><?php _e('#', CIP_TXTDOMAIN); ?></th>
						<th data-field="create_date" data-filter-control="input" class="member_transaction_date"><?php _e('Date', CIP_TXTDOMAIN); ?></th>
						<th data-field="reference" data-filter-control="input" class="reference"><?php _e('Amplivo ticket number', CIP_TXTDOMAIN); ?></th>
						<!-- <th data-field="email" data-filter-control="input" data-sortable="true" class="email"><?php _e('Email', CIP_TXTDOMAIN); ?></th> -->
						<!-- <th data-field="transaction_type"  class="transactionstype"><?php _e('Transaction Type', CIP_TXTDOMAIN); ?></th> -->
						<th data-field="type_of_withdrawal" data-sortable="true" class="transactionscurrency"><?php _e('Transaction Currency', CIP_TXTDOMAIN); ?></th>
						<th data-field="usdt_block_chain" data-filter-control="input" data-sortable="true" class="amountofdeposit"><?php _e('Blockchain type', CIP_TXTDOMAIN); ?></th>
						<th data-field="usdt_blockchain_address" data-filter-control="input" data-sortable="true" class="amountofdeposit"><?php _e('Blockchain Address', CIP_TXTDOMAIN); ?></th>
						<th data-field="usdt_amount_euro" data-filter-control="input" data-sortable="true" class="amountofdeposit"><?php _e('USDT', CIP_TXTDOMAIN); ?></th>
						<th data-field="cad_amount_euro" data-filter-control="input" data-sortable="true" class="amountofdeposit"><?php _e('Amount', CIP_TXTDOMAIN); ?></th>
						<th data-field="exchange_rate" data-filter-control="input" data-sortable="true" class="amountofdeposit"><?php _e('Exchange rate', CIP_TXTDOMAIN); ?></th>
						<th data-field="usdt_amount_usdt" data-filter-control="input" data-sortable="true" class="amountofdeposit"><?php _e('Amount (EURO)', CIP_TXTDOMAIN); ?></th>
						<th data-field="account_holder" data-filter-control="input" data-sortable="true" class="account_holder"><?php _e('Account Holder', CIP_TXTDOMAIN); ?></th>
						<th data-field="bank_iban" data-filter-control="input" data-sortable="true" class="bank_iban"><?php _e('IBAN', CIP_TXTDOMAIN); ?></th>
						<th data-field="bank_bic" data-filter-control="input" data-sortable="true" class="bank_bic"><?php _e('BIC', CIP_TXTDOMAIN); ?></th>
						<th data-field="bank_name" data-filter-control="input" data-sortable="true" class="bank_name"><?php _e('Bank Name', CIP_TXTDOMAIN); ?></th>
						<th data-field="bank_address" data-filter-control="input" data-sortable="true" class="bank_address"><?php _e('Bank Address', CIP_TXTDOMAIN); ?></th>
						<!-- <th data-field="usdt_blockchain_address" data-filter-control="input" data-sortable="true" class="amountofdeposit"><?php _e('Blockchain Address', CIP_TXTDOMAIN); ?></th> -->
						<th data-field="status" data-filter-control="select" data-sortable="true" data-filter-data="var:userJobTitles" class="status"><?php _e('Status', CIP_TXTDOMAIN); ?></th>
						<!-- <th data-field="cad_amount_cad" data-filter-control="input" data-sortable="true" class="amountofdeposit"><?php _e('Amount', CIP_TXTDOMAIN); ?></th> -->
					</tr>
				</thead>
				<tbody>
				</tbody>
				</table>
			<!-- </section> -->
			<!-- <section id="de_usdt_only" style="display: none;">
				<table id="member_transaction_w_detail_table_usdt" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
				<thead>
					<tr>
						<th data-field="id" data-sortable="true" class="id" data-switchable="false" data-width="50" data-width-unit="px"><?php _e('#', CIP_TXTDOMAIN); ?></th>
						<th data-field="create_date" data-filter-control="input" data-sortable="true" class="submissionDate"><?php _e('Date Of Submission', CIP_TXTDOMAIN); ?></th>
						<th data-field="transaction_type"  class="transactionstype"><?php _e('Transaction Type', CIP_TXTDOMAIN); ?></th>
						<th data-field="type_of_withdrawal" data-sortable="true" class="transactionscurrency"><?php _e('Transaction Currency', CIP_TXTDOMAIN); ?></th>
						<th data-field="usdt_amount_euro" data-filter-control="input" data-sortable="true" class="amountofdeposit"><?php _e('Amount of Withdrawal', CIP_TXTDOMAIN); ?></th>
						<th data-field="usdt_block_chain" data-filter-control="input" data-sortable="true" class="amountofdeposit"><?php _e('Block Chain', CIP_TXTDOMAIN); ?></th>
						<th data-field="usdt_blockchain_address" data-filter-control="input" data-sortable="true" class="amountofdeposit"><?php _e('Blockchain Address', CIP_TXTDOMAIN); ?></th>
					</tr>
				</thead>
				<tbody>
				</tbody>
				</table>
			</section> -->
		</div>
	</div>
	<script>
		var userJobTitles = {
				Pending: 'Pending',
				reject: 'Rejected',
			};
	</script>
	<style>
		.member_transaction__detail_table-container .switch {
		position: relative;
		display: inline-block;
		width: 60px;
		height: 34px;
		}
		.member_transaction__detail_table-container .switch input { 
		opacity: 0;
		width: 0;
		height: 0;
		}
		.member_transaction__detail_table-container .slider {
		position: absolute;
		cursor: pointer;
		top: 0;
		left: 0;
		right: 0;
		bottom: 0;
		background-color: #ccc;
		-webkit-transition: .4s;
		transition: .4s;
		}
		.member_transaction__detail_table-container .slider:before {
		position: absolute;
		content: "";
		height: 26px;
		width: 26px;
		left: 4px;
		bottom: 4px;
		background-color: white;
		-webkit-transition: .4s;
		transition: .4s;
		}
		.member_transaction__detail_table-container input:checked + .slider {
		background-color: #9B8B75 !important;
		}
		.member_transaction__detail_table-container input:focus + .slider {
		box-shadow: 0 0 1px #9B8B75 !important;
		}
		.member_transaction__detail_table-container input:checked + .slider:before {
		-webkit-transform: translateX(26px);
		-ms-transform: translateX(26px);
		transform: translateX(26px);
		}
		/* Rounded sliders */
		.member_transaction__detail_table-container .slider.round {
		border-radius: 34px;
		}
		.member_transaction__detail_table-container .slider.round:before {
		border-radius: 50%;
		}
	</style>
	<script>
	  jQuery(document).ready(function($){
		

		if( $('#member_transaction_w_detail_table').length > 0 ){		
				var member_transaction_w_detail_table_url = "<?php echo $member_transaction_w_detail_table_url ?>";
				var wpadminbar = isNaN( parseInt( $('#wpadminbar').height() ) ) ? 0 : parseInt( $('#wpadminbar').height() ) ;
				stickyHeaderOffset = wpadminbar;
				var $tablePendinReview = $('#member_transaction_w_detail_table');
				$tablePendinReview.bootstrapTable({
					method: 'post',
					contentType: 'application/x-www-form-urlencoded',
					url: member_transaction_w_detail_table_url,
					queryParams: function (p) {
						return {
							columnfilter: p.filter,
							limit: p.limit,
							offset: p.offset,
							// 'type': jQuery("#mtdt_de_toggle").val(),
							'type' : jQuery(".mtdt_de_toggle.active").attr('value'),
							sort: p.sort,
							order: p.order,
						};
					},
					stickyHeader: false,
					stickyHeaderOffsetY: stickyHeaderOffset,
					onPostBody: function (){
						if( $('[data-toggle-tt="tooltip"]').length > 0 ){
							$('[data-toggle-tt="tooltip"]').tooltip();
						}
						$('.filter-control input.search-input').prop('readonly',false);
					},
					onSearch: function( search ){
						$('.filter-control input.search-input').prop('readonly',true);
					}
				});
		}
		if( $('#member_transaction_w_detail_table_usdt').length > 0 ){		
				var member_transaction_w_detail_table_usdt_url = "<?php echo $member_transaction_w_detail_table_usdt_url ?>";
				var wpadminbar = isNaN( parseInt( $('#wpadminbar').height() ) ) ? 0 : parseInt( $('#wpadminbar').height() ) ;
				stickyHeaderOffset = wpadminbar;
				var $tablePendinReview = $('#member_transaction_w_detail_table_usdt');
				$tablePendinReview.bootstrapTable({
					method: 'post',
					contentType: 'application/x-www-form-urlencoded',
					url: member_transaction_w_detail_table_usdt_url,
					queryParams: function (p) {
						return {
							columnfilter: p.filter,
							limit: p.limit,
							offset: p.offset,
							sort: p.sort,
							order: p.order,
						};
					},
					stickyHeader: false,
					stickyHeaderOffsetY: stickyHeaderOffset,
					onPostBody: function (){
						if( $('[data-toggle-tt="tooltip"]').length > 0 ){
							$('[data-toggle-tt="tooltip"]').tooltip();
						}
						$('.filter-control input.search-input').prop('readonly',false);
					},
					onSearch: function( search ){
						$('.filter-control input.search-input').prop('readonly',true);
					}
				});
		}
		});
	</script>
	
	<?php
	$html .= ob_get_clean();
	return $html;
}
// Function to shorten Ethereum address or transaction hash
function shorten_ethereum($input) {
    // Check if input is an address or a transaction hash
    $is_address = strlen($input) == 42 && strpos($input, '0x') === 0;
    $is_hash = strlen($input) == 66 && strpos($input, '0x') === 0;
    // If it's neither an address nor a hash, return input unchanged
    if (!$is_address && !$is_hash) {
        return $input;
    }
    // Shorten the input
    $shortened = substr($input, 0, 4) . "..." . substr($input, -4);
    // Create hyperlink to Etherscan
    $etherscan_url = "https://etherscan.io/";
    $full_url = $is_address ? $etherscan_url . "address/" . $input : $etherscan_url . "tx/" . $input;
    $link = '<a href="' . $full_url . '" target="_blank" data-toggle-tt="tooltip" title="' . $input . '">' . $shortened . '</a>';
    return $link;
}

// type_of_withdrawal
add_action('wp_ajax_cip_memeber_trasaction_w_list_loader','cip_memeber_trasaction_w_list_loader_cb');
function cip_memeber_trasaction_w_list_loader_cb(){
	global $wpdb;

	$tableReceipts = $wpdb->prefix.'withdrawal_requests';
	
	
	$limit = isset( $_POST['limit'] ) ? $_POST['limit'] : 10;
	$offset = isset( $_POST['offset'] ) ? $_POST['offset'] : 0;
	$type = ( isset($_POST['type']) && $_POST['type'] != '' ) ? "AND type_of_withdrawal = '".$_POST['type']."'" : '';
	$current_user = wp_get_current_user();
	$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableReceipts WHERE 1 $type AND 'email' = $current_user->user_email");
	$orderby = isset( $_POST['sort'] ) ? $_POST['sort'] : 'id';
	$order = (isset($_POST['order']) && in_array($_POST['order'], array('asc', 'desc'))) ? $_POST['order'] : 'desc';
	
	$filter_qry = "";
	$filters = json_decode( stripslashes( $_REQUEST['columnfilter'] ), true );
	if( !empty( $filters ) ){
		foreach( $filters as $filterKey => $filterData ){
			if( $filterKey == 'date' || $filterKey == 'create_date' ){
				if( str_contains($filterData, ' - ') ){
					$filterDataMinMax = explode(' - ', $filterData);
					$filter_qry .= " AND DATE_FORMAT(`create_date`,'%d-%m-%Y') BETWEEN '$filterDataMinMax[0]' AND '$filterDataMinMax[1]'";
				}else{
					$filter_qry .= " AND DATE_FORMAT(`create_date`,'%d-%m-%Y') = '$filterData'";
				}
			}else{
				$filter_qry .= " AND `$filterKey` like '%" . $filterData . "%'";
			}
		}
		$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableReceipts WHERE 1 $type $filter_qry");
	}
	
	$getReceiptsLists = $wpdb->get_results("SELECT * FROM $tableReceipts WHERE 1 $type AND `email` = '".$current_user->user_email."' $filter_qry ORDER BY `$orderby` $order LIMIT $limit OFFSET $offset");
	$total_items = $wpdb->get_results("SELECT * FROM $tableReceipts WHERE 1 $type AND `email` = '".$current_user->user_email."' $filter_qry ");
	
	
	// AND `type_of_withdrawal`='CAD'
	// AND `type_of_withdrawal`='CAD'
	// AND `type_of_withdrawal`='CAD'
	$rows = array();
	if( $getReceiptsLists ){
		$sno= $_REQUEST['offset'] + 1;
		foreach( $getReceiptsLists as $getReceiptsList ){
			$row = array();
			$columnsArr = array(
				'id'				=>	__('id', CIP_TXTDOMAIN),
				'email'	=>	__('email', CIP_TXTDOMAIN),
				'transaction_type'				=>	__('transaction_type', CIP_TXTDOMAIN),
				
				'account_holder'				=>	__('account_holder', CIP_TXTDOMAIN),
				'bank_iban'				=>	__('bank_iban', CIP_TXTDOMAIN),
				'bank_bic'				=>	__('bank_bic', CIP_TXTDOMAIN),
				'bank_name'				=>	__('bank_name', CIP_TXTDOMAIN),
				
				'bank_address'				=>	__('bank_address', CIP_TXTDOMAIN),
				'usdt_block_chain'	=>	__('usdt_block_chain', CIP_TXTDOMAIN),
				'usdt_blockchain_address'	=>	__('usdt_blockchain_address', CIP_TXTDOMAIN),
				'type_of_withdrawal'	=>	__('type_of_withdrawal', CIP_TXTDOMAIN),
				'usdt_amount_euro'	=>	__('usdt_amount_euro', CIP_TXTDOMAIN),
				'cad_amount_euro'	=>	__('cad_amount_euro', CIP_TXTDOMAIN),
				'exchange_rate'	=>	__('exchange_rate', CIP_TXTDOMAIN),
				'usdt_amount_usdt'	=>	__('usdt_amount_usdt', CIP_TXTDOMAIN),
				'cad_amount_cad'	=>	__('cad_amount_cad', CIP_TXTDOMAIN),
				'reference' => __('Reference', CIP_TXTDOMAIN),
				
				'create_date'	=>	__('create_date', CIP_TXTDOMAIN),
				'status'	=>	__('status', CIP_TXTDOMAIN),
			);

			if( $columnsArr ){
				foreach( $columnsArr as $columnKey => $columnsVal ){
					$columnsDataVal = $getReceiptsList->$columnKey;
					if($columnKey == 'exchange_rate'){
						if( !empty( $columnsDataVal ) ){
							$columnsDataVal = number_format( $columnsDataVal, 4, '.', ',' );
						}
					}
					if( $columnKey == 'usdt_amount_euro' || $columnKey == 'cad_amount_euro' || $columnKey == 'usdt_amount_usdt' || $columnKey == 'cad_amount_cad' ){
						if( !empty( $columnsDataVal ) ){
							$columnsDataVal = cip_number_format( $columnsDataVal, true );
						}
					}

					if( empty( $columnsDataVal ) ){
						$columnsDataVal = '—';
					}
					if( $columnKey  == 'bank_address'){
						if (strlen($columnsDataVal) >25) {
							$truncated_text = substr($columnsDataVal, 0, 20);
							$columnsDataVal = '<span>'.$truncated_text.'... &nbsp</span><span class="fa fa-info-circle d-inline-block" tabindex="0" data-toggle-tt="tooltip" title="'.$columnsDataVal.'"></span>';
						}else{
							$columnsDataVal = '<span>'.$columnsDataVal.'</span>';
						}
						
					}
					if( $columnKey == 'usdt_blockchain_address' ){
						$columnsDataVal = shorten_ethereum($columnsDataVal);
					}
					if( $columnKey == 'transaction_hash'){
							$columnsDataVal = $getReceiptsList->$columnKey;
							if( !empty( $columnsDataVal ) ){
								$columnsDataValMask = substr($columnsDataVal, 0, 4) . '...' . substr($columnsDataVal, -4);
								$columnsDataVal = '<a href="https://etherscan.io/address/'. $columnsDataVal.'" target="_blank" data-toggle-tt="tooltip" data-placement="top" title="'.__($columnsDataVal, CIP_TXTDOMAIN).'" >'. $columnsDataValMask . '</a>';
							}else{
								$columnsDataVal = '—';
							}
					}
					if($columnKey == 'status' && $columnsDataVal == 'reject'){
						if($getReceiptsList->reason != ""){
							$columnsDataVal = 'Rejected <span class="fa fa-info-circle d-inline-block" tabindex="0" data-toggle-tt="tooltip" title="'.$getReceiptsList->reason.'"></span>';
						}else{
							$columnsDataVal = 'Rejected';
						}
					}elseif($columnKey == 'status'){
						$columnsDataVal = 'Panding';
					}
					if($columnKey == 'transaction_type'){
						$row[$columnKey] = 'Withdrawal';
					}elseif($columnKey == 'usdt_amount_usdt'){	
						if($getReceiptsList->type_of_withdrawal == 	'CAD'){
							$row[$columnKey] = cip_number_format( $getReceiptsList->cad_amount_cad, true );
						}else{
							$row[$columnKey] = cip_number_format( $columnsDataVal, true );
						}
					}else if($columnKey == 'reference'){
						if($columnsDataVal != '—'){
							$row[$columnKey] = "AMP-".$columnsDataVal;
						}
					}else{
						$row[$columnKey] = $columnsDataVal;
					}
				}
			}
			$encryptId = base64_encode($getReceiptsList->id . md5('_CIP_RECEIPTS_CIP_'));
			if( $getReceiptsList->invoiceStatus != 'Paid' ){
				$row['action'] = '<a href="javascript:void(0);" class="edit-receipt" data-receipt="'. $encryptId .'"><i class="fas fa-pencil-alt" data-toggle-tt="tooltip" data-placement="top" title="'.__('Edit', CIP_TXTDOMAIN).'"></i></a>';
			}

			$rows[] = $row;
			$sno=$sno+1;
		}
	}
	$out = array(
		'total'			=>	count($total_items),
		'rows'			=>	$rows
	);
	echo wp_json_encode( $out );
	exit;
}
add_action('wp_ajax_cip_memeber_trasaction_w_list_usdt_loader','cip_memeber_trasaction_w_list_usdt_loader_cb');
function cip_memeber_trasaction_w_list_usdt_loader_cb(){
	global $wpdb;

	$tableReceipts = $wpdb->prefix.'withdrawal_requests';
	$current_user = wp_get_current_user();
	$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableReceipts WHERE 1 AND `type_of_withdrawal`='USDT' AND 'email' = $current_user->user_email");
	
	$limit = isset( $_POST['limit'] ) ? $_POST['limit'] : 10;
	$offset = isset( $_POST['offset'] ) ? $_POST['offset'] : 0;
	$orderby = isset( $_POST['sort'] ) ? $_POST['sort'] : 'id';
	$order = (isset($_POST['order']) && in_array($_POST['order'], array('asc', 'desc'))) ? $_POST['order'] : 'desc';
	
	$filter_qry = "";
	$filters = json_decode( stripslashes( $_REQUEST['columnfilter'] ), true );
	if( !empty( $filters ) ){
		foreach( $filters as $filterKey => $filterData ){
			if(isset($filterData) && $filterKey == 'status'){
				$filterDataval = ($filterData == 'Complete') ? 1 : 0 ;
				$filter_qry .= " AND `$filterKey` like '%" . $filterDataval . "%'";
			}else{
				$filter_qry .= " AND `$filterKey` like '%" . $filterData . "%'";
			}
		}
		$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableReceipts WHERE 1 AND `type_of_withdrawal`='USDT' $filter_qry");
	}
	
	$getReceiptsLists = $wpdb->get_results("SELECT * FROM $tableReceipts WHERE 1 AND `type_of_withdrawal`='USDT' AND `email` = '".$current_user->user_email."' $filter_qry ORDER BY `$orderby` $order LIMIT $limit OFFSET $offset");
	
	
	$rows = array();
	if( $getReceiptsLists ){
		$sno= $_REQUEST['offset'] + 1;
		foreach( $getReceiptsLists as $getReceiptsList ){
			$row = array();
			$columnsArr = array(
				'id'				=>	__('id', CIP_TXTDOMAIN),
				'type_of_withdrawal'	=>	__('type_of_withdrawal', CIP_TXTDOMAIN),
				'create_date'				=>	__('create_date', CIP_TXTDOMAIN),
				'usdt_amount_euro'	=>	__('usdt_amount_euro', CIP_TXTDOMAIN),
				'transaction_type'	=>	__('transaction_type', CIP_TXTDOMAIN),
				'usdt_block_chain'	=>	__('usdt_block_chain', CIP_TXTDOMAIN),
				'usdt_blockchain_address'	=>	__('usdt_blockchain_address', CIP_TXTDOMAIN),
			);

			if( $columnsArr ){
				foreach( $columnsArr as $columnKey => $columnsVal ){
					$columnsDataVal = $getReceiptsList->$columnKey;

					if( $columnKey == 'amount' ){
						if( !empty( $columnsDataVal ) ){
							$columnsDataVal = cip_number_format( $columnsDataVal, true );
						}
					}

					if( empty( $columnsDataVal ) ){
						$columnsDataVal = '—';
					}
					if($columnKey == 'transaction_type'){
						$row[$columnKey] = 'Withdrawal';
					}elseif($columnKey == 'usdt_amount_euro'){	
						if($getReceiptsList->type_of_withdrawal == 	'CAD'){
							$row[$columnKey] = $getReceiptsList->cad_amount_cad;
						}else{
							$row[$columnKey] = $columnsDataVal;
						}
					}else{
						$row[$columnKey] = $columnsDataVal;
					}
				}
			}
			$encryptId = base64_encode($getReceiptsList->id . md5('_CIP_RECEIPTS_CIP_'));
			if( $getReceiptsList->invoiceStatus != 'Paid' ){
				$row['action'] = '<a href="javascript:void(0);" class="edit-receipt" data-receipt="'. $encryptId .'"><i class="fas fa-pencil-alt" data-toggle-tt="tooltip" data-placement="top" title="'.__('Edit', CIP_TXTDOMAIN).'"></i></a>';
			}

			$rows[] = $row;
			$sno=$sno+1;
		}
	}
	$out = array(
		'total'			=>	$total_items,
		'rows'			=>	$rows
	);
	echo wp_json_encode( $out );
	exit;
}
function token_create_for_withdrawal_and_deposit_request( $type = '', $body = '' ){
	if($type != '' && !empty($body)){
		if($type == 'withdrawal'){
			if( $body['type_of_withdrawal'] == 'USDT' ){
				if($body["usdt_block_chain"] == 'ERC20'){
					$block_chain_type = 'ERC-20';
					$block_chain_name = 'Ethereum';
				}else if($body["usdt_block_chain"] == 'BSC'){
					$block_chain_type = 'BSC';
					$block_chain_name = 'Binance Smart Chain';
				}else if($body["usdt_block_chain"] == 'Tron'){
					$block_chain_type = 'Tron';
					$block_chain_name = 'Tron';
				}
				if($block_chain_type == 'Tron'){
					$message = sprintf( __('
						Dear support, 
						I want to withdraw %s USDT (%s Euros) from my Online Cash account.
						I would like my funds to be sent to my USDT %s blockchain wallet address:%s
						Thank you!',CIP_TXTDOMAIN),number_format($body["usdt_amount_euro"], 2, '.', ''),number_format($body["usdt_amount_usdt"], 2, '.', ''),$block_chain_name,$_REQUEST["usdt_blockchain_address"] 
					);
				}else{
					$message = sprintf( __('
						Dear support, 
						I want to withdraw %s USDT (%s Euros) from my Online Cash account.
						I would like my funds to be sent to my USDT %s (%s) blockchain wallet address:%s
						Thank you!',CIP_TXTDOMAIN),number_format($body["usdt_amount_euro"], 2, '.', ''),number_format($body["usdt_amount_usdt"], 2, '.', ''),$block_chain_name,$block_chain_type,$_REQUEST["usdt_blockchain_address"] 
					);
				}
			}else{
				$message = sprintf( __('
					Dear support, 
					I want to withdraw %s CAD (%s Euros) from my Online Cash account.
					I would like my funds sent to my bank account as follows:
					Account holder: %s
					Bank account number: %s
					Bank code: %s
					Bank name: %s
					Bank address: %s 
					Thank you!',CIP_TXTDOMAIN),number_format($body["cad_amount_euro"], 2, '.', ''),number_format($body["cad_amount_cad"], 2, '.', ''),$body["account_holder"],$body["bank_iban"],$body["bank_bic"],$body["bank_name"],$body["bank_address"]
				);
			}
			$body_data = array( 
				'email' => $body['email'],
				'subject' => 'Withdrawal request',
				'message' => $message,
				'language' => 'en-GB',
				'name' => $body['name'],
				'category' => 3000,
				'status' => 1
			);
		}else if($type == 'deposit'){
			if( $body['type_of_deposit'] == 'CAD' ){
				$message = sprintf( __('
					Dear Support,
					I have sent %s CAD to Amplivo Canada Ltd bank account.
					Please upload %s Euros to the Amplivo online cash account username %s.
					Thank you!',CIP_TXTDOMAIN),number_format($body["amount_euro"], 2, '.', ''),number_format($body["exchange_amount"], 2, '.', ''),$body["username"]
				);
			}else{
				if($body["block_chain"] == 'ERC20'){
					$block_chain_name = 'Ethereum';
					$block_chain_address = '0x04f1e7d02386f9c436bce026fb0fa9f9a83d2f9c';
				}else if($body["block_chain"] == 'BSC'){
					$block_chain_name = 'Binance Smart Chain (BSC)';
					$block_chain_address = '0x04f1e7d02386f9c436bce026fb0fa9f9a83d2f9c';
				}else if($body["block_chain"] == 'Tron'){
					$block_chain_name = 'Tron';
					$block_chain_address = 'TQxgWbBUbAmjsrd22D7Vu8QV9PaX1HPahu';
				}
				$message = sprintf( __('
					Dear Support,
					I have sent %s USDT (%s) to the following address on the %s blockchain:
					%s 
					Please upload %s Euros to the Amplivo online cash account username %s 
					The transaction hash is %s 
					Thank you!',CIP_TXTDOMAIN),number_format($body["amount_euro"], 2, '.', ''),$body["block_chain"],$block_chain_name,$block_chain_address,number_format($body["exchange_amount"], 2, '.', ''),$body["username"],$body["transaction_hash"]
				);
			}
			$body_data = array( 
				'email' => $body['email'],
				'subject' => 'Deposit request',
				'message' => $message,
				'language' => 'en-GB',
				'name' => $body['name'],
				'category' => 3010,
				'status' => 1
			);
		}
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		
		$support_mode = get_option('amplivo_api_mode');
		$endpoint_url = '';
		if( $support_mode == 'live' ){
			$endpoint_url = 'https://amplivo.com/api/support/create';
		}else if( $support_mode == 'test' ){
			$endpoint_url = 'https://cloudhorizon.sandbox.jox.hu/api/support/create';
		}else{		
			$endpoint_url = '';
		}
		if( !empty( $endpoint_url ) ){
			$response = wp_remote_post( $endpoint_url, array(
				'method' 	=> 'POST',
				'body' 		=> $body_data,
			) );
			if( !is_wp_error( $response ) ){
				$response_data = json_decode($response['body'],true);
				// GFCommon::log_debug( 'gform_after_submission: response => ' . $response['body'] );
				create_cip_logs_entery( $user_id, 'member', '','member', $message, true );
				if($response_data['Status'] == 'success'){
					
					return $response_data['Ticket ID'];
				}
				 
			}
			
		}
	}
}
add_shortcode('REDEEM-AMPLIVO-GIFT-CODE','redeem_amplivo_gift_code_funcation_cb');
function redeem_amplivo_gift_code_funcation_cb(){
	$html = "";
	ob_start();
	?>
	<form name="redeem_amplivo_gift_code_funcation" id="redeem_amplivo_gift_code_funcation">
		<div class="row">
			<div class="col">
				<h3 class="text-left">Redeem Gift Code</h3>
				<hr class="py-3">
				<!-- <div class="redeem-text">Please Kindly note that your current Amplivo Business License has not expired yet.</div> -->
				<div class="form-group">
					<label for="redeem_gift_code"><?php _e('Gift Code',CIP_TXTDOMAIN) ?></label>
					<input type="text" class="form-control" id="redeem_gift_code" name="redeem_gift_code" value="" require>
				</div>
			</div>
		</div>
		<input type="hidden" name="action" value="redeem_amplivo_gift_code_funcation" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_Xupdatesasmredeem_amplivo_gift_code_funcation_'); ?>" />
		<input type="hidden" id="amplivo_gift_code_popup" name="popup" value="0">
		<button type="submit" class="btn btn-primary w-100"><?php _e('Redeem',CIP_TXTDOMAIN); ?></button>
		<p><span class="form_response"></span></p>
	</form>
	<div class="redeem_gift_code_contant">
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('SM-ampliov-url-change-SETTINGS','cip_sm_ampliov_url_change_settings_cb');
function cip_sm_ampliov_url_change_settings_cb(){
	$html = "";
	$ampliov_url_change = ( !empty( get_option('ampliov_url_change') ) ) ? get_option('ampliov_url_change') : 'Stage';
	$ampliov_url_change_live = ( !empty( get_option('ampliov_url_change_live') ) ) ? get_option('ampliov_url_change_live') : 'https://amplivo.com/';
	$ampliov_url_change_stage = ( !empty( get_option('ampliov_url_change_stage') ) ) ? get_option('ampliov_url_change_stage') : 'https://cloudhorizon.sandbox.jox.hu/';
	ob_start();
	?>
	<form name="sm_ampliov_url_set_frm" id="sm_ampliov_url_set_frm">
		<h5><?php 
		// _e('Email send0ing switch', CIP_TXTDOMAIN); 
		?></h5>
				
		<div class="form-group">
			<label for="ampliov_url_change">URL Change</label>
			<select id="ampliov_url_change" name="ampliov_url_change">
				<option <?php echo ($ampliov_url_change == 'live') ? 'selected' : '' ; ?>>Live</option>
				<option <?php echo ($ampliov_url_change == 'Stage') ? 'selected' : '' ; ?>>Stage</option>
			</select>
		</div>
		<div class="form-group">
			<label for="ampliov_url_change_live"><?php _e('Live URL',CIP_TXTDOMAIN) ?></label>
			<input type="text" class="form-control" id="ampliov_url_change_live" name="ampliov_url_change_live" value="<?php echo $ampliov_url_change_live;?>" require>
		</div>
		<div class="form-group">
			<label for="ampliov_url_change_stage"><?php _e('Stage URL',CIP_TXTDOMAIN) ?></label>
			<input type="text" class="form-control" id="ampliov_url_change_stage" name="ampliov_url_change_stage" value="<?php echo $ampliov_url_change_stage;?>" require>
		</div>
		<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
		<input type="hidden" name="action" value="cip_sm_ampliov_url_change_settings_act" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsm_csr_ampliov_url_change_settingxCIP_'); ?>" />
		</form>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_action('wp_ajax_cip_sm_ampliov_url_change_settings_act','cip_sm_ampliov_url_change_settings_act_cb');
function cip_sm_ampliov_url_change_settings_act_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_micro'],'_CIPxsm_csr_ampliov_url_change_settingxCIP_' ) && current_user_can( 'supportagent' ) ){
		
		$current_ip = cip_get_client_ip();
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		$valueData = array();
		$updated = false;
		$ampliov_url_change = ( !empty( get_option('ampliov_url_change') ) ) ? get_option('ampliov_url_change') : 'Stage';
		$ampliov_url_change_live = ( !empty( get_option('ampliov_url_change_live') ) ) ? get_option('ampliov_url_change_live') : 'https://amplivo.com/';
		$ampliov_url_change_stage = ( !empty( get_option('ampliov_url_change_stage') ) ) ? get_option('ampliov_url_change_stage') : 'https://cloudhorizon.sandbox.jox.hu/';
	
		if( isset( $_POST['ampliov_url_change'] ) && $_POST['ampliov_url_change'] != '' && $_POST['ampliov_url_change'] != $ampliov_url_change ){
			update_option( 'ampliov_url_change', $_POST['ampliov_url_change'] );
			$updated = true;
		}
		if( isset( $_POST['ampliov_url_change_stage'] ) && $_POST['ampliov_url_change_stage'] != '' && $_POST['ampliov_url_change_stage'] != $ampliov_url_change_stage ){
			update_option( 'ampliov_url_change_stage', $_POST['ampliov_url_change_stage'] );
			$updated = true;
		}
		if( isset( $_POST['ampliov_url_change_live'] ) && $_POST['ampliov_url_change_live'] != '' && $_POST['ampliov_url_change_live'] != $ampliov_url_change_live ){
			update_option( 'ampliov_url_change_live', $_POST['ampliov_url_change_live'] );
			$updated = true;
		}
		if($updated == true){
			
			$logs = 'updated url '.$ampliov_url_change.' to '.$_POST['ampliov_url_change'];
			create_cip_logs_entery( $user_id, 'setting_option', '','sm', $logs, true );
			$out = array( "error" => 0,'msg' => __('Updated',CIP_TXTDOMAIN) );
		}else{
			$out = array( "error" => 1,'msg' => __('Please Updated Value',CIP_TXTDOMAIN) );
		}
	}
	echo wp_json_encode( $out );
	exit;
}
function get_ampliov_link_url(){
	$ampliov_url_change = ( !empty( get_option('ampliov_url_change') ) ) ? get_option('ampliov_url_change') : 'Stage';
	$ampliov_url_change_live = ( !empty( get_option('ampliov_url_change_live') ) ) ? get_option('ampliov_url_change_live') : 'https://amplivo.com/';
	$ampliov_url_change_stage = ( !empty( get_option('ampliov_url_change_stage') ) ) ? get_option('ampliov_url_change_stage') : 'https://cloudhorizon.sandbox.jox.hu/';
	if($ampliov_url_change == 'Live'){
		return $ampliov_url_change_live;
	}else{
		return $ampliov_url_change_stage;
	}
}
add_shortcode( 'CIP-DEPOSIT-IFREAM', 'cip_deposit_ifream_funcation_cb' );
function cip_deposit_ifream_funcation_cb( $attr ){
	$html = "";
	ob_start();
	$endpoint_url = "https://academy.amplivo.com/wp-json/canada-deposit/v1/generate-token/";
	$iframe_site_url = "https://academy.amplivo.com";
	$current_user = wp_get_current_user();
	$body = array(
		"email" => $current_user->user_email
	);
	$response = wp_remote_post( $endpoint_url, array(
		'method' 	=> 'POST',
		'body' 		=> $body,
	) );
	if( !is_wp_error( $response ) ){
		$response_data = json_decode($response['body'],true);
		$token = $response_data['data']['token'];
	}else{
		$token = '';
	}
	$url_link = "https://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	?>
	<div>
		<iframe id="aac-auto-iframe" src="<?php echo $iframe_site_url;?>/deposit-ac/?token=<?php echo $token ?>&url=<?php echo $url_link ?>" width="100%" height="840px"  scrolling="yes" frameborder="0" style="border:none;">
		</iframe>
	<div>
	<script>
		jQuery(document).ready(function(){
			var block_config = { message: null,overlayCSS:{ backgroundColor: '#fff',opacity:0.8} };
			jQuery('body').block( block_config );
            jQuery('#aac-auto-iframe').on('load', function() {
                jQuery('body').unblock();
            });
        });
		function updateIframeHeight(height) {
            iframe.style.height = height + 'px';
        }
        window.addEventListener('message', function(event) {
            // Verify the origin of the message
            if (event.origin === '<?php echo $iframe_site_url;?>') {
				if (event.data.type === 'iframeClicked') {
					updateIframeHeight(event.data.height);
                    // Add your JavaScript code to run on iframe click here
                }else{
                	updateIframeHeight(event.data);
				}
            }
        });
        var iframe = document.getElementById('aac-auto-iframe');
        iframe.addEventListener('load', function() {
            // Send a message to the iframe to get its height
            iframe.contentWindow.postMessage('getHeight', '<?php echo $iframe_site_url;?>');
        });
        document.addEventListener('click', function() {
			// Send a message to the iframe to get its height on click
			iframe.contentWindow.postMessage('getHeight', '<?php echo $iframe_site_url;?>');
		});
	</script>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode( 'CIP-WITHDRAWAL-IFREAM', 'cip_withdrawal_ifream_funcation_cb' );
function cip_withdrawal_ifream_funcation_cb( $attr ){
	$html = "";
	ob_start();
	$endpoint_url = "https://academy.amplivo.com/wp-json/canada-deposit/v1/generate-token/";
	$iframe_site_url = "https://academy.amplivo.com";
	$current_user = wp_get_current_user();
	$body = array(
		"email" => $current_user->user_email
	);
	$response = wp_remote_post( $endpoint_url, array(
		'method' 	=> 'POST',
		'body' 		=> $body,
	) );
	if( !is_wp_error( $response ) ){
		$response_data = json_decode($response['body'],true);
		$token = $response_data['data']['token'];
	}else{
		$token = '';
	}
	$url_link = "https://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	?>
	<div>
		<iframe id="aac-auto-iframe" src="<?php echo $iframe_site_url;?>/request-withdrawal-ac/?token=<?php echo $token ?>&url=<?php echo $url_link ?>" width="100%" height="990px"  scrolling="yes" frameborder="0" style="border:none;">
		</iframe>
	<div>
	<script>
		jQuery(document).ready(function(){
			var block_config = { message: null,overlayCSS:{ backgroundColor: '#fff',opacity:0.8} };
			jQuery('body').block( block_config );
            jQuery('#aac-auto-iframe').on('load', function() {
                jQuery('body').unblock();
            });
        });
		
		function updateIframeHeight(height) {
            iframe.style.height = height + 'px';
        }
        window.addEventListener('message', function(event) {
            // Verify the origin of the message
            if (event.origin === '<?php echo $iframe_site_url;?>') {
				if (event.data.type === 'iframeClicked') {
					updateIframeHeight(event.data.height);
                    // Add your JavaScript code to run on iframe click here
                }else{
                	updateIframeHeight(event.data);
				}
            }
        });
        var iframe = document.getElementById('aac-auto-iframe');
        iframe.addEventListener('load', function() {
            // Send a message to the iframe to get its height
            iframe.contentWindow.postMessage('getHeight', '<?php echo $iframe_site_url;?>');
        });
        document.addEventListener('click', function() {
			// Send a message to the iframe to get its height on click
			iframe.contentWindow.postMessage('getHeight', '<?php echo $iframe_site_url;?>');
		});
	</script>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CIP-SITE-MAINTENANCE-MODE','cip_site_maintenance_mode_callback');
function cip_site_maintenance_mode_callback(){
	$html = "";
	ob_start();
    ?>
    <div class="col-12 p-3">
        <div class="boxDiv">
            <form class="routine_maintenance_frm" id="routine_maintenance_frm">
                <p style="margin-bottom:0;"><?php _e('Live Site Maintenance Mode',CIP_TXTDOMAIN); ?></p>
                <div class="custom-control custom-switch routine_maintenance_mode pl-0" style="padding-left: 35px !important;padding-top: 10px;">
                    <input type="checkbox" class="custom-control-input" id="routine_maintenance_mode" name="routine_maintenance_mode" value="1" <?php echo checked( get_option('cip_routine_maintenance_mode'), 1 ); ?> />
                    <label class="custom-control-label" for="routine_maintenance_mode"><?php _e('Enable/Disable',CIP_TXTDOMAIN); ?></label>
                </div>
                <input type="hidden" name="action" value="routine_maintenance_mode_act">
                <input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XYroutinemaintenancemodeYX_'); ?>">
                <p><span class="form_response"></span></p>
            </form>
            <form class="site_maintenance_frm" id="site_maintenance_frm">
				<p style="margin-bottom:0;"><?php _e('Whole Site Maintenance Mode',CIP_TXTDOMAIN); ?></p>
                <div class="custom-control custom-switch site_maintenance_frm pl-0" style="padding-left: 35px !important;padding-top: 10px;">
                    <input type="checkbox" class="custom-control-input" id="site_maintenance_mode" name="site_maintenance_mode" value="1" <?php echo checked( get_option('cip_site_maintenance_mode'), 1 ); ?> />
                    <label class="custom-control-label" for="site_maintenance_mode"><?php _e('Enable/Disable',CIP_TXTDOMAIN); ?></label>
                </div>
                <input type="hidden" name="action" value="site_maintenance_mode_act">
                <input type="hidden" name="_sitemicro" value="<?php echo wp_create_nonce('_XYsite_maintenance_modeYX_'); ?>">
                <p><span class="form_response"></span></p>
            </form>
        </div>
    </div>
    <?php
    $html .= ob_get_clean();
	return $html;
}
add_shortcode('maintenance-form-settings','cip_maintenance_form_settings_cb');
function cip_maintenance_form_settings_cb(){
	$maintenance_live_option = get_option( 'maintenance_live_option' ,true);
	$maintenance_whole_option = get_option( 'maintenance_whole_option' ,true);
	// print_r($maintenance_live_option);
	?>
	<form id="maintenance_form" class="pt-3">
		<div class="row">
			<div class="form-group col-lg-6 col-md-6 col-12">
				<label for="live_title">Live Site Maintenance Title</label>
				<textarea id="live_title" name="live_title"><?php echo $maintenance_live_option['title']; ?></textarea>
			</div>
			<div class="form-group col-lg-6 col-md-6 col-12">
				<label for="live_message">Live Site Maintenance Message</label>
				<textarea id="live_message" name="live_message"><?php echo $maintenance_live_option['message']; ?></textarea>
			</div>
			<div class="form-group col-lg-6 col-md-6 col-12">
				<label for="whole_title">Whole Site Maintenance Title</label>
				<textarea id="whole_title" name="whole_title"><?php echo $maintenance_whole_option['title']; ?></textarea>
			</div>
			<div class="form-group col-lg-6 col-md-6 col-12">
				<label for="whole_message">Whole Site Maintenance Message</label>
				<textarea id="whole_message" name="whole_message"><?php echo $maintenance_whole_option['message']; ?></textarea>
			</div>
		</div>
        <button type="submit" class="btn btn-primary"><?php _e('Save',CIP_TXTDOMAIN); ?></button>
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxmaintenance_form_settingsxCIP_'); ?>" />
    </form>
	<?php
}
add_shortcode('Routin-Maintenance-Message','cip_routin_maintenance_logs_view_cb');
function cip_routin_maintenance_logs_view_cb(){
	$html = "";
	ob_start();
	$cip_routine_maintenance_mode = get_option( 'cip_routine_maintenance_mode' ,true);
	if($cip_routine_maintenance_mode == 1){
		$maintenance_live_option = get_option( 'maintenance_live_option' ,true);
		?>
		<div class="routine_maintenance_mode_section">
			<h2><?php echo $maintenance_live_option['title']; ?></h2>
			<p><?php echo nl2br( $maintenance_live_option['message'] ); ?></p>
		</div>
		<?php
	}
	$cip_site_maintenance_mode = get_option( 'cip_site_maintenance_mode' ,true);
	if($cip_site_maintenance_mode == 1){
		$maintenance_whole_option = get_option( 'maintenance_whole_option' ,true);
		?>
		<div class="routine_maintenance_mode_section">
			<h2><?php echo $maintenance_whole_option['title']; ?></h2>
			<p><?php echo nl2br( $maintenance_whole_option['message'] ); ?></p>
		</div>
		<?php
	}
	$login_page_id = get_option( 'login_page_url' );
	if(is_page(  $login_page_id ) && ($cip_routine_maintenance_mode == 1 || $cip_site_maintenance_mode == 1)){
		?>
		<div class="routine_maintenance_mode_section">
			<button class="btn btn-primary" id="close_login_maintenance"><?php _e('Okay', CIP_TXTDOMAIN); ?></button>
		</div>
		<script>
			jQuery(document).on('ready',function(){
				jQuery('.login-page-main-section').hide();
				jQuery(document).on('click', '#close_login_maintenance',function(){
					jQuery('.login-page-main-section').show();
					jQuery('.login-page-maintenance-section').hide();
				})
			});
		</script>
		<?php
	}else{
		?>
		<script>
			jQuery(document).on('ready',function(){
				jQuery('.login-page-main-section').show();
				jQuery('.login-page-maintenance-section').hide();
			});
		</script>
		<?php
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('Routin-Live-Maintenance-title','aac_routin_live_maintenance_title_view_cb');
function aac_routin_live_maintenance_title_view_cb(){
	$html = "";
	ob_start();
	$cip_routine_maintenance_mode = get_option( 'cip_routine_maintenance_mode' ,true);
	
	if($cip_routine_maintenance_mode == 1){
		$maintenance_live_option = get_option( 'maintenance_live_option' ,true);
		echo $maintenance_live_option['title'];
	}else{
		echo "Verify it's you.";
	}
	$html .= ob_get_clean();
	return $html; 
	
	//live-maintenance-verify-section
	//verify-section-default
}
add_shortcode('Routin-Live-Maintenance-contant','aac_routin_live_maintenance_contant_view_cb');
function aac_routin_live_maintenance_contant_view_cb(){
	$html = "";
	ob_start();
	$cip_routine_maintenance_mode = get_option( 'cip_routine_maintenance_mode' ,true);
	
	if($cip_routine_maintenance_mode == 1){
		$maintenance_live_option = get_option( 'maintenance_live_option' ,true);
		echo sprintf( __('<div class="text-center">%s</div>', CIP_TXTDOMAIN),nl2br( $maintenance_live_option['message'] ));
		?>
		<style>
			#footer_canada_verify_button > .elementor-container {
				max-width: 510px;
			}
			#footer_canada_verify_button .elementor-button-wrapper {
				text-align: center;
			}
		</style>
		<?php
	}else{
		echo sprintf( __('To keep your account secure we need to verify it’s you.
Please login to continue your visit on Amplivo Canada.', CIP_TXTDOMAIN));
	}
	$html .= ob_get_clean();
	return $html;
}


add_shortcode('SM-PRICE-TYPE-SETTINGS','cip_sm_price_type_setting_cb');
function cip_sm_price_type_setting_cb(){
	$html = "";
	$ampliov_price_type = ( !empty( get_option('ampliov_price_type') ) ) ? get_option('ampliov_price_type') : 'CSR';
	
	ob_start();
	?>
	<form name="sm_ampliov_price_type_setting_form" id="sm_ampliov_price_type_setting_form">
		<h5><?php 
		// _e('Email send0ing switch', CIP_TXTDOMAIN); 
		?></h5>
				
		<div class="form-group">
			<label for="ampliov_price_type">Select Price Type</label>
			<select id="ampliov_price_type" name="ampliov_price_type">
				<option <?php echo ($ampliov_price_type == 'CSR') ? 'selected' : '' ; ?>>CSR</option>
				<option <?php echo ($ampliov_price_type == 'CSR25') ? 'selected' : '' ; ?>>CSR25</option>
			</select>
		</div>
		<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
		<input type="hidden" name="action" value="cip_sm_ampliov_price_type_settings_act" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsm_csr_ampliov_price_type_settingxCIP_'); ?>" />
		</form>
	<?php
	$html .= ob_get_clean();
	return $html;
}


add_action('wp_ajax_cip_sm_ampliov_price_type_settings_act','cip_sm_ampliov_price_type_settings_act_cb');
function cip_sm_ampliov_price_type_settings_act_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_micro'],'_CIPxsm_csr_ampliov_price_type_settingxCIP_' ) && current_user_can( 'supportagent' ) ){
		
		$current_ip = cip_get_client_ip();
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		$valueData = array();
		$updated = false;
		$ampliov_price_type = ( !empty( get_option('ampliov_price_type') ) ) ? get_option('ampliov_price_type') : 'CSR';
	
		if( isset( $_POST['ampliov_price_type'] ) && $_POST['ampliov_price_type'] != '' && $_POST['ampliov_price_type'] != $ampliov_price_type ){
			update_option( 'ampliov_price_type', $_POST['ampliov_price_type'] );
			$updated = true;
		}
		if($updated == true){
			
			$logs = 'updated price type '.$ampliov_price_type.' to '.$_POST['ampliov_price_type'];
			
			create_cip_logs_entery( $user_id, 'member', '','member', $logs, true );
			$out = array( "error" => 0,'msg' => __('Updated',CIP_TXTDOMAIN) );
		}else{
			$out = array( "error" => 1,'msg' => __('Please Updated Value',CIP_TXTDOMAIN) );
		}
	}
	echo wp_json_encode( $out );
	exit;
}


add_shortcode('SM-CSR25-SELLING-PRICE-SETTINGS','cip_sm_csr25_selling_price_setting_cb');
function cip_sm_csr25_selling_price_setting_cb(){
	$html = "";
	$selling_price_csr25 = ( !empty( get_option('selling_price_csr25') ) ) ? get_option('selling_price_csr25') : '';
	
	ob_start();
	?>
	<form name="sm_selling_price_csr25_setting_form" id="sm_selling_price_csr25_setting_form">
		<h5><?php 
		// _e('Email send0ing switch', CIP_TXTDOMAIN); 
		?></h5>
				
		<div class="form-group">
			<label for="selling_price_csr25">CSR25 Selling Price</label>
			<input type="text" class="form-control" id="selling_price_csr25" name="selling_price_csr25" value="<?=$selling_price_csr25?>">
				
		</div>
		<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
		<input type="hidden" name="action" value="cip_sm_csr25_selling_price_settings_act" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsm_csr_ampliov_price_type_settingxCIP_'); ?>" />
		</form>
	<?php
	$html .= ob_get_clean();
	return $html;
}


add_action('wp_ajax_cip_sm_csr25_selling_price_settings_act','cip_sm_csr25_selling_price_settings_act_cb');
function cip_sm_csr25_selling_price_settings_act_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_micro'],'_CIPxsm_csr_ampliov_price_type_settingxCIP_' ) && current_user_can( 'supportagent' ) ){
		
		$current_ip = cip_get_client_ip();
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		$valueData = array();
		$updated = false;
		$selling_price_csr25 = ( !empty( get_option('selling_price_csr25') ) ) ? get_option('selling_price_csr25') : 'CSR';
	
		if( isset( $_POST['selling_price_csr25'] ) && $_POST['selling_price_csr25'] != '' && $_POST['selling_price_csr25'] != $selling_price_csr25 ){
			update_option( 'selling_price_csr25', $_POST['selling_price_csr25'] );
			$updated = true;
		}
		if($updated == true){
			$logs = 'updated csr25 selling price '.$selling_price_csr25.' to '.$_POST['selling_price_csr25'];

			create_cip_logs_entery( $user_id, 'member', '','member', $logs, true );
			$out = array( "error" => 0,'msg' => __('Updated',CIP_TXTDOMAIN) );
		}else{
			$out = array( "error" => 1,'msg' => __('Please Updated Value',CIP_TXTDOMAIN) );
		}
	}
	echo wp_json_encode( $out );
	exit;
}

//MFP changes
add_shortcode('SM-MFP-SETTINGS','acc_sm_mfp_settings_cb');
function acc_sm_mfp_settings_cb(){
	$html = "";
	$vpn_switch_toggle= ( !empty( get_option('vpn_switch_toggle') ) ) ? get_option('vpn_switch_toggle') : 0 ;

	$proxy_switch_toggle = ( !empty( get_option('proxy_switch_toggle') ) ) ? get_option('proxy_switch_toggle') : 0 ;

	$tron_switch_toggle = ( !empty( get_option('tron_switch_toggle') ) ) ? get_option('tron_switch_toggle') : 0 ;

	ob_start();

	?>

	<form name="sm_mfp_setting_frm" id="sm_mfp_setting_frm">

		<div class="row">

			<div class="col-md-6">

				<div class="form-group">

                    <!-- VPN -->
					<div class="custom-control custom-switch">

						<input type="checkbox" class="custom-control-input" name="vpn_switch_toggle" id="vpn_switch_toggle" value="1" <?php checked(1, $vpn_switch_toggle, true); ?>>

						<label class="custom-control-label sms_admin_login" for="vpn_switch_toggle">
							<?php _e('VPN', AACTXTDOMAIN); ?>
						</label>

					</div>

                    <!-- Proxy -->
					<div class="custom-control custom-switch">

						<input type="checkbox" class="custom-control-input" name="proxy_switch_toggle" id="proxy_switch_toggle" value="1" <?php checked(1, $proxy_switch_toggle, true); ?>>

						<label class="custom-control-label sms_admin_login" for="proxy_switch_toggle">
							<?php _e('Proxy', AACTXTDOMAIN); ?>
						</label>

					</div>

                    <!-- TRON -->
					<div class="custom-control custom-switch">

						<input type="checkbox" class="custom-control-input" name="tron_switch_toggle" id="tron_switch_toggle" value="1" <?php checked(1, $tron_switch_toggle, true); ?>>

						<label class="custom-control-label sms_admin_login" for="tron_switch_toggle">
							<?php _e('TOR', AACTXTDOMAIN); ?>
						</label>

					</div>

				</div>

			</div>

		</div>

		<button type="submit" class="btn btn-primary"><?php _e('Save', AACTXTDOMAIN); ?></button>

		<input type="hidden" name="action" value="acc_sm_mfp_settings_act" />

		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_ACCsm_acc_mfp_settingACC_'); ?>" />

	</form>

	<form name="vpn_api_key_settings" id="vpn_api_key_settings">
		<h3><?php _e('VPN API Key Setting', 'aachelper'); ?></h3>

		<div class="row">
			<div class="col-12">
				<div class="form-group">
					<label for="vpn_api_key"><?php echo __("VPN API key" , "aachelper"); ?></label>
					<input type="text" id="vpn_api_key" name="vpn_api_key"  value="<?php echo get_option( 'vpn_api_key' ); ?>" class="regular-text form-control" pattern=".*\S+.*" required/>
				</div>
			</div>
		</div>
		<button type="submit" class="btn btn-primary"><?php _e('Save', 'aachelper'); ?></button>
		<input type="hidden" name="action" value="acc_vpn_api_settings_act" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_ACCxvpnapisettingxACC_'); ?>" />
		<p class="form_response"></p>
	</form>

	<?php

	$html .= ob_get_clean();

	return $html;

}

add_action('wp_ajax_acc_sm_mfp_settings_act','acc_sm_mfp_settings_act_cb');
function acc_sm_mfp_settings_act_cb(){

	$out = array( "error" => 1,'msg' => __('Something went wrong.',AACTXTDOMAIN) );

	if( wp_verify_nonce( $_POST['_micro'],'_ACCsm_acc_mfp_settingACC_' ) && current_user_can( 'supportagent' ) ){

		$current_user = wp_get_current_user();

		$user_id = $current_user->ID;

		//vpn
		if( isset( $_POST['vpn_switch_toggle'] ) && $_POST['vpn_switch_toggle'] == 1 ){
			update_option( 'vpn_switch_toggle', 1 );
		}else{
			update_option( 'vpn_switch_toggle', 0 );
		}
		//proxy
		if( isset( $_POST['proxy_switch_toggle'] ) && $_POST['proxy_switch_toggle'] == 1 ){
			update_option( 'proxy_switch_toggle', 1 );
		}else{
			update_option( 'proxy_switch_toggle', 0 );
		}
		//tron
		if( isset( $_POST['tron_switch_toggle'] ) && $_POST['tron_switch_toggle'] == 1 ){
			update_option( 'tron_switch_toggle', 1 );
		}else{
			update_option( 'tron_switch_toggle', 0 );
		}

		$vpn_status = ( get_option('vpn_switch_toggle') == 1 ) ? 'Activate' : 'Deactivate' ;
		$proxy_status = ( get_option('proxy_switch_toggle') == 1 ) ? 'Activate' : 'Deactivate' ;
		$tron_status = ( get_option('tron_switch_toggle') == 1 ) ? 'Activate' : 'Deactivate' ;

		$log_message = sprintf(
			__('MFP Settings Updated: VPN is %s, Proxy is %s, TOR is %s. Updated by %s at %s', AACTXTDOMAIN),
			$vpn_status,
			$proxy_status,
			$tron_status,
			$current_user->user_email,
			date_i18n('d/m/Y H:i A')
		);

		create_cip_logs_entery( $user_id, 'mfp settings', '','sm', $log_message, true );

		$out = array( "error" => 0,'msg' => __('Updated',AACTXTDOMAIN) );
	}
	echo wp_json_encode( $out );
	exit;
}

add_action('wp_ajax_acc_vpn_api_settings_act','acc_vpn_api_settings_act_cb');
function acc_vpn_api_settings_act_cb(){

	$out = array( "error" => 1,'msg' => __('Something went wrong.',AACTXTDOMAIN) );

	if( wp_verify_nonce( $_POST['_micro'],'_ACCxvpnapisettingxACC_' ) && current_user_can( 'supportagent' ) ){

		$vpn_api_key_updated = update_option('vpn_api_key', $_POST['vpn_api_key']);

		$user = wp_get_current_user();
		$message = sprintf( __('VPN API key updated by %s at %s. %s', 'aachelper'), $user->user_email, date_i18n('d/m/Y H:i A'), '' );
		create_cip_logs_entery( $user->ID, 'vpn api key setting', '', 'sm', $message );
		$out = array( "error" => 0,'msg' => __('VPN API key Saved','aachelper') );
	}
	echo wp_json_encode( $out );
	exit;
}
//MFP changes END