<?php

function cors_support_agent_registration_form() {

	echo '
    <style>

    input[type="text"],input[type="email"] {
    width: 100%;
	}
    input[type="submit"] {
        background: #fff;
        border: none;
        padding: 6px 30px;
        border-radius:2px;
        color:#143f5e;
        font-weight:500;
    }
	input[type="submit"]:hover, input[type="submit"]:focus {
	 	background:#fff;
		color:#143f5e;
		outline:none;
		border:none;
	 }
    </style>
    ';

    echo '
    <h3 style="color:#fff;">Register Support Agent</h3>
    
	<form action="" method="post">

    <div><input type="hidden" name="username" ></div>
     
    <div>
    <label for="email">Email <strong>*</strong></label><br>
    <input type="email" name="email" class="form-control" aria-describedby="emailHelp" placeholder="Enter email" required />
    </div>
        
    <div>
    <label for="firstname">First Name <strong>*</strong></label><br>
    <input class="form-control" type="text" placeholder="Enter first name" name="fname" required />
    </div>
     
    <div>
    <label for="website">Last Name</label><br>
    <input class="form-control" type="text" placeholder="Enter last name" name="lname"><br>
    </div>
	
	<!--div>
    <label style="color:#fff;" for="status">Status <strong>*</strong></label><br>
    <select name="status">
		<option>Active</option>
		<option>In-active</option>
	</select><br>
    </div-->

    <div>
    <input type="submit" class="btn btn-primary" name="submit" value="Register"/>
    <div>
    
    </form>
    ';
}

function cors_support_agent_registration_validation( $username, $password, $email, $first_name, $last_name)  {
    global $reg_errors;
    $reg_errors = new WP_Error;

    if ( username_exists( $username ) )
    {
        $reg_errors->add('user_name', 'The username you entered already exists!');
    }
    if ( ! validate_username( $username ) )
    {
        $reg_errors->add( 'username_invalid', 'The username you entered is not valid!' . $username );
    }
    if ( ! is_email( $email ) )
    {
        $reg_errors->add( 'email_invalid', 'Email id is not valid!' );
    }
    
    if ( email_exists( $email ) )
    {
        $reg_errors->add( 'email', 'Email Already exist!' );
    }
    
    if (is_wp_error( $reg_errors ))
    { 
        foreach ( $reg_errors->get_error_messages() as $error )
        {
             $signUpError='<p class="register-sm-sa-error" style="color:#FF0000; text-aling:left;"><strong>ERROR</strong>: '.$error . '<br /></p>';
             
        } 
        echo $signUpError;
    }
}
function cors_support_agent_complete_registration() {
    global $reg_errors, $username, $password, $email, $first_name, $last_name, $status;
    if ( 1 > count( $reg_errors->get_error_messages() ) ) {
        $userdata = array(
        'user_login'    =>   $username,
        'user_email'    =>   $email,
        'user_pass'     =>   $password,
        'first_name'    =>   $first_name,
        'last_name'     =>   $last_name,
		'status'        =>   $status,
        'role'          =>   'supportagent'
        );
        $user = wp_insert_user( $userdata );
		if( !is_wp_error( $user ) ){
            update_user_meta( $user, 'cip_user_status', 'active' );
            update_user_meta( $user, 'csrnow_login_enable', 1 );

            $user_id = $user;
            $user_info = get_userdata($user_id);
            update_user_meta( $user_id, 'csrnow_login_enable', 1 );
            $unique = get_password_reset_key( $user_info );
            $unique_url = network_site_url("wp-login.php?action=rp&key=$unique&login=" . rawurlencode($user_info->user_login), 'login');

            $blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
            $siteUrl = get_bloginfo('url');
            $siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
            add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
            add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
            add_filter('wp_mail_content_type', function(){ return "text/html"; } );

            $subject = sprintf(__("%s - You account has been created Succefully!", 'corsair-login'), $blogname);
    
            $htmlurl = CLOG_PLUGIN_URL.'mail_template.html';
            $htmlContent = file_get_contents($htmlurl);
            $unique_url_txt = disable_email_link( $unique_url );

            $message = sprintf(__('<br><p>You are registered Succesfully on our website</p><p>This is an e-mail from %s.</p> <p>You are receiving this email because we received a password reset request for your account.</p><br/> <p><a href="%s" target="_blank" REPLACE_STYLE>Reset Password</a></p><br/>If the button above does not work, paste this link into your web browser: <br> %s <br> If you did not make this request, you can safely ignore this e-mail.<br/><p>This is an automated message, please do not reply.</p><br/><p>Best regards,<br/>Amplivo</p>', 'corsair-login'),$blogname, esc_url($unique_url), $unique_url_txt );
            $corsair_emailtmpl_logo = ( get_option( 'corsair_emailtmpl_logo' ) ) ? get_option( 'corsair_emailtmpl_logo') : '';
            $corsair_emailtmpl_basecolor = ( get_option( 'corsair_emailtmpl_basecolor' ) ) ? get_option( 'corsair_emailtmpl_basecolor') : '';
            $corsair_emailtmpl_headercss = ( get_option( 'corsair_emailtmpl_headercss' ) ) ? get_option( 'corsair_emailtmpl_headercss') : '';
            
            $htmlContent = str_replace('REPLACE_MESSAGE', $message, $htmlContent);
            $htmlContent = str_replace('REPLACE_SITEURL', site_url(), $htmlContent);
            $htmlContent = str_replace('REPLACE_COPYRIGHT', 'Copyright © Amplivo  '.date('Y').'. All rights reserved.', $htmlContent);
            $htmlContent = str_replace('REPLACE_HEADER_LOGO', $corsair_emailtmpl_logo, $htmlContent);
            $htmlContent = str_replace('REPLACE_STYLE', 'style="font-size: 18px; font-family: Google Sans, Arial, Helvetica, sans-serif; color: #ffffff; text-decoration: none; padding: 6px 24px; display: inline-block;'.$corsair_emailtmpl_basecolor.'"', $htmlContent);
            $htmlContent = str_replace('REPLACE_FOOTER_STYLE', $corsair_emailtmpl_basecolor, $htmlContent);
            $htmlContent = str_replace('REPLACE_HEADER_STYLE', $corsair_emailtmpl_headercss, $htmlContent);
            
            $sent_mail = wp_mail( $email, $subject, $htmlContent );

            $current_user = wp_get_current_user();
			$user_id = $current_user->ID;
            $logs = sprintf( __('New Support agent(%s) registered by %s at %s', CIP_TXTDOMAIN), $email, $current_user->user_email, date_i18n('d/m/Y H:i A') );
            create_cip_logs_entery( $user_id, 'register', '','sm', $logs, true );

			echo '<p class="register-sm-sa-success" style="color:#4caf50; text-aling:left;">New Support Agent User is registered successfully.</p>';			
		}else{
			echo '<p class="register-sm-sa-error" style="color:#FF0000; text-aling:left;">'.$user->get_error_message().'</p>';
		}
		
    }
}

function cors_support_agent_registration_function() {
    if ( isset($_POST['submit'] ) ) {

        $username = sanitize_user( strstr($_POST['email'], '@', true), true );

        cors_support_agent_registration_validation(
        $username,
        $_POST['password'],
        $_POST['email'],
        $_POST['fname'],
        $_POST['lname'],
		$_POST['status']
        );
         
        // sanitize user form input
        global $username, $password, $email, $first_name, $last_name, $status;
        $username   =   sanitize_user( strstr($_POST['email'], '@', true), true );
        $password   =   esc_attr( $_POST['password'] );
        $email      =   sanitize_email( $_POST['email'] );
        $first_name =   sanitize_text_field( $_POST['fname'] );
        $last_name  =   sanitize_text_field( $_POST['lname'] );
		$status     =   esc_attr($_POST['status']);
 
        // call @function complete_registration to create the user
        // only when no WP_error is found
        cors_support_agent_complete_registration(
        $username,
        $password,
        $email,
        $first_name,
        $last_name,
		$status
        );
    }
 
    cors_support_agent_registration_form();
}
?>