<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('Importer')) {

    class Importer {

        public function __construct() {

            $multisite_active= false;
            if(is_multisite()){
                //$plugins = get_plugins(); // returns all plugins, whether active or not
  
                //$sites = get_sites();
                $blog_id = get_current_blog_id(); //Current blog ID
                $network_active_plugins = get_site_option('active_sitewide_plugins'); // Network activated plugins
                $site_active_plugins = get_blog_option($blog_id , 'active_plugins'); //Current blog activated plugins // meed to test this
 

                if (array_key_exists("gravityforms/gravityforms.php", $network_active_plugins) || array_key_exists("gravityforms/gravityforms.php", $site_active_plugins))
                {
                    $multisite_active = true;
                }
                
            }
            
            if (in_array('gravityforms/gravityforms.php', apply_filters('active_plugins', get_option('active_plugins'))) || $multisite_active) {

                // add gf custom capability
                add_action('admin_init',array($this, 'gf_import_add_cap'));
// add style and scripts
                add_action('admin_enqueue_scripts', array($this, 'gfei_enqueue_admin_assets'));

// add plugin pages
                add_action('admin_menu', array($this, 'gfei_custom_menu_page'));

// ajax function to upload csv
                add_action('wp_ajax_gfei_upload_csv', array($this, 'gfei_upload_csv_callback'));

// ajax function to get form fields for mapping
                add_action('wp_ajax_gfei_get_form_fields', array($this, 'gfei_get_form_fields_callback'));

// ajax function to import csv as chunks
                add_action('wp_ajax_gfei_import_csv', array($this, 'gfei_import_csv_callback'));
                add_action('wp_ajax_gfei_save_template', array($this, 'gfei_save_template_callback'));
                add_action('wp_ajax_gfei_load_template', array($this, 'gfei_load_template_callback'));
// Remove template ajax function callback
                add_action('wp_ajax_gfei_remove_template', array($this, 'gfei_remove_template_callback'));
            } else {
// show notice if Gravity Forms plugin is not active
                add_action('admin_notices', array($this, 'gfei_inactive_plugin_notice'));
            }
        }

        public function gfei_inactive_plugin_notice() {
            ?>
            <div id="message" class="error"><p><?php printf(__('Gravity Forms Entries Import requires Gravity Forms to be installed and active!', 'gf_entries_import')); ?></p></div>
            <?php
        }

        public function gfei_enqueue_admin_assets($hook) {

            if (in_array($hook, ['toplevel_page_gf-entries-import', 'gf-importer_page_gf-import-settings'])) {
//wp_enqueue_style('gfei_jquery_ui_style', "https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css");
                wp_enqueue_style('gfei_bootstrap_style', 'https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css');
                wp_enqueue_style('gfei_font_awesome_style', "https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css");
//wp_enqueue_script('gfei_jquery_ui_script', "https://code.jquery.com/ui/1.12.1/jquery-ui.js", array('jquery'));
                wp_enqueue_script('gfei_bootstrap_script', "https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js", array('jquery'));

                wp_enqueue_style('gfei_css', GFEI_MODIFY_PLUGIN_URL . 'assets/css/style.css');
                wp_enqueue_script('gfei_bootbox_script', GFEI_MODIFY_PLUGIN_URL . 'assets/js/bootbox.min.js', array('gfei_bootstrap_script'));
                wp_enqueue_script('gfei_script', GFEI_MODIFY_PLUGIN_URL . 'assets/js/script.js', array('gfei_bootbox_script'));
                wp_localize_script('gfei_script', 'messages', array('error_message' => __('Error', 'gf_entries_import'), 'no_file_message' => __('No file seleced', 'gf_entries_import'), 'import_success_message' => __('Your file was imported successfully', 'gf_entries_import'), 'import_error_message' => __('Your file contains error nothing to import', 'gf_entries_import'), 'no_import_condition_message' => __('Your file doesnt match condition nothing to import', 'gf_entries_import')));
            }
        }

        public function gfei_custom_menu_page() {
            add_menu_page('Gravity Forms Entries Import', 'GF Importer', 'gf_import_entries_cap', 'gf-entries-import', array($this, 'gfei_import_page_callback'), 'dashicons-arrow-down-alt', apply_filters('gfei_menu_position', '17'));
            add_submenu_page('gf-entries-import', 'Gravity Forms Import Settings', 'Settings', 'gf_import_entries_cap', 'gf-import-settings', array($this, 'gfei_settings_page_callback'));

//call register settings function
            add_action('admin_init', array($this, 'gfei_register_settings'));
        }

        public function gfei_register_settings() {
            register_setting('gfei-plugin-settings', 'gfei_delimiter');
            register_setting('gfei-plugin-settings', 'gfei_rows_per_import');
            register_setting('gfei-plugin-settings', 'gfei_validate_csv');
        }

        public function gfei_import_page_callback() {
            /* echo "<pre>";
              print_r(RGFormsModel::get_form_meta(11));
              echo "</pre>"; */
            ?>
            <div class="wrap gfei-wrapper">
                <h2><?php _e('Gravity Forms Entries Import', 'gf_entries_import') ?></h2>

                <div id="section_one">
                    <form action="" method="post" enctype="multipart/form-data">
                        <table class="form-table">
                            <tr valign="top">
                                <th scope="row"><?php _e('Upload CSV', 'gf_entries_import') ?></th>
                                <td>
                                    <input type="file" name="gfei_csv" id="gfei_csv"/>
                                </td>
                            </tr>

                            <tr valign="top">
                                <th scope="row"><?php _e('Form', 'gf_entries_import') ?></th>
                                <td>
                                    <select name="gfei_form" id="gfei_form">
                                        <?php
                                        $forms = RGFormsModel::get_forms(null, 'title');
                                        foreach ($forms as $form) {
                                            ?>
                                            <option value="<?php echo absint($form->id) ?>"><?php echo esc_html($form->title) ?></option>
                                            <?php
                                        }
                                        ?>
                                    </select><br/>
                                    <span class="description"><?php _e('Choose the gravity form which entries will be imported to', 'gf_entries_import') ?></span>
                                </td>
                            </tr>
                        </table>

                        <input name="gfei_submit" id="gfei_submit" class="button button-primary" value="<?php _e('Upload', 'gf_entries_import') ?>" type="button">
                    </form>
                </div>

                <div id="section_two" style="display: none;">
                    <div class="loader_container" style="display: none;">
                        <img class="fields_loader" src="<?php echo GFEI_MODIFY_PLUGIN_URL . 'assets/img/loader.gif' ?>" width="30" height="30">
                        <span><?php _e('Loading Form fields', 'gf_entries_import') ?></span>
                    </div>

                    <div class="fields_mapping_container">

                    </div>
                </div>

                <div id="section_three" style="display: none;">
                    <h4><?php _e('Import Log', 'gf_entries_import') ?></h4>
                    <div class="gfei_download_log_container" style="display: none;">
                        <a id="gfei_download_log_link" class="gfei_log_button" href="" download><?php _e('Download Log File', 'gf_entries_import') ?></a>
                        <a id="gfei_download_csv_link" class="gfei_csv_button" href="" download><?php _e('Download CSV File', 'gf_entries_import') ?></a>
                    </div>
                    <ul id="gfei_log_container"></ul>
                </div>
            </div>
            <?php
        }

        public function gfei_upload_csv_callback() {
            ini_set('memory_limit', '-1');
            $status = false;
            $message = '';
            $url = '';
            $log_id = 0;

            $validate_csv = get_option('gfei_validate_csv');

//print_r($_FILES);exit;
            if (!isset($_FILES['file']['name'])) {
                $message = __('No file seleced', 'gf_entries_import');
            } else if (!in_array($_FILES['file']['type'], ['text/csv', 'application/vnd.ms-excel', 'text/comma-separated-values']) && empty($validate_csv)) {
                $message = __('You should upload CSV file', 'gf_entries_import');
            } else {
// First, make sure the directory to which we want to upload exists.
                $uploads_dir = ABSPATH . 'wp-content/uploads/gf_import_files/csvs';
                wp_mkdir_p($uploads_dir);

// Now we'll move the temporary file to uploads directory.
                $source = $_FILES['file']['tmp_name'];
                $destination = trailingslashit($uploads_dir) . $_FILES['file']['name'];
                $status = move_uploaded_file($source, $destination);

// create log file
                if ($status) {
// clear file from bom character
                    $content = file_get_contents($destination);
                    file_put_contents($destination, str_replace("\xEF\xBB\xBF", '', $content));

                    $log_id = $this->gfei_insert_import_log($_FILES['file']['name']);
                    $url = $destination;
                } else {
                    $message = __('Error while uploading file', 'gf_entries_import');
                }
            }

            print_r(json_encode(array('status' => $status, 'message' => $message, 'url' => $url, 'log_id' => $log_id)));

            wp_die(); // this is required to terminate immediately and return a proper response
        }

        public function gfei_get_form_fields_callback() {
            $status = true;
            $html = '';
            $form_id = intval($_POST['form']);
            $log_id = intval($_POST['log']);
            $url = $_POST['url'];

            $header = $this->gfei_get_csv_header($log_id, $url);
            $fields = $this->gfei_get_all_form_fields($form_id);

            /* $form = RGFormsModel::get_form_meta($form_id);
              echo "<pre>";
              print_r($header);
              echo "</pre>";
              echo '=======';
              echo "<pre>";
              print_r($form["fields"]);
              echo "</pre>";
              echo '=======';
              echo "<pre>";
              print_r($fields);
              echo "</pre>";exit; */

            $myopts = get_option('gfei_template_options');
            if ($myopts) {
                $empty_option = '<option value="">' . __('Select template', 'gf_entries_import') . '</option>';
                foreach ($myopts as $k => $myopt) {
                    if ($form_id == $myopt['form']) {
                        $valid = true;
                        $template_options .= '<option value=' . $k . '>' . $myopt['template_name'] . '</option>';
                    }
                }
                if ($valid) {
                    $html .= '<a id="gfie_remove_template" href="#" style="color:red; text-decoration:none;">X </a>&nbsp;';
                    $html .= '<select name="gfei_template_name" id="gfei_select_template">';
                    $html .= $empty_option . $template_options;
                    $html .= '</select>';
                    $html .= '<button id="gfei_load_template" type="button" class="button button-primary">' . __('Load template', 'gf_entries_import') . '</button>';
                }
            }

            $unique_options = '';
            $csv_options = '';
            $empty_option = '<option value="">' . __('Select field', 'gf_entries_import') . '</option>' . '<option value="dont_import">' . __('Dont Import', 'gf_entries_import') . '</option>';
            $count = 1;
            foreach ($header as $csv_field) {
                $letter = $this->gfei_column_letter($count);
                $csv_options .= '<option value="';
                if (!in_array($csv_field, $this->gfei_get_entry_info_columns())) {
                    $csv_options .= $letter . '%%';
                }
                $csv_fields[] = $csv_field;
                $csv_options .= $csv_field . '">' . $letter . ') ' . $csv_field . '</option>';
                $unique_options .= '<option value="' . $letter . '%%' . $csv_field . '">' . $csv_field . '</option>';
                $count++;
            }
            $html .= '<table class="form-table"><div class="error-message"></div><thead><tr><th>' . __('Form Field', 'gf_entries_import') . '</th><th>' . __('CSV Field Map', 'gf_entries_import') . '</th></tr></thead><tbody>';
            foreach ($fields as $field) {
                if ($field['type'] == 'list' && $field['multi']) {
                    $html .= '<tr><td>' . $field['name'] . '</td><td><select name="mapping[' . $field['name'] . '][]" id="' . $field['name'] . '" data-index="' . $field['name'] . '" multiple>' . $csv_options . '</select></td></tr>';
                } elseif (($field['type'] == 'poll' && $field['poll_type'] == 'checkbox') || ($field['type'] == 'quiz' && $field['quiz_type'] == 'checkbox') || ($field['type'] == 'option' && $field['input_type'] == 'checkbox') || ($field['type'] == 'survey' && $field['input_type'] == 'checkbox') || ($field['type'] == 'survey' && $field['input_type'] == 'likert' && isset($field['multi_rows']) && $field['multi_rows'])) {
                    $html .= '<tr><td>' . $field['parent_name'] . ' (' . $field['name'] . ')</td><td><select name="mapping[' . $field['parent_name'] . ']" id="' . $field['name'] . '" data-index="' . $field['parent_name'] . '" data-key="' . $field['name'] . '">' . $empty_option . $csv_options . '</select></td></tr>';
                } else {
                    $html .= '<tr><td>' . $field['name'] . '</td><td><select name="mapping[' . $field['name'] . ']" id="' . $field['name'] . '" data-index="' . $field['name'] . '">' . $empty_option . $csv_options . '</select></td></tr>';
                }
            }
// add other mapping fields based on type
            if ($this->gfei_is_field_type_exists('quiz', $form_id)) {
                $html .= '<tr><td>' . __('Quiz Score', 'gf_entries_import') . '</td><td><select name="mapping[gquiz_score]" id="gquiz_score" data-index="gquiz_score">' . $empty_option . $csv_options . '</select></td></tr>';
                $html .= '<tr><td>' . __('Quiz Percent', 'gf_entries_import') . '</td><td><select name="mapping[gquiz_percent]" id="gquiz_percent" data-index="gquiz_percent">' . $empty_option . $csv_options . '</select></td></tr>';
                $html .= '<tr><td>' . __('Quiz Grade', 'gf_entries_import') . '</td><td><select name="mapping[gquiz_grade]" id="gquiz_grade" data-index="gquiz_grade">' . $empty_option . $csv_options . '</select></td></tr>';
                $html .= '<tr><td>' . __('Quiz Passed', 'gf_entries_import') . '</td><td><select name="mapping[gquiz_is_pass]" id="gquiz_is_pass" data-index="gquiz_is_pass">' . $empty_option . $csv_options . '</select></td></tr>';
            }
            
            $html = apply_filters( 'gfei_import_display_fields',$html, $csv_options, $empty_option );

            $html .= '</tbody></table>';

            if ($csv_options) {

                $html .= '<div class="item-container"><input type="checkbox" name="update_entry" id="update_entry" value="1"><label for="update_entry">' . __('Updated Entries', 'gf_entries_import') . '</label></div>';
              //  $html .= '<div class="item-container"><label for="unique_key">' . __('Unique Key', 'gf_entries_import') . '</label><select name="unique_key" id="unique_key">' . $csv_options . '</select></div>';
                $html .= '<div class="item-container"><input type="hidden" name="unique_key" id="unique_key" value="Entry Id"></div>';
            }

            $html .= '<div class="item-container"><input type="checkbox" name="conditional_import" id="conditional_import" value="1">'
                    . '<label for="conditional_import">' . __('Conditional Import', 'gf_entries_import') . '</label></div>';
            $c = 1;
            foreach ($fields as $k => $field):
                $letter = $this->gfei_column_letter($c);
                $field_options .= '<option value="';
                $field_options .= $field['name'] . '"> ' . $field['name'] . '</option>';
                $c++;
            endforeach;

            $html .= '<div id="condition_mode" style="display:none">';

            $html .= 'Import entries if ';
            $html .= '<select name="condition_mode">';
            $html .= '<option value="all"> ' . __('All', 'gf_entries_import') . '</option>';
            $html .= '<option value="any"> ' . __('Any', 'gf_entries_import') . '</option>';
            $html .= '</select>';
            $html .= 'of the following match:';
            $html .= '<br/>';
            $html .= '</div>';

            $html .= '<div id="condition_import" class="condition_import" style="display:none">';
            $html .= '<select name="condition_field[]">';
            $html .= $empty_option . $field_options;
            $html .= '</select>';
            $html .= '<select name="condition_option[]">';
            $html .= '<option value="matches"> ' . __('is', 'gf_entries_import') . '</option>';
            $html .= '<option value="isnt"> ' . __('is not', 'gf_entries_import') . '</option>';
            $html .= '<option value="contains"> ' . __('Contains', 'gf_entries_import') . '</option>';
            $html .= '</select>';

            $html .= '<input type="text" name="condition_value[]" />';
            $html .= '</div>';
            $html .= '<div id="condition_row"></div>';

            $html .= '<div class="add_condition" style="display:none;">';
            $html .= '<a class="add">Add Select</a></div>';

            $html .= '<div class="item-container save-template"><input type="checkbox" name="enable_save" id="enable_save" value="1">'
                    . '<label for="enable_save">' . __('Enable Save Template', 'gf_entries_import') . '</label>';

            $html .= '<div class="save_template" style="display:none;">';

            $html .= '<input type="text" name="template_name" value="">';
            $html .= '<button id="gfei_save" class="button button-primary" type="button">' . __('Save', 'gf_entries_import') . '</button>';
            $html .= '</div>';
            $html .= '</div>';
            $html .= '<div class="save-template-message"></div>';

            $html .= '<div class="item-container ignore-template"><input type="checkbox" name="ignore_required" id="ignore_required" value="1">'
                    . '<label for="ignore_required">' . __('Ignore Required Fields', 'gf_entries_import') . '</label></div>';

            $html .= '<div class="item-container email-template"><input type="checkbox" name="email_notifications" id="email_notifications" value="1">'
                    . '<label for="email_notifications">' . __('Email Notifications', 'gf_entries_import') . '</label><br/>';
            $html .= '</div>';


            $html .= '<input type="hidden" class="gfei_csv_file" name="csv_file" value="' . $url . '">';
            $html .= '<input type="hidden" class="gfei_import_log" name="import_log" value="' . $log_id . '">';
            $html .= '<button id="gfei_import" class="button button-primary" type="button">' . __('Import', 'gf_entries_import') . '</button>';

            $html .= '<div id="progressbar"></div>';
            $html .= '</div>';
//$html .= '';

            print_r(json_encode(array('status' => $status, 'html' => $html)));



            wp_die(); // this is required to terminate immediately and return a proper response
        }

        public function gfei_import_csv_callback() {
            ini_set('memory_limit', '-1');
            ini_set('max_execution_time', 0);

            global $wpdb;
            $table_name = $wpdb->prefix . 'gfei_import_log';
            $status = true;
            $form_id = intval($_POST['form']);
            $mapping_arr = $_POST['mapping']; //json_decode(stripslashes($_POST['mapping']), true);
            $url = $_POST['url'];
            $unique_key = $_POST['unique_key'];
            $update = intval($_POST['update']);
            $log = intval($_POST['log']);
            $offset = intval($_POST['offset']);
            $ignore = intval($_POST['ignore_required']);
            $email_notification = intval($_POST['email_notifications']);
            $no_of_rows = get_option('gfei_rows_per_import', 100);
            $per_ajax = $no_of_rows - 1;
            $end_ajax = $offset + $per_ajax;
            $log_file = '';
            $log_file_url = '';
            $condition = array();
            $log_list = $_POST['log_list'];
            $count = $_POST['count_success'];
            $error = $_POST['count_error'];

            if ($_POST['empty'] == 'true') {
                $message = __('Please fill missing csv field map', 'gf_entries_import');
                print_r(json_encode(array('message' => $message)));
                wp_die();
            }

            if ($_POST['conditional_import'] == 1) {
                $condition_mode = $_POST['condition'];
                $condition_fields = $_POST['conditional_field'];
                $options = $_POST['conditional_match'];
                $vals = $_POST['conditional_value'];
                foreach ($condition_fields as $k => $condition_field) {
                    if ($condition_field !== '') {
                        $condition[$k]['conditional'] = $mapping_arr[$condition_field];
                        $condition[$k]['option'] = $options[$k];
                        $condition[$k]['val'] = $vals[$k];
                    }
                }
            }
// prepare mapping
            $mapping = array();
            foreach ($mapping_arr as $form_field => $selected_header) {
//                if ($selected_header != 'dont_import') {
                if (strpos($form_field, '##') !== false) {
                    $indexes = explode('##', $form_field);
                    $mapping[$indexes[0]][$indexes[1]] = $selected_header;
                } else {
                    $mapping[$form_field] = $selected_header;
                }
//                }
            }
            $fields_info = $this->gfei_get_form_fields_type($form_id);

            $records = $this->gfei_csv_to_array($url, null, get_option('gfei_delimiter', ','));

            $chunk = array_slice($records, $offset - 1, $no_of_rows, true);


// make log file ready
            $handle = false;
            $file_name = $wpdb->get_var($wpdb->prepare("SELECT log_file_name FROM $table_name WHERE id = %d", $log));
            if ($file_name) {
                $logs_dir = ABSPATH . 'wp-content/uploads/gf_import_files/logs';
                wp_mkdir_p($logs_dir);

                $log_file = trailingslashit($logs_dir) . $file_name . '.html';
                $handle = fopen($log_file, 'a');
            }

            if ($condition) {
                $match = $this->gfei_conditional_import($condition_mode, $condition, $chunk);
            } else {
                $match = array();
                foreach ($chunk as $k => $single) {
                    $match[$k] = 'true';
                }
            }
            $validation = $this->gfei_validation($form_id, $chunk, $mapping, $ignore);
            $csvs_dir = ABSPATH . 'wp-content/uploads/gf_import_files/csvs';
            $csv_file = trailingslashit($csvs_dir) . $file_name . '.csv';
            $fh = fopen($csv_file, 'w') or die('Cannot open the file');
            $entry = array();
            $email = array();
            $condition_issue = array();
            $responses = array();
            $error_records = $_POST['record'] ? $_POST['record'] : array();
//            $error = 0;
            fputcsv($fh, $this->gfei_get_csv_header($log, $url)); # $line is an array of string values here
//            echo '<pre>';

            foreach ($chunk as $k => $single) {
//sleep(1);
//                usleep(1000 * 1000);
                if (empty($validation[$k]) && $match[$k] == 'true') {
                    $responses[$k] = $this->gfei_insert_entry($form_id, $single, $mapping, $fields_info, $update, $unique_key, $email_notification, $ignore);
                    $entry[$k] = 'true';
                    $condition_issue[$k] = 'false';
                    $email[] = $single;
                } elseif ($validation[$k]) {
                    $import = 'false';
                    $entry[$k] = 'false';
                    $condition_issue[$k] = 'false';
                    $log_message .= '<li class="gfei-error">' . __('Error while importing entry because ' . $validation[$k]['valid'], 'gf_entries_import') . '</li>';
                    $log_list .= $log_message;
//                    // add to log file
                    $error_records[] = $single;
                    $error++;
                    fwrite($handle, $log_message . PHP_EOL);
                } elseif ($match[$k] == 'false') {
                    $entry[$k] = 'false';
                    $condition_issue[$k] = 'true';
                }
            }
            $total = count($records);

            foreach ($error_records as $error_record) {
                fputcsv($fh, $error_record); # $line is an array of string values here
            }

            foreach ($responses as $response) {
                if (!empty($response['entry_id']) || $response['class'] != "error") {
                    $log_message .= '<li class="gfei-' . $response['class'] . '">' . $response['message'] . '</li>';
                    $log_list .= $log_message;
                    $count++;
                    fwrite($handle, $log_message . PHP_EOL);
                } else {
                    $error++;
                    $message = '';
                    if ($response['message'] != '') {
                        $message = '(' . $response['message'] . ')';
                    }
                    $log_message .= '<li class="gfei-error">' . __("Error while importing entry $message", 'gf_entries_import') . '</li>';
                    $log_list .= $log_message;
                    if ($handle) {
                        fwrite($handle, $log_message . PHP_EOL);
                    }
                }
            }

            fclose($fh);

            if ($import == "false") {
                $upload_dir = wp_upload_dir();
                if ($upload_dir['error'] === false) {
                    $csv_url = $upload_dir['baseurl'] . '/gf_import_files/csvs/' . $file_name . '.csv';
                }
            } else {
                $csv_url = '';
            }

//sleep(1);
            if (count($records) > $end_ajax) {
                $status = true;
                $offset = $end_ajax + 1;
            } else {
// update log
                $wpdb->update(
                        $table_name, array(
                    'status' => 'completed',
                    'updated_at' => current_time('mysql')
                        ), array('id' => $log), array(
                    '%s',
                    '%s'
                        ), array('%d')
                );

                $status = false;
                $offset = 0;

                if (in_array('true', $entry)) {
                    if ($handle) {
                        $nothing_import = 'false';
                        if ($error == 0) {
                            fwrite($handle, '<li class="gfei-add">' . __("Your file has $count records imported successfully", 'gf_entries_import') . '</li>');
                        } else {
                            fwrite($handle, '<li class="gfei-add">' . __("Your file has $count records imported successfully and $error rejected", 'gf_entries_import') . '</li>');
                        }
                    }
                } else {
                    if (in_array('false', $condition_issue)) {
                        $nothing_import = 'true';
                        fwrite($handle, '<li class="gfei-error">' . __("Your file contains $error errors nothing to import", 'gf_entries_import') . '</li>');
                    } else {
                        $nothing_import = 'condition';
                        fwrite($handle, '<li class="gfei-add">' . __('Your file doesnt match condition import', 'gf_entries_import') . '</li>');
                    }
                }
            }

            if ($handle) {
                fclose($handle);
                $upload_dir = wp_upload_dir();
                if ($upload_dir['error'] === false) {
                    $log_file_url = $upload_dir['baseurl'] . '/gf_import_files/logs/' . $file_name . '.html';
                }
            }

            print_r(json_encode(array('status' => $status, 'offset' => $offset, 'log_list' => $log_message, 'log_file' => $log_file_url, 'csv_url' => $csv_url, 'import' => $nothing_import, 'count_success' => $count, 'total' => $total, 'count_error' => $error, 'record' => $error_records)));

            wp_die(); // this is required to terminate immediately and return a proper response
        }

        public function gfei_conditional_import($condition_mode, $condition, $chunk) {
            $match = array();
            if ($condition_mode == 'all') {
                foreach ($condition as $value) {
                    foreach ($chunk as $k => $single) {
                        if ($value['option'] == 'matches') {
                            if (strpos($single[$value['conditional']], $value['val']) === 0) {
                                if ($match[$k] == 'false') {
                                    $match[$k] = 'false';
                                } else {
                                    $match[$k] = 'true';
                                }
                            } else {
                                if ($match[$k] == 'true') {
                                    $match[$k] = 'false';
                                } else {
                                    $match[$k] = 'false';
                                }
                            }
                        }

                        if ($value['option'] == 'contains') {
                            if (stripos($single[$value['conditional']], $value['val']) === 0 || stripos($single[$value['conditional']], $value['val']) > 0) {
                                if ($match[$k] == 'false') {
                                    $match[$k] = 'false';
                                } else {
                                    $match[$k] = 'true';
                                }
                            } else {
                                if ($match[$k] == 'true') {
                                    $match[$k] = 'false';
                                } else {
                                    $match[$k] = 'false';
                                }
                            }
                        }
                        if ($value['option'] == 'isnt') {
                            if (strpos($single[$value['conditional']], $value['val']) === 0) {
                                if ($match[$k] == 'true') {
                                    $match[$k] = 'false';
                                } else {
                                    $match[$k] = 'false';
                                }
                            } else {
                                if ($match[$k] == 'false') {
                                    $match[$k] = 'false';
                                } else {
                                    $match[$k] = 'true';
                                }
                            }
                        }
                    }
                }
            } elseif ($condition_mode == 'any') {
                foreach ($condition as $value) {
                    foreach ($chunk as $k => $single) {
                        if ($value['option'] == 'matches') {
                            if (strpos($single[$value['conditional']], $value['val']) === 0) {
                                $match[$k] = 'true';
                            } else {
                                if ($match[$k] == 'true') {
                                    $match[$k] = 'true';
                                } else {
                                    $match[$k] = 'false';
                                }
                            }
                        }
                        if ($value['option'] == 'contains') {
                            if (stripos($single[$value['conditional']], $value['val']) === 0 || stripos($single[$value['conditional']], $value['val']) > 0) {
                                $match[$k] = 'true';
                            } else {
                                if ($match[$k] == 'true') {
                                    $match[$k] = 'true';
                                } else {
                                    $match[$k] = 'false';
                                }
                            }
                        }
                        if ($value['option'] == 'isnt') {
                            if (strpos($single[$value['conditional']], $value['val']) === 0) {
                                if ($match[$k] == 'true') {
                                    $match[$k] = 'true';
                                } else {
                                    $match[$k] = 'false';
                                }
                            } else {
                                $match[$k] = 'true';
                            }
                        }
                    }
                }
            }
            return $match;
        }

        private function gfei_validation($form_id, $chunk, $mapping, $ignore) {
            $form = RGFormsModel::get_form_meta($form_id);
            $validation = array();
            foreach ($chunk as $k => $single) {
                foreach ($form['fields'] as $field) {
                    $max_length = absint($field->maxLength);
                    foreach ($mapping as $c => $map) {
                        if ($field->label == $c) {
                            if ($max_length > 0) {
                                if (strlen($single[$map]) > $max_length) {
                                    $validation[$k]['skip'] = true;
                                    $validation[$k]['valid'] = 'max';
                                }
                            }
                            if ($map != 'dont_import') {
                                if ($ignore == 0) {
                                    if ($field->isRequired) {
                                        $str = trim($single[$map]);
                                        if (empty($str)) {
                                            $validation[$k]['skip'] = true;
                                            $validation[$k]['valid'] = 'required';
                                            $validation[$k]['field'] = $field->label;
                                        }
                                    }
                                }
                            }
                            if ($field->noDuplicates && RGFormsModel::is_duplicate($form_id, $field, $single[$map])) {
                                $validation[$k]['skip'] = true;
                                $validation[$k]['valid'] = 'duplicated';
                            }
                        }
                    }
                }
            }

            return $validation;
        }

        private function gfei_get_csv_header($logId, $filepath) {
            ini_set('auto_detect_line_endings', TRUE);
            global $wpdb;
            $header = array();
            if ($logId) {
                $uploads_dir = ABSPATH . 'wp-content/uploads/gf_import_files/csvs';
                $table_name = $wpdb->prefix . 'gfei_import_log';
                $file_name = $wpdb->get_var($wpdb->prepare("SELECT file_name FROM $table_name WHERE id = %d", $logId));
                if (file_exists(trailingslashit($uploads_dir) . $file_name)) {
                    $path = trailingslashit($uploads_dir) . $file_name;
                } else {
                    $path = $filepath;
                }
            } else {
                $path = $filepath;
            }

            if (($handle = fopen($path, 'r')) !== FALSE) {
                while (($row = fgetcsv($handle, 0, get_option('gfei_delimiter', ','))) !== FALSE && count($header) == 0) {
                    $header = $row;
                }
                fclose($handle);
            }

            ini_set('auto_detect_line_endings', FALSE);

            return $header;
        }

        private function gfei_csv_to_array($filename, $header = null, $delimiter = ',') {
            ini_set('auto_detect_line_endings', TRUE);
            if (!file_exists($filename) || !is_readable($filename))
                return FALSE;

            $data = array();
            if (($handle = fopen($filename, 'r')) !== FALSE) {
                while (($row = fgetcsv($handle, 0, $delimiter)) !== FALSE) {
                    if (!$header) {
                        $header = $this->make_header_value_unique($row);
                    } else {
                        $data[] = array_combine($header, $row);
                    }
                }
                fclose($handle);
            }
            ini_set('auto_detect_line_endings', FALSE);
            return $data;
        }

        private function make_header_value_unique($header) {
            $newHeader = array();

            $count = 1;
            foreach ($header as $csv_field) {
                $letter = $this->gfei_column_letter($count);
                if (!in_array($csv_field, $this->gfei_get_entry_info_columns())) {
                    $newHeader[] = $letter . '%%' . $csv_field;
                } else {
                    $newHeader[] = $csv_field;
                }
                $count++;
            }

            return $newHeader;
        }

        private function gfei_get_all_form_fields($form_id) {
            $form = RGFormsModel::get_form_meta($form_id);
            $fields = array();

            if (is_array($form["fields"])) {
                foreach ($form["fields"] as $field) {
                    if (isset($field["type"]) && $field["type"] == 'fileupload') {
                        $file_arr = array(
                            'id' => $field["id"],
                            'name' => GFCommon::get_label($field),
                            'type' => $field["type"],
                            'multi' => 0
                        );

                        if (isset($field["multipleFiles"]) && $field["multipleFiles"]) {
                            $file_arr['multi'] = 1;
                        }

                        $fields[] = $file_arr;
                    } elseif (isset($field["type"]) && $field["type"] == 'list') {
                        $multi = 0;
                        if (isset($field["enableColumns"]) && $field["enableColumns"]) {
                            $multi = 1;
                        }
                        $fields[] = array(
                            'id' => $field["id"],
                            'name' => GFCommon::get_label($field),
                            'type' => $field["type"],
                            'multi' => $multi
                        );
                    } elseif (isset($field["type"]) && in_array($field["type"], ['date', 'time'])) {
                        $fields[] = array(
                            'id' => $field["id"],
                            'name' => GFCommon::get_label($field),
                            'type' => $field["type"]
                        );
                    } elseif (isset($field["inputs"]) && is_array($field["inputs"])) {

                        foreach ($field["inputs"] as $input) {
                            $input_arr = array(
                                'id' => $input["id"],
                                'name' => GFCommon::get_label($field, $input["id"]),
                                'type' => $field["type"]
                            );
                            if (isset($field["type"]) && $field["type"] == 'poll' && $field["poll_field_type"] == 'checkbox') {
                                $input_arr['parent_name'] = GFCommon::get_label($field);
                                $input_arr['poll_type'] = $field["poll_field_type"];
                            }

                            if (isset($field["type"]) && $field["type"] == 'quiz' && $field["gquizFieldType"] == 'checkbox') {
                                $input_arr['parent_name'] = GFCommon::get_label($field);
                                $input_arr['quiz_type'] = $field["gquizFieldType"];
                            }

                            if (isset($field["type"]) && $field["type"] == 'option' && $field["inputType"] == 'checkbox') {
                                $input_arr['parent_name'] = GFCommon::get_label($field);
                                $input_arr['input_type'] = $field["inputType"];
                            }

                            if (isset($field["type"]) && $field["type"] == 'survey' && $field["inputType"] == 'checkbox') {
                                $input_arr['parent_name'] = GFCommon::get_label($field);
                                $input_arr['input_type'] = $field["inputType"];
                            }

                            if (isset($field["type"]) && $field["type"] == 'survey' && $field["inputType"] == 'likert' && $field["gsurveyLikertEnableMultipleRows"]) {
                                $input_arr['parent_name'] = GFCommon::get_label($field);
                                $input_arr['name'] = $input["label"];
                                $input_arr['input_type'] = $field["inputType"];
                                $input_arr['multi_rows'] = $field["gsurveyLikertEnableMultipleRows"];
                            }

                            $fields[] = $input_arr;
                        }
                    } else if (!rgar($field, 'displayOnly')) {
                        $field_arr = array(
                            'id' => $field["id"],
                            'name' => GFCommon::get_label($field),
                            'type' => $field["type"]
                        );

                        if (isset($field["type"]) && $field["type"] == 'quiz' && isset($field["gquizFieldType"])) {
                            $field_arr['quiz_type'] = $field["gquizFieldType"];
                        }

                        $fields[] = $field_arr;
                    }
                }
            }

            return $fields;
        }

        private function gfei_get_form_fields_type($form_id) {
            $form = RGFormsModel::get_form_meta($form_id);
            $fields = array();

            if (is_array($form["fields"])) {
                foreach ($form["fields"] as $field) {
                    if (isset($field["type"]) && $field["type"] == 'survey') {
                        $choices = array();
                        if (isset($field["choices"]) && is_array($field["choices"])) {
                            foreach ($field["choices"] as $choice) {
                                $choices[$choice['text']] = $choice['value'];
                            }
                        }
                        $rows = array();
                        if (isset($field["gsurveyLikertRows"]) && is_array($field["gsurveyLikertRows"])) {
                            foreach ($field["gsurveyLikertRows"] as $row) {
                                $rows[$row['text']] = $row['value'];
                            }
                        }
                        $inputs = array();
                        if (isset($field["inputType"]) && $field["inputType"] == 'checkbox') {
                            foreach ($field["inputs"] as $input) {
                                $inputs[GFCommon::get_label($field, $input["id"])] = $input["id"];
                            }
                        } elseif (isset($field["gsurveyLikertEnableMultipleRows"]) && $field["gsurveyLikertEnableMultipleRows"]) {
                            foreach ($field["inputs"] as $input) {
                                $inputs[$input["label"]] = $input["id"];
                            }
                        }
                        $fields[GFCommon::get_label($field)] = array(
                            'id' => $field["id"],
                            'type' => $field["type"],
                            'inputType' => isset($field["inputType"]) ? $field["inputType"] : '',
                            'multi_rows' => isset($field["gsurveyLikertEnableMultipleRows"]) && $field["gsurveyLikertEnableMultipleRows"] ? $field["gsurveyLikertEnableMultipleRows"] : '',
                            'choices' => $choices,
                            'inputs' => $inputs,
                            'rows' => $rows
                        );
                    } elseif (isset($field["type"]) && $field["type"] == 'poll') {
                        $choices = array();
                        if (isset($field["choices"]) && is_array($field["choices"])) {
                            foreach ($field["choices"] as $choice) {
                                $choices[$choice['text']] = $choice['value'];
                            }
                        }
                        $inputs = array();
                        if ($field['poll_field_type'] == 'checkbox') {
                            foreach ($field["inputs"] as $input) {
                                $inputs[GFCommon::get_label($field, $input["id"])] = $input["id"];
                            }
                        }
                        $fields[GFCommon::get_label($field)] = array(
                            'id' => $field["id"],
                            'type' => $field["type"],
                            'choices' => $choices,
                            'inputs' => $inputs
                        );
                    } elseif (isset($field["type"]) && $field["type"] == 'quiz') {
                        $choices = array();
                        if (isset($field["choices"]) && is_array($field["choices"])) {
                            foreach ($field["choices"] as $choice) {
                                $choices[$choice['text']] = $choice['value'];
                            }
                        }
                        $inputs = array();
                        if ($field['gquizFieldType'] == 'checkbox') {
                            foreach ($field["inputs"] as $input) {
                                $inputs[GFCommon::get_label($field, $input["id"])] = $input["id"];
                            }
                        }
                        $fields[GFCommon::get_label($field)] = array(
                            'id' => $field["id"],
                            'type' => $field["type"],
                            'choices' => $choices,
                            'inputs' => $inputs
                        );
                    } elseif (isset($field["type"]) && $field["type"] == 'option' && $field['inputType'] == 'checkbox') {
                        $currency_arr = RGCurrency::get_currency(GFCommon::get_currency());
                        $choices = array();
                        $prices = array();
                        if (isset($field["choices"]) && is_array($field["choices"])) {
                            foreach ($field["choices"] as $choice) {
                                $choices[$choice['text']] = $choice['value'];
                                $price = str_replace($currency_arr['symbol_left'], '', $choice['price']);
                                $price_num = strpos($price, $currency_arr['decimal_separator']) === false ? intval($price) : floatval($price);
                                $prices[$choice['text']] = $this->gfei_format_price($price_num);
                            }
                        }
                        $inputs = array();
                        foreach ($field["inputs"] as $input) {
                            $inputs[GFCommon::get_label($field, $input["id"])] = $input["id"];
                        }

                        $fields[GFCommon::get_label($field)] = array(
                            'id' => $field["id"],
                            'type' => $field["type"],
                            'input_type' => $field['inputType'],
                            'choices' => $choices,
                            'inputs' => $inputs,
                            'prices' => $prices
                        );
                    } elseif (isset($field["type"]) && $field["type"] == 'list') {
                        $multi = 0;
                        $choices = array();
                        if (isset($field["enableColumns"]) && $field["enableColumns"]) {
                            $multi = 1;
                            if (isset($field["choices"]) && is_array($field["choices"])) {
                                foreach ($field["choices"] as $choice) {
                                    $choices[$choice['text']] = $choice['value'];
                                }
                            }
                        }
                        $fields[GFCommon::get_label($field)] = array(
                            'id' => $field["id"],
                            'type' => $field["type"],
                            'multi' => $multi,
                            'choices' => $choices
                        );
                    } elseif (isset($field["type"]) && $field["type"] == 'fileupload') {
                        $file_arr = array(
                            'id' => $field["id"],
                            'type' => $field["type"],
                            'multi' => 0
                        );

                        if (isset($field["multipleFiles"]) && $field["multipleFiles"]) {
                            $file_arr['multi'] = 1;
                        }

                        $fields[GFCommon::get_label($field)] = $file_arr;
                    } elseif (isset($field["type"]) && in_array($field["type"], ['date', 'time'])) {
                        $fields[GFCommon::get_label($field)] = array(
                            'id' => $field["id"],
                            'type' => $field["type"]
                        );
                    } elseif (isset($field["inputs"]) && is_array($field["inputs"])) {

                        foreach ($field["inputs"] as $input) {
                            $fields[GFCommon::get_label($field, $input["id"])] = array(
                                'id' => $input["id"],
                                'type' => $field["type"],
                                'required' => $field["isRequired"],
                                'duplicate' => $field["noDuplicates"]
                            );
                        }
                    } elseif (!rgar($field, 'displayOnly')) {
                        $fields[GFCommon::get_label($field)] = array(
                            'id' => $field["id"],
                            'type' => $field["type"],
                            'required' => $field["isRequired"],
                            'duplicate' => $field["noDuplicates"]
                        );
                    }
                }
            }

            return $fields;
        }

        private function gfei_get_form_field_id($form_id, $field_name) {
            $form = RGFormsModel::get_form_meta($form_id);
            $id = 0;

            if (is_array($form["fields"])) {
                foreach ($form["fields"] as $field) {
                    if (isset($field["type"]) && in_array($field["type"], ['date', 'time']) && GFCommon::get_label($field) == $field_name) {
                        $id = $field["id"];
                    } elseif (isset($field["inputs"]) && is_array($field["inputs"])) {

                        foreach ($field["inputs"] as $input) {
                            if (GFCommon::get_label($field, $input["id"]) == $field_name) {
                                $id = $input["id"];
                            }
                        }
                    } else if (!rgar($field, 'displayOnly')) {
                        if (GFCommon::get_label($field) == $field_name) {
                            $id = $field["id"];
                        }
                    }
                }
            }

            return $id;
        }

        private function gfei_insert_import_log($file_name) {
            global $wpdb;
            $id_inserted = false;
            $unique_log_file = uniqid('log_');

            $table_name = $wpdb->prefix . 'gfei_import_log';

            $check = $wpdb->insert(
                    $table_name, array(
                'file_name' => $file_name,
                'log_file_name' => $unique_log_file,
                'status' => 'draft',
                'created_at' => current_time('mysql'),
                'updated_at' => current_time('mysql'),
                    )
            );

            if ($check) {
                $id_inserted = $wpdb->insert_id;
            }

            return $id_inserted;
        }

        private function gfei_insert_entry($form_id, $row, $mapping, $fields_info, $update, $unique_key, $email_notification, $ignore) {
            $response = array('entry_id' => null, 'message' => null, 'class' => null);
            $message = array();
            $entry = array();
            $form = RGFormsModel::get_form_meta($form_id);
            $signatures = array();
            $signatures_check = true;
            $feed = true;
            $calculation = array();
// create entry array
            $entry['form_id'] = $form_id;
            if (isset($row['Entry Status']) && $row['Entry Status']) {
                $entry['status'] = $row['Entry Status'];
            } else {
                $entry['status'] = 'active';
            }
            if (isset($row['Starred Entry']) && $row['Starred Entry']) {
                $entry['is_starred'] = $row['Starred Entry'];
            }
            if (isset($row['Read Entry']) && $row['Read Entry']) {
                $entry['is_read'] = $row['Read Entry'];
            }
            if (isset($row['Entry Date']) && $row['Entry Date']) {
                $current_timezone = get_option('timezone_string');
                $utc_time = date('Y-m-d H:i:s',strtotime($row['Entry Date']. $current_timezone));
                $entry['date_created'] = $utc_time;
            } else {
                $current_timezone = get_option('timezone_string');
                $utc_time = date('Y-m-d H:i:s',strtotime($row['Entry Date']. $current_timezone));
                $entry['date_created'] = $utc_time;
            }
            if (isset($row['Created By (User Id)']) && $row['Created By (User Id)']) {
                $entry['created_by'] = $row['Created By (User Id)'];
            } else {
                $entry['created_by'] = get_current_user_id();
            }
            if (isset($row['Source Url']) && $row['Source Url']) {
                $entry['source_url'] = $row['Source Url'];
            }
            if (isset($row['User Agent']) && $row['User Agent']) {
                $entry['user_agent'] = $row['User Agent'];
            }
            if (isset($row['User IP']) && $row['User IP']) {
                $entry['ip'] = $row['User IP'];
            }
// payments fields
            if (isset($row['Currency']) && $row['Currency']) {
                $entry['currency'] = $row['Currency'];
            } else {
                $entry['currency'] = 'USD';
            }
            if (isset($row['Payment Status']) && $row['Payment Status']) {
                $entry['payment_status'] = $row['Payment Status'];
            } else {
                $entry['payment_status'] = null;
            }
            if (isset($row['Payment Date']) && $row['Payment Date']) {
                $entry['payment_date'] = $row['Payment Date'];
            } else {
                $entry['payment_date'] = null;
            }
            if (isset($row['Transaction Id']) && $row['Transaction Id']) {
                $entry['transaction_id'] = $row['Transaction Id'];
            } else {
                $entry['transaction_id'] = null;
            }
            if (isset($row['Payment Amount']) && $row['Payment Amount']) {
                $entry['payment_amount'] = $row['Payment Amount'];
            } else {
                $entry['payment_amount'] = null;
            }
            if (isset($row['Payment Method']) && $row['Payment Method']) {
                $entry['payment_method'] = $row['Payment Method'];
            } else {
                $entry['payment_method'] = null;
            }
            if (isset($row['Is Fulfilled']) && $row['Is Fulfilled']) {
                $entry['is_fulfilled'] = $row['Is Fulfilled'];
            } else {
                $entry['is_fulfilled'] = null;
            }
            if (isset($row['Transaction Type']) && $row['Transaction Type']) {
                $entry['transaction_type'] = $row['Transaction Type'];
            } else {
                $entry['transaction_type'] = null;
            }

            $entry = apply_filters( 'gfei_insert_entry_meta_fields',$entry, $row, $mapping );

            foreach ($mapping as $form_field => $selected_header) {
                if ($selected_header && is_array($selected_header)) {
                    if ($fields_info[$form_field]['type'] == 'survey' && isset($fields_info[$form_field]['multi_rows']) && $fields_info[$form_field]['multi_rows']) {
                        $rows = $fields_info[$form_field]['rows'];
                        $choices = $fields_info[$form_field]['choices'];
                        $inputs = $fields_info[$form_field]['inputs'];
                        $check = true;
                        foreach ($selected_header as $key => $sub) {
                            if ($row[$sub] && isset($rows[$key]) && isset($choices[$row[$sub]])) {
                                $entry[$inputs[$key]] = $rows[$key] . ':' . $choices[$row[$sub]];
                            }else{
                                $check = false;
                                break;
                            }
                        }
                        if(!$check){
                            $feed = false;
                            $message[] = __('survey value is invalid', 'gf_entries_import');
                            $class = 'error';
                        }
                    } elseif (($fields_info[$form_field]['type'] == 'poll') || ($fields_info[$form_field]['type'] == 'quiz')) {
                        $check = true;
                        $type = $fields_info[$form_field]['type'];
                        foreach ($selected_header as $key => $sub) {
                            $id = $fields_info[$form_field]['inputs'][$row[$sub]];
                            $choices = $fields_info[$form_field]['choices'];
                            if (isset($choices[$row[$sub]]) && $choices[$row[$sub]]) {
                                $entry[$id] = $choices[$row[$sub]];
                            }elseif(isset($row[$sub]) && $row[$sub] && $sub != 'dont_import'){
                                $check = false;
                                $message[] = $form_field.' ('.$key.')'.' '.__('value is invalid', 'gf_entries_import');
                            }
                        }
                        if(!$check){
                            $feed = false;
                            //$message .= $messages;
                            $class = 'error';
                        }
                    }elseif ($fields_info[$form_field]['type'] == 'survey') {
                        $check = true;
                        $type = $fields_info[$form_field]['type'];
                        foreach ($selected_header as $key => $sub) {
                            $id = $fields_info[$form_field]['inputs'][$row[$sub]];
                            $choices = $fields_info[$form_field]['choices'];
                            if (isset($choices[$row[$sub]]) && $choices[$row[$sub]]) {
                                $entry[$id] = $choices[$row[$sub]];
                            }else{
                                $check = false;
                                break;
                            }
                        }
                        if(!$check){
                            $feed = false;
                            $message[] = $type.' '.__('value is invalid', 'gf_entries_import');
                            $class = 'error';
                        }
                    } elseif ($fields_info[$form_field]['type'] == 'option' && isset($fields_info[$form_field]['input_type'])) {
                        foreach ($selected_header as $key => $sub) {
                            $id = $fields_info[$form_field]['inputs'][$row[$sub]];
                            $choices = $fields_info[$form_field]['choices'];
                            $prices = $fields_info[$form_field]['prices'];
                            if (isset($choices[$row[$sub]]) && $choices[$row[$sub]]) {
                                $entry[$id] = $choices[$row[$sub]] . '|' . $prices[$row[$sub]];
                            }
                        }
                    } elseif ($fields_info[$form_field]['type'] == 'list') {
                        if (is_array($selected_header) && $fields_info[$form_field]['multi']) {
                            $id = $fields_info[$form_field]['id'];
                            $final_array = array();
                            foreach ($selected_header as $single_list) {
                                $list_arr = explode('|', $row[$single_list]);
                                $final_array[] = array_combine($fields_info[$form_field]['choices'], $list_arr);
                            }
                            $entry[$id] = serialize($final_array);
                        }
                    }
                } elseif ($selected_header && !is_array($selected_header)) {

                    if (isset($fields_info[$form_field])) {
                        $id = $fields_info[$form_field]['id'];
                        if ($fields_info[$form_field]['type'] == 'signature') {
                            if($row[$selected_header]){
                                $signature = $this->gfei_get_url_parameter($row[$selected_header], 'signature');
                                if ($signature) {
                                    $new_signature = $form_id . '_' . $id . '_' . $signature;
                                    $old_signature = $update ? $signature : null;
                                    $result = $this->gfei_upload_signature($row[$selected_header], $new_signature, $old_signature);
                                    if ($result) {
                                        $entry[$id] = $result;
                                        $signatures[] = $result;
                                    } else {
                                        $signatures_check = false;
                                        $message[] = __('signature was not imported', 'gf_entries_import');
                                        $class = 'error';
                                    }
                                } else {
                                    if ($this->gfei_check_image_url($row[$selected_header])) {
                                        $signature = $this->gfei_get_image_name($row[$selected_header]);
                                        $new_signature = $form_id . '_' . $id . '_' . $signature;
                                        $result = $this->gfei_upload_signature($row[$selected_header], $new_signature);
                                        if ($result) {
                                            $entry[$id] = $result;
                                            $signatures[] = $result;
                                        } else {
                                            $signatures_check = false;
                                            $message[] = __('signature was not imported', 'gf_entries_import');
                                            $class = 'error';
                                        }
                                    } else {
                                        $signatures_check = false;
                                        $message[] = __('signature is invalid png url', 'gf_entries_import');
                                        $class = 'error';
                                    }
                                }
                            }
                        } elseif ($fields_info[$form_field]['type'] == 'survey') {
                            if (!in_array($fields_info[$form_field]['inputType'], ['text', 'textarea'])) {
                                $choices = $fields_info[$form_field]['choices'];
                                if ($fields_info[$form_field]['inputType'] == 'rank') {
                                    $rankKeys = array();
                                    $check = true;
                                    $ranks = preg_replace("/ ?\d+\. /", "", $row[$selected_header]);
                                    $rankLabels = explode(',', $ranks);
                                    foreach ($rankLabels as $rankLabel) {
                                        if(isset($choices[$rankLabel])){
                                            $rankKeys[] = $choices[$rankLabel];
                                        }else{
                                            $check = false;
                                            break;
                                        }
                                    }
                                    if($check){
                                        $entry[$id] = implode(',', $rankKeys);
                                    }else{
                                        $feed = false;
                                        $message[] = __('survey value is invalid', 'gf_entries_import');
                                        $class = 'error';
                                    }
                                } else {
                                    if(isset($choices[$row[$selected_header]])){
                                        $entry[$id] = $choices[$row[$selected_header]];
                                    }else{
                                        $feed = false;
                                        $message[] = __('survey value is invalid', 'gf_entries_import');
                                        $class = 'error';
                                    }
                                }
                            } else {
                                if(isset($row[$selected_header])){
                                    $entry[$id] = $row[$selected_header];
                                }else{
                                    $feed = false;
                                    $message[] = __('survey value is invalid', 'gf_entries_import');
                                    $class = 'error';
                                }
                            }
                        } elseif (($fields_info[$form_field]['type'] == 'poll') || ($fields_info[$form_field]['type'] == 'quiz')) {
                            $choices = $fields_info[$form_field]['choices'];
                            $type = $fields_info[$form_field]['type'];
                            if(isset($choices[$row[$selected_header]]) && $choices[$row[$selected_header]]){
                                $entry[$id] = $choices[$row[$selected_header]];
                            }elseif(isset($row[$selected_header]) && $row[$selected_header] && $selected_header != 'dont_import'){
                                $feed = false;
                                $message[] = $form_field.' '.__('value is invalid', 'gf_entries_import');
                                $class = 'error';
                            }
                        } elseif ($fields_info[$form_field]['type'] == 'list') {
                            /* if(is_array($selected_header) && $fields_info[$form_field]['multi']){
                              $final_array = array();
                              foreach($selected_header as $single_list){
                              $list_arr = explode('|', $row[$single_list]);
                              $final_array[] = array_combine($fields_info[$form_field]['choices'], $list_arr);
                              }
                              $entry[$id] = serialize($final_array);
                              }else{ */
                            $list_arr = explode('|', $row[$selected_header]);
                            $entry[$id] = serialize($list_arr);
//}
                        } elseif ($fields_info[$form_field]['type'] == 'fileupload') {
                            if ($fields_info[$form_field]['multi']) {
                                $urls = explode(' , ', $row[$selected_header]);
                                $new_urls = array();
                                foreach ($urls as $url) {
                                    $file_name = $this->gfei_get_filename_from_url($url);
                                    $target = GFFormsModel::get_file_upload_path($form_id, $file_name);
                                    $this->gfei_download_file_from_url($url, $target['path']);

                                    $new_urls[] = json_encode($target['url']);
                                }

                                $entry[$id] = '[' . implode(',', $new_urls) . ']';
                            } else {
                                $file_name = $this->gfei_get_filename_from_url($row[$selected_header]);
                                $target = GFFormsModel::get_file_upload_path($form_id, $file_name);
                                $this->gfei_download_file_from_url($row[$selected_header], $target['path']);

                                $entry[$id] = $target['url'];
                            }
                        } elseif ($fields_info[$form_field]['type'] == 'coupon') {
                            $coupons_explode = explode(",", $row[$selected_header]);
                            if ($coupons_explode) {
                                $coupon_class = new GFCoupons();
                                foreach ($coupons_explode as $coupon_value) {
                                    preg_match('#\((.*?)\)#', $coupon_value, $match);
                                    if ($match[1]) {
                                        $coupons[] = strtok($match[1], ":");
                                    } else {
                                        $coupons[] = $coupon_value;
                                    }
                                }
                                foreach ($coupons as $coupon) {
                                    $feed = $coupon_class->get_config($form, $coupon);
                                    if (!$feed || !$feed['is_active']) {
                                        $feed = false;
                                        $message[] = __('Invalid coupon.', 'gf_entries_import');
                                        $class = 'error';
                                    } else {
                                        $coupons_valid[] = $coupon;
                                    }
                                }
                                if ($coupons_valid) {
                                    $entry[$id] = implode(',', $coupons_valid);
                                } else {
                                    if ($ignore == 1) {
                                        $feed = true;
                                        $entry[$id] = '';
                                    }
                                }
                            }
                        } elseif ($fields_info[$form_field]['type'] == 'total') {
                            $calculation['total_id'] = $id;
                            $entry[$id] = $row[$selected_header];
                        } else {
                            $entry[$id] = $row[$selected_header];
                            if ($selected_header == 'dont_import') {
                                if ($update) {
                                    $entry_id = $this->gfei_get_entry_id($unique_key, $row);
                                    if ($entry_id != 0) {
                                        $old_entry = GFAPI::get_entry($entry_id);
                                        $entry[$id] = $old_entry[$id];
                                    }
                                }
                            }
                        }
                    } else {
                        if ($form_field == 'gquiz_percent') {
                            if(isset($row[$selected_header]) && $row[$selected_header] && $selected_header != 'dont_import'){
                                $entry[$form_field] = str_replace('%', '', $row[$selected_header]);
                            }
                        } elseif ($form_field == 'gquiz_is_pass') {
                            $entry[$form_field] = $row[$selected_header] == 'Pass' ? 1 : 0;
                        } else {
                            if(isset($row[$selected_header]) && $row[$selected_header] && $selected_header != 'dont_import'){
                                $entry[$form_field] = $row[$selected_header];
                            }
                        }
                    }
                }
            }

            if ($calculation) {
                $entry[$calculation['total_id']] = GFCommon::get_order_total($form, $entry);
            }

            $entry = apply_filters('gfei_before_entry_import', $entry, $form_id, $update);
            $count = 0;
            if ($signatures_check && $feed) {
                if ($update) {
                    $entry_id = $this->gfei_get_entry_id($unique_key, $row);
                    if ($entry_id != 0) {
                        GFAPI::update_entry($entry, $entry_id);
                        $message[] = __('Entry updated successfully', 'gf_entries_import');
                        $class = 'update';
                        $count += 1;
                    } else {
                        $entry_id = GFAPI::add_entry($entry);
                        $message[] = __('Entry added successfully', 'gf_entries_import');
                        $class = 'add';
                        $count += 1;
                    }
                } else {
                    $entry_id = GFAPI::add_entry($entry);
                    $message[] = __('Entry added successfully', 'gf_entries_import');
                    $class = 'add';
                    $count += 1;
                }



                if (!is_wp_error($entry_id)) {
                    GFCommon::create_post(GFAPI::get_form($form_id), GFAPI::get_entry($entry_id));
// create user if exists
                    if ($email_notification == 1) {
                        add_filter('gform_pre_send_email', array($this, 'gf_before_email'));
                        $this->send_notifications($form_id, $entry_id);
                    }

                    if ($this->gfei_is_field_type_exists('username', $form_id) && $this->gfei_is_field_type_exists('email', $form_id)) {
                        GF_User_Registration::gf_create_user(GFAPI::get_entry($entry_id), GFAPI::get_form($form_id));
                        $field_ids = $this->gfei_get_field_ids_by_type($form_id, 'password');
                        foreach ($field_ids as $meta_key) {
                            gform_delete_meta($entry_id, $meta_key);
                        }
                    }

// add notes if exists
                    $notes = array_filter($row, function($v) use($row) {
                        if ($v) {
                            return preg_match('#Entry Note \d#', array_search($v, $row));
                        }
                    });

                    foreach ($notes as $note) {
                        $note_data = explode('|', $note);
                        if (count($note_data) > 1) {
                            $note_text = $note_data[0];
                            if (is_numeric($note_data[1])) {
                                $user = get_userdata($note_data[1]);
                            } else {
                                $user = get_user_by('login', $note_data[1]);
                            }

                            if (empty($user)) {
                                $user = wp_get_current_user();
                            }
                        } else {
                            $note_text = $note_data[0];
                            $user = wp_get_current_user();
                        }

                        RGFormsModel::add_note($entry_id, $user->ID, $user->display_name, stripslashes($note_text));
                    }

                    do_action('gfei_after_entry_import', $entry_id, $form_id);
                } else {
                    if (count($signatures)) {
                        foreach ($signatures as $signature) {
// remove signature
                            $this->gfei_remove_signature_file($signature);
                        }
                    }
                }
            }
            
            $response['entry_id'] = $entry_id;
            $response['message'] = implode(', ', $message);
            $response['class'] = $class;
            $response['count'] = $count;


            return $response;
        }

        private function gfei_get_url_parameter($url, $parameter) {
            $result = '';

            if ($url) {
                $url_components = parse_url($url);
                parse_str($url_components['query'], $params);

                if (isset($params[$parameter]) && $params[$parameter]) {
                    $result = $params[$parameter] . '.png';
                }
            }

            return $result;
        }

        private function gfei_check_image_url($url) {
            $params = array('http' => array(
                    'method' => 'HEAD'
            ));
            $ctx = stream_context_create($params);
            $fp = @fopen($url, 'rb', false, $ctx);
            if (!$fp) {
                return false;  // Problem with url
            }

            $meta = stream_get_meta_data($fp);
            if ($meta === false) {
                fclose($fp);
                return false;  // Problem reading data from url
            }

            $wrapper_data = $meta["wrapper_data"];
            if (is_array($wrapper_data)) {
                foreach (array_keys($wrapper_data) as $hh) {
                    if ($wrapper_data[$hh] == "Content-Type: image/png") {
                        fclose($fp);
                        return true;
                    }
                }
            }

            fclose($fp);
            return false;
        }

        private function gfei_get_image_name($url) {
            $name = '';
            $pathinfo = pathinfo($url);
            if ($pathinfo['filename'] && $pathinfo['extension']) {
                $name = $pathinfo['filename'] . '.' . $pathinfo['extension'];
            } else {
                $name = uniqid() . '.png';
            }

            return $name;
        }

        private function gfei_upload_signature($url, $signature_file_name, $old_file_name = null) {
            $result = false;
            $signatureObj = GFSignature::get_instance();

            $folder = $signatureObj->get_signatures_folder();
            if (wp_mkdir_p($folder)) {
                $check = copy($url, $folder . $signature_file_name);

                $result = $check ? $signature_file_name : false;

                if ($result && $old_file_name) {
                    $this->gfei_remove_signature_file($old_file_name);
                }
            }

            return $result;
        }

        private function gfei_remove_signature_file($filename) {
            $signatureObj = GFSignature::get_instance();

            $signatureObj->delete_signature_file($filename);
        }

        private function gfei_get_entry_id($unique_key, $row) {
            $entry_id = 0;

            if (isset($row[$unique_key]) && $row[$unique_key]) {
                $entry_id = $row[$unique_key];
                if (is_numeric($entry_id)) {
//check if the entry id is existing
                    $entry = GFAPI::get_entry($entry_id);
                    if (!$entry->errors) {
                        return $entry_id;
                    } else {
                        $entry_id = 0;
                        return $entry_id;
                    }
                } else {
                    return $entry_id;
                }
            }
            return $entry_id;
        }

        private function gfei_column_letter($c) {
            $c = intval($c);
            if ($c <= 0) {
                return '';
            }

            $letter = '';

            while ($c != 0) {
                $p = ($c - 1) % 26;
                $c = intval(($c - $p) / 26);
                $letter = chr(65 + $p) . $letter;
            }

            return $letter;
        }

        private function gfei_get_entry_info_columns() {
            $columns = [
                'Entry Status',
                'Starred Entry',
                'Read Entry',
                'Entry Id',
                'Entry Date',
                'Created By (User Id)',
                'Source Url',
                'User Agent',
                'User IP',
                'Currency',
                'Payment Status',
                'Payment Date',
                'Transaction Id',
                'Payment Amount',
                'Payment Method',
                'Is Fulfilled',
                'Transaction Type'
            ];

            $columns = apply_filters( 'gfei_entry_info_columns',$columns);

            return $columns;
        }

        private function gfei_is_field_type_exists($type, $form_id) {
            $check = false;
            $form = RGFormsModel::get_form_meta($form_id);

            if (is_array($form["fields"])) {
                foreach ($form["fields"] as $field) {
                    if (isset($field["type"]) && $field["type"] == $type) {
                        $check = true;
                        break;
                    }
                }
            }

            return $check;
        }

        private function gfei_get_field_ids_by_type($form_id, $type) {
            $ids = array();
            $form = RGFormsModel::get_form_meta($form_id);
            if (is_array($form["fields"])) {
                foreach ($form["fields"] as $field) {
                    if (isset($field["type"]) && $field["type"] == $type) {
                        $ids[] = $field["id"];
                    }
                }
            }

            return $ids;
        }

        private function gfei_download_file_from_url($url, $path) {
            $newfname = $path;
            $file = fopen($url, 'rb');
            if ($file) {
                $newf = fopen($newfname, 'wb');
                if ($newf) {
                    while (!feof($file)) {
                        fwrite($newf, fread($file, 1024 * 8), 1024 * 8);
                    }
                }
            }
            if ($file) {
                fclose($file);
            }
            if ($newf) {
                fclose($newf);
            }
        }

        private function gfei_get_filename_from_url($url) {
            $parts = explode('/', $url);
            return array_pop($parts);
        }

        private function gfei_format_price($number) {
            $new_number = filter_var($number, FILTER_VALIDATE_INT);
            if ($new_number === FALSE) {
                return $number;
            } else {
                return $new_number;
            }
        }

        public function gfei_settings_page_callback() {
            ?>
            <div class="wrap">
                <div id="icon-tools" class="icon32"></div>
                <h1><?php _e('Gravity Forms Import Settings', 'gf_entries_import') ?></h1>

                <form method="post" action="options.php">
                    <?php settings_fields('gfei-plugin-settings'); ?>
                    <?php do_settings_sections('gfei-plugin-settings'); ?>
                    <table class="form-table">
                        <tr valign="top">
                            <th scope="row"><?php _e('Delimiter', 'gf_entries_import') ?></th>
                            <td>
                                <input type="text" name="gfei_delimiter" value="<?php echo esc_attr(get_option('gfei_delimiter', ',')); ?>" /><br/>
                                <span class="description"><?php _e('Define delimiter to parse the imported csv. Default is comma ","', 'gf_entries_import') ?></span>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row"><?php _e('No of rows', 'gf_entries_import') ?></th>
                            <td>
                                <input type="number" min="1" step="1" max="100" name="gfei_rows_per_import" value="<?php echo esc_attr(get_option('gfei_rows_per_import', 100)); ?>" /><br/>
                                <span class="description"><?php _e('No of rows imported per time to avoid timeout. Default is 100', 'gf_entries_import') ?></span>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row"><?php _e('Dont Validate CSV file', 'gf_entries_import') ?></th>
                            <?php
                            $checked = get_option('gfei_validate_csv');
                            
                            if (!empty($checked) && 'yes' == $checked) {
                                $checked = "Checked";
                            } else {
                                $checked = "";
                            }
                            ?>
                            <td>
                                <input type="checkbox" name="gfei_validate_csv" id="gfei_validate_csv" value="yes" <?php echo $checked; ?> /><br/>
                                <span class="description"><?php _e("Check this option to fix 'You should upload CSV file' error. ", 'gf_entries_import') ?></span>
                            </td>
                        </tr>
                    </table>

                    <?php submit_button(); ?>

                </form>
            </div>
            <?php
        }

        public function gfei_save_template_callback() {
            if (isset($_POST)) {
                if ($_POST['empty'] == 'true') {
                    $save = false;
                    $message = __('Please fill missing csv field map', 'gf_entries_import');
                    print_r(json_encode(array('saved' => $save, 'empty' => true, 'message' => $message)));
                    wp_die(); // this is required to terminate immediately and return a proper response
                } else {
                    $gfei_get_opt = get_option('gfei_template_options');
                    $add_option[] = $_POST;
                    if (!empty($gfei_get_opt)) {
                        $new = array_merge($gfei_get_opt, $add_option);
                        update_option('gfei_template_options', $new);
                        $save = true;
                    } else {
                        update_option('gfei_template_options', $add_option);
                        $save = true;
                    }

                    print_r(json_encode(array('saved' => $save, 'empty' => false)));

                    wp_die(); // this is required to terminate immediately and return a proper response
                }
            }
        }

        public function gfei_load_template_callback() {
            $gfei_get_opt = get_option('gfei_template_options');
            $options = [];
            if (isset($_POST['template_key'])) {
                $template_key = $_POST['template_key'];
                if ($gfei_get_opt[$template_key]) {
                    foreach ($gfei_get_opt[$template_key] as $k => $option) {
                        if ($k != 'action') {
                            $options[$k] = $option;
                        }
                    }
                }
            }
            print_r(json_encode(array('options' => $options)));

            wp_die(); // this is required to terminate immediately and return a proper response
        }

        public function gfei_remove_template_callback()
        {
            if(isset($_POST) && $_POST['template_key'])
                $template_key = $_POST['template_key'];
                $data = get_option('gfei_template_options');
                unset($data[(int)$template_key]);
                update_option('gfei_template_options', $data);
                wp_send_json(array('message' => 'success', 'key' => (int)$template_key), 200);
                wp_die();
        }

        public function gf_before_email($email) {
            $email['subject'] = 'Gravity Forms Imported';
            return $email;
        }

        public function send_notifications($form_id, $entry_id) {

// Get the array info for our forms and entries
// that we need to send notifications for

            $form = RGFormsModel::get_form_meta($form_id);
            $entry = RGFormsModel::get_lead($entry_id);

// Loop through all the notifications for the
// form so we know which ones to send

            $notification_ids = array();

            foreach ($form['notifications'] as $id => $info) {
                array_push($notification_ids, $id);
            }

// Send the notifications
            GFCommon::send_notifications($notification_ids, $form, $entry);
        }

        public function gf_import_add_cap() {
            $custom_cap = 'gf_import_entries_cap';
            $grant      = true;

            $role = get_role( 'administrator');
            $role->add_cap('gf_import_entries_cap');
        }

    }

    $importer = new Importer();
}