var $ = jQuery;
var import_success_message = messages.import_success_message;
var error_message = messages.error_message;
var no_import_message = messages.import_error_message;
var no_import_condition_message = messages.no_import_condition_message;
var no_file_message = messages.no_file_message;

$(document).ready(function () {

    $(document).on('click', '#gfei_submit', function (e) {
        e.preventDefault();

        var button = $(this);
        button.attr('disabled', 'disabled');

        if (document.getElementById("gfei_csv").files.length === 0) {
            bootbox.alert({
                title: error_message,
                message: no_file_message
            });
        } else {
            var file_data = $('#gfei_csv').prop('files')[0];
            var form_data = new FormData();
            form_data.append('action', 'gfei_upload_csv');
            form_data.append('file', file_data);

            $.ajax({
                url: ajaxurl,
                type: "POST",
                data: form_data,
                processData: false,
                contentType: false,
                success: function (response, textStatus, jqXHR) {
                    var obj = JSON.parse(response);


                    if (obj.status) {
                        $('#section_one').hide();
                        $('#section_two').show();
                        $('.loader_container').show();

                        var data = {
                            'action': 'gfei_get_form_fields',
                            'form': $('#gfei_form').val(),
                            'url': obj.url,
                            'log': obj.log_id
                        };
                        $.post(ajaxurl, data, function (response) {
                            var obj = JSON.parse(response);
                            if (obj.status) {
                                $('.fields_mapping_container').html(obj.html);
                            }

                            $('.loader_container').hide();
                        });
                    } else {
                        bootbox.alert({
                            title: error_message,
                            message: obj.message
                        });

                        $("#gfei_csv").val(null);
                    }
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    //if fails     
                }
            });
        }

        button.attr('disabled', false);
    });
    $(document).on('click', '#conditional_import', function (e) {
        if ($(this).is(':checked') === true) {
            $('#condition_import').show();
            $('.add_condition').show();
            $('#condition_mode').show();
        } else {
            $('#condition_row').html('');
            $('#condition_row').empty('');
            $('#condition_import').hide();
            $('.add_condition').hide();
            $('#condition_mode').hide();

        }
    });
    $(document).on('click', '.add', function (e) {
        e.preventDefault();
        $("#condition_import").clone()
                .removeAttr("id")
                .find("input:text").val("").end()
                .append($('<a class="delete">Remove</a>'))
                .appendTo("#condition_row");

    });

    $("body").on('click', ".delete", function () {
        $(this).closest(".condition_import").remove();
    });

    $(document).on('click', '#gfei_import', function (e) {
        e.preventDefault();

        var button = $(this);
        button.attr('disabled', 'disabled');
        $('#section_two').hide();
        $('#section_three').show();

        importCSVFileAjax(1);
    });



    $(document).on('click', '#enable_save', function () {
        if ($(this).prop('checked') == true) {
            $('.save_template').show();
        } else {
            $('.save_template').hide();
        }
    });

    $(document).on('click', '#gfei_save', function (e) {
        e.preventDefault();
        saveTemplateAjax();
    });

    $(document).on('click', '#gfei_load_template', function (e) {
        e.preventDefault();
        var data = {
            'action': 'gfei_load_template',
            'template_key': $('select[name="gfei_template_name"]').val()
        };
        $.post(ajaxurl, data, function (response) {
            var obj = JSON.parse(response);
            var options = obj.options;
            console.log(options);
            $('#condition_import').hide();
            $('#condition_mode').hide();
            $('#condition_row').html('');
            if (options.mapping) {
                $.each(options.mapping, function (key, value) {
                    $('select[name="mapping[' + key + ']"]').val(value);
                });
            }

//            $('.gfei_csv_file').val(options.url);
            $('.gfei_import_log').val(options.log);
            if (options.update == "1") {
                $('#update_entry').attr('checked', true);
            } else {
                $('#update_entry').attr('checked', false);
            }
            if (options.email_notifications == "1") {
                $('#email_notifications').attr('checked', true);
            } else {
                $('#email_notifications').attr('checked', false);
            }
            if (options.ignore_required == "1") {
                $('#ignore_required').attr('checked', true);
            } else {
                $('#ignore_required').attr('checked', false);
            }

            if (options.unique_key) {
                $('#unique_key').val(options.unique_key);
            }
            if (options.conditional_import == "1") {
                $('#conditional_import').attr('checked', true);
                var $cloned;
                $.each(options.conditional_value, function (key, value) {
                    $cloned = $("#condition_import").clone()
                            .removeAttr("id")
                            .addClass("showthis")
                            .append($('<a class="delete">Remove</a>'));
                    $("body").on('click', ".delete", function () {
                        $(this).closest(".condition_import").remove();
                    });
                    $cloned.find('input:text').each(function (index, item) {
                        $(item).val(value);
                    });
                    $cloned.find('select').each(function (e, i) {
                        if ($(this).attr("name") == "condition_field[]") {
                            $(i).val(options.conditional_field[key]);
                        }
                        if ($(this).attr("name") == "condition_option[]") {
                            $(i).val(options.conditional_match[key]);
                        }
                    });
                    $cloned.appendTo("#condition_row");
                    $(".showthis").show();
                });
            } else {
                $('#conditional_import').attr('checked', false);
            }

        });
    });
}
);

function saveTemplateAjax() {
    var mapping = {};
    var empty = false;

    $('select[name*="mapping"]').each(function () {
        if ($(this).val() == '') {
            empty = true;
        }
        if ($(this).data('key')) {
            mapping[$(this).data('index') + '##' + $(this).data('key')] = $(this).val();
        } else {
            mapping[$(this).data('index')] = $(this).val();
        }

    });

    var field = [];
    var option = [];
    var value = [];

    $('select[name*="condition_field"]').each(function () {
        field.push($(this).val());
    });
    $('select[name*="condition_option"]').each(function () {
        option.push($(this).val());
    });
    $('input[name*="condition_value"]').each(function () {
        value.push($(this).val());
    });

    var update = 0;
    if ($('#update_entry').is(":checked")) {
        update = 1;
    }

    var conditional = 0;
    if ($('#conditional_import').is(":checked")) {
        conditional = 1;
    }

    var ignore_required = 0;
    if ($('#ignore_required').is(":checked")) {
        ignore_required = 1;
    }
    var email_notifications = 0;
    if ($('#email_notifications').is(":checked")) {
        email_notifications = 1;
    }

    var data = {
        'action': 'gfei_save_template',
        'form': $('#gfei_form').val(),
        'mapping': mapping,
        'url': $('input[name="csv_file"]').val(),
        'log': $('input[name="import_log"]').val(),
        'unique_key': $('#unique_key').val(),
        'update': update,
        'conditional_import': conditional,
        'conditional_field': field,
        'conditional_match': option,
        'conditional_value': value,
        'template_name': $('input[name="template_name"]').val(),
        'empty': empty,
        'condition': $('select[name="condition_mode"]').val(),
        'ignore_required': ignore_required,
        'email_notifications': email_notifications
    };

    $.post(ajaxurl, data, function (response) {
        var obj = JSON.parse(response);
        if (obj.empty) {
            $('.error-message').html('<li class="gfei-error" style="text-align:center">' + obj.message + '</li>');
            $('#gfei_import').removeAttr('disabled');
            $('#section_two').show();
            $('#section_three').hide();
        }
        if (obj.saved) {
            $('#enable_save').prop('checked', false); // Unchecks it
            $('input[name=template_name]').val("");
            $('.save_template').hide();
            $('.error-message').html('');
            $('.save-template-message').html('<li class="gfei-add">Template has been saved successfully for later use</li>');
            $('#gfei_import').removeAttr('disabled');
//            $('#gfei_save').attr('disabled', 'disabled');
            $('#section_two').show();
            $('#section_three').hide();
        }
    });

}

function importCSVFileAjax(offset, count_success, count_error) {
    var mapping = {};
    var empty = false;

    if (count_success == null) {
        var count_success = 0;
    }
    if (count_error == null) {
        var count_error = 0;
    }
   
    $('select[name*="mapping"]').each(function () {
        if ($(this).val() == '') {
            empty = true;
        }
        if ($(this).data('key')) {
            mapping[$(this).data('index') + '##' + $(this).data('key')] = $(this).val();
        } else {
            mapping[$(this).data('index')] = $(this).val();
        }
    });
    var field = [];
    var option = [];
    var value = [];

    $('select[name*="condition_field"]').each(function () {
        field.push($(this).val());
    });
    $('select[name*="condition_option"]').each(function () {
        option.push($(this).val());
    });
    $('input[name*="condition_value"]').each(function () {
        value.push($(this).val());
    });

    var update = 0;
    if ($('#update_entry').is(":checked")) {
        update = 1;
    }

    var conditional = 0;
    if ($('#conditional_import').is(":checked")) {
        conditional = 1;
    }

    var ignore_required = 0;
    if ($('#ignore_required').is(":checked")) {
        ignore_required = 1;
    }
    var email_notifications = 0;
    if ($('#email_notifications').is(":checked")) {
        email_notifications = 1;
    }

    var data = {
        'action': 'gfei_import_csv',
        'form': $('#gfei_form').val(),
        'mapping': mapping,
        'url': $('input[name="csv_file"]').val(),
        'log': $('input[name="import_log"]').val(),
        'unique_key': $('#unique_key').val(),
        'update': update,
        'offset': offset,
        'conditional_import': conditional,
        'conditional_field': field,
        'conditional_match': option,
        'conditional_value': value,
        'empty': empty,
        'condition': $('select[name="condition_mode"]').val(),
        'ignore_required': ignore_required,
        'email_notifications': email_notifications,
        'count_success': parseInt(count_success),
        'count_error': parseInt(count_error),
//        'log_list':log_list
    };

    $.post(ajaxurl, data, function (response) {
        var obj = JSON.parse(response);
        console.log(obj.log_list);
        if (obj.message) {
            $('.error-message').html('<li class="gfei-error" style="text-align:center">' + obj.message + '</li>');
            $('#gfei_import').removeAttr('disabled');
            $('#section_two').show();
            $('#section_three').hide();
        } else {
            $('.gfei_csv_button').hide();
            $('#gfei_log_container').append(obj.log_list);
            if (obj.status) {
                importCSVFileAjax(obj.offset, obj.count_success, obj.count_error);
            } else {
                /*bootbox.alert({
                 message: import_success_message,
                 callback: function(){ 
                 location.reload(true);
                 }
                 });*/
                if (obj.import == 'true') {
                    if (obj.count_error !== '0') {
                        if (obj.count_success == '0') {
                            $('#gfei_log_container').append('<li class="gfei-add">We have proceed ' + obj.total + ' records : ' + obj.count_error + ' rejected </li>');
                        } else {
                            $('#gfei_log_container').append('<li class="gfei-add">We have proceed ' + obj.total + ' records : ' + obj.count_success + ' imported and ' + obj.count_error + ' rejected ' + '</li>');
                        }
                    } else {
                        $('#gfei_log_container').append('<li class="gfei-add">We have proceed and imported all ' + obj.count_success + ' records' + '</li>');
                    }

                } else if (obj.import == 'condition') {
                    $('#gfei_log_container').append('<li class="gfei-error">' + no_import_condition_message + '</li>');
                } else if (obj.import == 'false') {
                    if (obj.count_error !== '0') {
                        if (obj.count_success == '0') {
                            $('#gfei_log_container').append('<li class="gfei-add">We have proceed ' + obj.total + ' records : ' + obj.count_error + ' rejected </li>');
                        } else {
                            $('#gfei_log_container').append('<li class="gfei-add">We have proceed ' + obj.total + ' records : ' + obj.count_success + ' imported and ' + obj.count_error + ' rejected ' + '</li>');
                        }
                    } else {
                        $('#gfei_log_container').append('<li class="gfei-add">We have proceed and imported all ' + obj.count_success + ' records' + '</li>');
                    }
                }

                if (obj.log_file) {
                    $('#gfei_download_log_link').attr('href', obj.log_file);
                    $('.gfei_download_log_container').show();
                }
                if (obj.csv_url) {
                    $('#gfei_download_csv_link').attr('href', obj.csv_url);
                    $('.gfei_csv_button').show();
                }
            }
        }
    });
}