<?php
add_action( 'rest_api_init', function () {
    register_rest_route( 'api/v1', '/update-name/', array(
        'methods' => 'POST',
        'callback' => 'update_user_meta_for_kyc_callback',
    	'permission_callback' => 'kyc_update_user_permission'
    ));
});
function kyc_update_user_permission( WP_REST_Request $request ) {
  $auth = $request->get_header('authorization');
  if (! $auth || ! preg_match('/Basic\s+(.+)/', $auth, $matches)) {
    return new WP_Error('rest_forbidden', 'Credentials missing', ['status' => 401]);
  }

  $creds = base64_decode($matches[1]);
  list($user, $pass) = explode(':', $creds, 2);
  if ( $user === 'csrnowapiuser' && $pass === 'G2s]z9D3>O@9' ) {
    return true;
  }

  return new WP_Error('rest_forbidden', 'Invalid credentials', ['status' => 403]);
}
function update_user_meta_for_kyc_callback($request) {
    global $wpdb;
    $params = $request->get_params();
    $logs = sprintf( __('Request update user first or last names : %s', CIP_TXTDOMAIN), json_encode( $params ) );
	create_cip_logs_entery( 0, 'update-csrnow-user', '', 'member', $logs, true );
    $user_email = isset($params['email']) ? trim($params['email']) : '';
    $new_email = isset($params['new_email']) ? trim($params['new_email']) : '';
    $username = isset($params['username']) ? trim($params['username']) : '';
    $new_username = isset($params['new_username']) ? trim($params['new_username']) : '';
    $first_name    = sanitize_text_field($params['first_name']);
    $last_name     = sanitize_text_field($params['last_name']);
    $gender        = sanitize_text_field($params['gender']);
    $dob           = sanitize_text_field($params['dob']);
	$user = get_user_by('email', $user_email);
	if (empty($user_email)) {
        return rest_ensure_response([
            'success' => false,
            'message' => 'Email is required.'
        ]);
    }
    if (!empty($new_email) && empty($user_email)) {
        $error_response = [
            'success' => false,
            'message' => 'Email must be supplied if new_email is passed.'
        ];

        $logs = sprintf(
            __('Update-name API failed for %s. Response: %s.', CIP_TXTDOMAIN),
            $user_email ?: 'N/A',
            wp_json_encode($error_response)
        );

        create_cip_logs_entery(
            0,
            'Update name API Profile Activity Log',
            '',
            'sa',
            $logs,
            true
        );

        return rest_ensure_response($error_response);
    }
    if (!empty($new_email) && $user_email == $new_email) {
         $error_response = [
            'success' => false,
            'message' => 'New email cannot be the same as the current email.'
        ];

        $logs = sprintf(
            __('Update-name API failed for %s. Response: %s.', CIP_TXTDOMAIN),
            $user_email ?: 'N/A',
            wp_json_encode($error_response)
        );

        create_cip_logs_entery(
            0,
            'Update name API Profile Activity Log',
            '',
            'sa',
            $logs,
            true
        );

        return rest_ensure_response($error_response);
    }
    if (!empty($new_email)) {
        $email_in_wp = email_exists($new_email);
        if ($email_in_wp) {
            $error_response = [
                'success' => false,
                'message' => 'Email already in use.'
            ];

            $logs = sprintf(
                __('Update-name API failed for %s. Response: %s.', CIP_TXTDOMAIN),
                $user_email,
                wp_json_encode($error_response)
            );

            create_cip_logs_entery(
                0, // or $current_user->ID if available
                'Update name API Profile Activity Log',
                '',
                'sa',
                $logs,
                true
            );

            return rest_ensure_response($error_response);
        }
    }
    if (!empty($new_username) && ( empty($username) || empty($user_email) )) {
        $error_response = [
            'success' => false,
            'message' => 'Username must be supplied if new_username is passed.'
        ];

        $logs = sprintf(
            __('Update-name API failed for %s. Response: %s.', CIP_TXTDOMAIN),
            $user_email ?: 'N/A',
            wp_json_encode($error_response)
        );

        create_cip_logs_entery(
            0,
            'Update name API Profile Activity Log',
            '',
            'sa',
            $logs,
            true
        );

        return rest_ensure_response($error_response);
    }
    // // 🔹 Check if new username already exists (WordPress users)
    if (!empty($new_username) && $username == $new_username) {
        $error_response = [
            'success' => false,
            'message' => 'New username cannot be the same as the current username.'
        ];

        $logs = sprintf(
            __('Update-name API failed for %s. Response: %s.', CIP_TXTDOMAIN),
            $user_email ?: 'N/A',
            wp_json_encode($error_response)
        );

        create_cip_logs_entery(
            0,
            'Update name API Profile Activity Log',
            '',
            'sa',
            $logs,
            true
        );

        return rest_ensure_response($error_response);
    }
    if (!empty($new_username)) {
        $username_in_wp = username_exists($new_username);
        if ($username_in_wp) {
            $error_response = [
                'success' => false,
                'message' => 'Username already in use.'
            ];

            $logs = sprintf(
                __('Update-name API failed for %s. Response: %s.', CIP_TXTDOMAIN),
                $user_email,
                wp_json_encode($error_response)
            );

            create_cip_logs_entery(
                0,
                'Update name API Profile Activity Log',
                '',
                'sa',
                $logs,
                true
            );

            return rest_ensure_response($error_response);
        }
    }
	if ($user) {
     $user_id = $user->ID;
    }
    $deferred_logs = [];
    if (empty($new_username) && empty($new_email)) {
        return rest_ensure_response([
            'success' => false,
            'message' => 'Please enter at least one parameter to update.'
        ]);
    }
	$check_tables_have_email = check_email_avalabel_related_tables($user_email);
	if ( !$check_tables_have_email && !$user ) {
        $response = [
            'success' => true,
            'message' => 'No record found in related tables and WordPress user.',
            'data'    => array_merge(
                [
                    'email'    => $user_email ?: 'N/A',
                    'username' => !empty($username) ? $username : ($user ? $user->user_login : 'N/A')
                ],
                $new_meta
            )
        ];

        $logs = json_encode($response);

        create_cip_logs_entery(
            1,
            'Update name API Profile Activity Log',
            '',
            'sa',
            'Response return = ' . $logs,
            true
        );

        return rest_ensure_response($response);
    }
    $wpdb->query('START TRANSACTION');
	$username_change = false;
    $email_change = false;
    if(!empty($new_username)){
        $update_response = update_new_username_by_email_to_related_tables($new_username,$username,$user_email);
        if ($update_response === false || (isset($update_response['success']) && $update_response['success'] === false)) {
            $wpdb->query('ROLLBACK');
            if (!empty($update_response['logs'])) {
                $deferred_logs = array_merge($deferred_logs, $update_response['logs']);
            }
            foreach ($deferred_logs as $log) {
                create_cip_logs_entery(0, $log['type'], '', 'member', $log['message'], true);
            }
            create_cip_logs_entery(
                0,
                'rollback',
                '',
                'member',
                $user_email . " : Rollback username update across related tables (DB update failed)",
                true
            );
            return rest_ensure_response([
                'success' => false,
                'message' => $update_response['message'] ?? 'DB update failed. Rolled back.'
            ]);
        }
        if (!empty($update_response['logs'])) {
            $deferred_logs = array_merge($deferred_logs, $update_response['logs']);
        }
        $username_change = true;
    }
    if( !empty($new_email) ) {
        $update_response = update_new_email_by_email_to_related_tables($new_email, $user_email);
        if ($update_response === false || (isset($update_response['success']) && $update_response['success'] === false)) {
            $wpdb->query('ROLLBACK');
            if (!empty($update_response['logs'])) {
                $deferred_logs = array_merge($deferred_logs, $update_response['logs']);
            }
            foreach ($deferred_logs as $log) {
                create_cip_logs_entery(0, $log['type'], '', 'member', $log['message'], true);
            }
            create_cip_logs_entery(
                0,
                'rollback',
                '',
                'member',
                $user_email . " : Rollback email update across related tables (DB update failed)",
                true
            );
            return rest_ensure_response([
                'success' => false,
                'message' => $update_response['message'] ?? 'DB update failed. Rolled back.'
            ]);
        }
        if (!empty($update_response['logs'])) {
            $deferred_logs = array_merge($deferred_logs, $update_response['logs']);
        }
        $email_change = true;
    }
	$wpdb->query('COMMIT');
    foreach ($deferred_logs as $log) {
        create_cip_logs_entery(0, $log['type'], '', 'member', $log['message'], true);
    }
    if($email_change){
        $log_message = sprintf(
            __('Email successfully updated from %s to %s at %s', CIP_TXTDOMAIN),
            $user_email,
            $new_email,
            date_i18n('d/m/Y H:i A')
        );
        create_cip_logs_entery(0, 'email_update', '', 'member', $log_message, true);
    }
    if($username_change || $email_change){
        if ($user && function_exists('wp_destroy_all_sessions')) {
            wp_destroy_all_sessions($user_id); // 🔹 Logout user everywhere

            // 🔹 Build reason text
            if ($username_change && $email_change) {
                $reason = __('username and email change', CIP_TXTDOMAIN);
            } elseif ($username_change) {
                $reason = __('username change', CIP_TXTDOMAIN);
            } else {
                $reason = __('email change', CIP_TXTDOMAIN);
            }

            // 🔹 Logout log
            $logout_message = sprintf(
                __('User ID %d (%s) was logged out from all sessions due to %s at %s', CIP_TXTDOMAIN),
                $user_id,
                $user_email,
                $reason,
                date_i18n('d/m/Y H:i A')
            );

            create_cip_logs_entery(0, 'force_logout', '', 'member', $logout_message, true);
        }
    }
    $output_username = $user->user_login;
    $output_email = $user_email;
    if($new_username){
        $output_username = $new_username;
    }
    if($new_email){
        $output_email = $new_email;
    }
    return rest_ensure_response([
        'success' => true,
        'message' => 'User profile names has been updated successfully.',
        'data'    => array_merge(['email' => $output_email,'username' => $output_username])
    ]);
}

function check_email_avalabel_related_tables( $user_email = "" ){
    global $wpdb;

    if( empty($user_email) ) {
        return false;
    }

    $tables_with_column = [
        $wpdb->prefix.'cip_member_invoice' => 'Email',
    ];

    foreach( $tables_with_column as $table => $columns ){
        if( is_array($columns) ){
            // multiple column check (like internaltransfer)
            foreach( $columns as $col ){
                $exists = $wpdb->get_var(
                    $wpdb->prepare("SELECT 1 FROM {$table} WHERE {$col} = %s LIMIT 1", $user_email)
                );
                if( $exists ){
                    return true;
                }
            }
        } else {
            // single column check
            $exists = $wpdb->get_var(
                $wpdb->prepare("SELECT 1 FROM {$table} WHERE {$columns} = %s LIMIT 1", $user_email)
            );
            if( $exists ){
                return true;
            }
        }
    }

    return false;
}

function update_new_username_by_email_to_related_tables($new_username, $old_username, $user_email) {
    global $wpdb;
    $deferred_logs = [];
	$oldUserData = get_user_by('email', $user_email);
    if ($oldUserData && $oldUserData->ID) {
        if (!username_exists($new_username)) {
            $wp_update = $wpdb->update(
                $wpdb->users,
                ['user_login' => esc_attr($new_username)],
                ['ID' => $oldUserData->ID]
            );

            if ($wp_update) {
                $logs = sprintf(
                    __('WP user username update for email %s old username %s to new username %s at %s', CIP_TXTDOMAIN),
                    $user_email,
                    $old_username,
                    $new_username,
                    date_i18n('d/m/Y H:i A')
                );
                $deferred_logs[] = ['type' => 'wp_users - db', 'message' => $logs];
            } else {
                return [
                    'success' => false,
                    'message' => sprintf(
                        'Username update failed for email %s (old: %s, new: %s) in table %s.',
                        $user_email,
                        $old_username,
                        $new_username,
                        $wpdb->users
                    ),
                    'logs'    => $deferred_logs
                ];
            }
        }
    }
    // $tables = [
    //     $wpdb->prefix.'cip_member_invoice'      => ['username', 'email'],
    // ];

    // foreach ($tables as $table => $cols) {
    //     list($col_username, $col_email) = $cols;

    //     // ✅ Check if row exists first
    //     $row_exists = $wpdb->get_var(
    //         $wpdb->prepare("SELECT COUNT(*) FROM {$table} WHERE {$col_email} = %s", $user_email)
    //     );

    //     if ($row_exists > 0) {
    //         $updated = $wpdb->update(
    //             $table,
    //             [$col_username => $new_username],
    //             [$col_email => $user_email]
    //         );

    //         if ($updated === false) {
    //             return [
    //                 'success' => false,
    //                 'message' => "Failed to update username in {$table}",
    //                 'logs'    => $deferred_logs
    //             ];
    //         }

    //         if ($updated > 0) {
    //             $logs = sprintf(
    //                 __('Bulk username update for email %s old username %s to new username %s in table %s at %s', CIP_TXTDOMAIN),
    //                 $user_email,
    //                 $old_username,
    //                 $new_username,
    //                 $table,
    //                 date_i18n('d/m/Y H:i A')
    //             );
    //             $deferred_logs[] = ['type' => "{$table} - db", 'message' => $logs];
    //         }
    //     }
    // }

    return [
        'success' => true,
        'logs'    => $deferred_logs
    ];
}


function update_new_email_by_email_to_related_tables($new_email, $old_email) {
    global $wpdb;
    $deferred_logs = [];
	$oldUserData = get_user_by('email', $old_email);
    if ($oldUserData && $oldUserData->ID) {
        if (!email_exists($new_email)) {
            $wp_update = $wpdb->update(
                $wpdb->users,
                ['user_email' => sanitize_email($new_email)],
                ['ID' => $oldUserData->ID]
            );

            if ($wp_update) {
                $logs = sprintf(
                    __('WP user email update for old email %s to new email %s at %s', CIP_TXTDOMAIN),
                    $old_email,
                    $new_email,
                    date_i18n('d/m/Y H:i A')
                );
                $deferred_logs[] = ['type' => 'wp_users - db', 'message' => $logs];
            } else {
                return [
                    'success' => false,
                    'message' => sprintf(
                        'Email update failed for user ID %d (old: %s, new: %s).',
                        $oldUserData->ID,
                        $old_email,
                        $new_email
                    ),
                    'logs'    => $deferred_logs
                ];
            }
        }
    }

    $tables = [
        $wpdb->prefix.'cip_member_invoice'            => ['Email'],
    ];

    foreach ($tables as $table => $cols) {
        list($col_email) = $cols;

        // ✅ Check if row exists first
        $row_exists = $wpdb->get_var(
            $wpdb->prepare("SELECT COUNT(*) FROM {$table} WHERE {$col_email} = %s", $old_email)
        );

        if ($row_exists > 0) {
            $updated = $wpdb->update(
                $table,
                [$col_email => $new_email],
                [$col_email => $old_email]
            );

            if ($updated === false) {
                return [
                    'success' => false,
                    'message' => "Failed to update email in {$table}",
                    'logs'    => $deferred_logs
                ];
            }

            if ($updated > 0) {
                $logs = sprintf(
                    __('Bulk email update for old email %s to new email %s in table %s at %s', CIP_TXTDOMAIN),
                    $old_email,
                    $new_email,
                    $table,
                    date_i18n('d/m/Y H:i A')
                );
                $deferred_logs[] = ['type' => "{$table} - db", 'message' => $logs];
            }
        }
    }

    return [
        'success' => true,
        'logs'    => $deferred_logs
    ];
}