<?php 
add_action('wp_ajax_cip_request_deposit_table_list_loader','cip_request_deposit_table_list_loader_cb');

function cip_request_deposit_table_list_loader_cb(){

	global $wpdb;



	$tableReceipts = $wpdb->prefix.'request_deposit';



	$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableReceipts WHERE 1 AND `type_of_deposit`='CAD'");

	

	$limit = isset( $_POST['limit'] ) ? $_POST['limit'] : 10;

	$offset = isset( $_POST['offset'] ) ? $_POST['offset'] : 0;

	$orderby = isset( $_POST['sort'] ) ? $_POST['sort'] : 'id';

	$order = (isset($_POST['order']) && in_array($_POST['order'], array('asc', 'desc'))) ? $_POST['order'] : 'desc';

	

	$filter_qry = "";

	$filters = json_decode( stripslashes( $_REQUEST['columnfilter'] ), true );

	if( !empty( $filters ) ){

		foreach( $filters as $filterKey => $filterData ){

			$filter_qry .= " AND `$filterKey` like '%" . $filterData . "%'";

		}

		$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableReceipts WHERE 1 AND `type_of_deposit`='CAD' $filter_qry");

	}

	

	$getReceiptsLists = $wpdb->get_results("SELECT * FROM $tableReceipts WHERE 1 AND `type_of_deposit`='CAD' $filter_qry ORDER BY `$orderby` $order LIMIT $limit OFFSET $offset");

	

	

	$rows = array();

	if( $getReceiptsLists ){

		$sno= $_REQUEST['offset'] + 1;

		foreach( $getReceiptsLists as $getReceiptsList ){

			$row = array();

			$columnsArr = array(

				'id' => __('id', CIP_TXTDOMAIN),

				'username' => __('Username', CIP_TXTDOMAIN),

				'name' => __('Name', CIP_TXTDOMAIN),

				'type_of_deposit' => __('Type of deposit', CIP_TXTDOMAIN),

				'email' => __('Email', CIP_TXTDOMAIN),

				// 'block_chain' => __('Block Chain', CIP_TXTDOMAIN),

                'amount_euro' => __('Amount Euro', CIP_TXTDOMAIN),

                'exchange_rate' => __('Exchange Rate', CIP_TXTDOMAIN),

                'exchange_amount' => __('Exchange Amount', CIP_TXTDOMAIN),

				// 'blockchain_address' => __('Blockchain address', CIP_TXTDOMAIN),

				// 'transaction_hash' => __('Transaction Hash', CIP_TXTDOMAIN),
				
				'confimation_password' => __('Confimation Password', CIP_TXTDOMAIN),

				'reference' => __('Reference', CIP_TXTDOMAIN),

				'status' => __('Reference', CIP_TXTDOMAIN),

			);



			if( $columnsArr ){

				foreach( $columnsArr as $columnKey => $columnsVal ){

					$columnsDataVal = $getReceiptsList->$columnKey;



					if( $columnKey == 'amount' ){

						if( !empty( $columnsDataVal ) ){

							$columnsDataVal = cip_number_format( $columnsDataVal, true );

						}

					}



					if( empty( $columnsDataVal ) ){

						$columnsDataVal = '—';

					
						if($columnKey == 'status' && $columnsDataVal == 'reject'){
							$columnsDataVal = 'Rejected';
						}elseif($columnKey == 'status'){
							$columnsDataVal = 'Pending';
						}
					}
					if($columnKey == 'reference'){
						if($columnsDataVal != '—'){
							$row[$columnKey] = "AMP-".$columnsDataVal;
						}
					}else{
						$row[$columnKey] = $columnsDataVal;
					}
					

				}

			}

			$encryptId = base64_encode($getReceiptsList->id . md5('_CIP_RECEIPTS_CIP_'));

			$processUrl = add_query_arg( array('view' => $encryptId ), get_the_permalink( 6866 ) );

			if( $getReceiptsList->invoiceStatus != 'Paid' ){

				$row['action'] = '<a href="'. $processUrl .'"><i class="fas fa-pencil-alt" data-toggle-tt="tooltip" data-placement="top" title="'.__('Process', CIP_TXTDOMAIN).'"></i></a>';

			}



			$rows[] = $row;

			$sno=$sno+1;

		}

	}

	$out = array(

		'total'			=>	$total_items,

		'rows'			=>	$rows

	);

	echo wp_json_encode( $out );

	exit;

}

add_action('wp_ajax_cip_request_deposit_table_list_usdt_loader','cip_request_deposit_table_list_usdt_loader_cb');

function cip_request_deposit_table_list_usdt_loader_cb(){

	global $wpdb;

	$tableReceipts = $wpdb->prefix.'request_deposit';
	$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableReceipts WHERE 1 AND `type_of_deposit`='USDT'");

	$limit = isset( $_POST['limit'] ) ? $_POST['limit'] : 10;
	$offset = isset( $_POST['offset'] ) ? $_POST['offset'] : 0;
	$orderby = isset( $_POST['sort'] ) ? $_POST['sort'] : 'id';
	$order = (isset($_POST['order']) && in_array($_POST['order'], array('asc', 'desc'))) ? $_POST['order'] : 'desc';	

	$filter_qry = "";
	$filters = json_decode( stripslashes( $_REQUEST['columnfilter'] ), true );

	if( !empty( $filters ) ){
		foreach( $filters as $filterKey => $filterData ){
			$filter_qry .= " AND `$filterKey` like '%" . $filterData . "%'";
		}
		$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableReceipts WHERE 1 AND `type_of_deposit`='USDT' $filter_qry");
	}	

	$getReceiptsLists = $wpdb->get_results("SELECT * FROM $tableReceipts WHERE 1 AND `type_of_deposit`='USDT' $filter_qry ORDER BY `$orderby` $order LIMIT $limit OFFSET $offset");	

	$rows = array();

	if( $getReceiptsLists ){

		$sno= $_REQUEST['offset'] + 1;

		foreach( $getReceiptsLists as $getReceiptsList ){

			$row = array();

			$columnsArr = array(

				'id' => __('id', CIP_TXTDOMAIN),

				'username' => __('Username', CIP_TXTDOMAIN),

				'name' => __('Name', CIP_TXTDOMAIN),

				'type_of_deposit' => __('Type of deposit', CIP_TXTDOMAIN),

				'email' => __('Email', CIP_TXTDOMAIN),

				'block_chain' => __('Block Chain', CIP_TXTDOMAIN),

                'amount_euro' => __('Amount Euro', CIP_TXTDOMAIN),

                'exchange_rate' => __('Exchange Rate', CIP_TXTDOMAIN),

                'exchange_amount' => __('Exchange Amount', CIP_TXTDOMAIN),

				'blockchain_address' => __('Blockchain address', CIP_TXTDOMAIN),

				'transaction_hash' => __('Transaction Hash', CIP_TXTDOMAIN),
				
				'confimation_password' => __('Confimation Password', CIP_TXTDOMAIN),

				'reference' => __('Reference', CIP_TXTDOMAIN),

				'status' => __('Reference', CIP_TXTDOMAIN),

			);



			if( $columnsArr ){

				foreach( $columnsArr as $columnKey => $columnsVal ){

					$columnsDataVal = $getReceiptsList->$columnKey;



					if( $columnKey == 'amount' ){

						if( !empty( $columnsDataVal ) ){

							$columnsDataVal = cip_number_format( $columnsDataVal, true );

						}

					}



					if( empty( $columnsDataVal ) ){

						$columnsDataVal = '—';

					}

					if( $columnKey == 'blockchain_address' ){

						$columnsDataVal = shorten_ethereum($columnsDataVal);

					}
					if( $columnKey == 'transaction_hash'){
							$columnsDataVal = $getReceiptsList->$columnKey;
							if( !empty( $columnsDataVal ) ){
								$columnsDataValMask = substr($columnsDataVal, 0, 4) . '...' . substr($columnsDataVal, -4);
								$columnsDataVal = '<a href="https://etherscan.io/address/'. $columnsDataVal.'" target="_blank" data-toggle-tt="tooltip" data-placement="top" title="'.__($columnsDataVal, CIP_TXTDOMAIN).'" >'. $columnsDataValMask . '</a>';
							}else{
								$columnsDataVal = '—';
							}
					}

					if($columnKey == 'status' && $columnsDataVal == 'reject'){
						$columnsDataVal = 'Rejected';
					}elseif($columnKey == 'status'){
						$columnsDataVal = 'Pending';
					}

					if($columnKey == 'reference'){
						if($columnsDataVal != '—'){
							$row[$columnKey] = "AMP-".$columnsDataVal;
						}
					}else{
						$row[$columnKey] = $columnsDataVal;
					}

				}

			}

			$encryptId = base64_encode($getReceiptsList->id . md5('_CIP_RECEIPTS_CIP_'));

			$processUrl = add_query_arg( array('view' => $encryptId ), get_the_permalink( 6866 ) );

			if( $getReceiptsList->invoiceStatus != 'Paid' ){

				$row['action'] = '<a href="'. $processUrl .'"><i class="fas fa-pencil-alt" data-toggle-tt="tooltip" data-placement="top" title="'.__('Process', CIP_TXTDOMAIN).'"></i></a>';

			}



			$rows[] = $row;

			$sno=$sno+1;

		}

	}

	$out = array(

		'total'			=>	$total_items,

		'rows'			=>	$rows

	);

	echo wp_json_encode( $out );

	exit;

}



add_action('wp_footer','cip_new_init_bs_paging_ajax_table_script');

function cip_new_init_bs_paging_ajax_table_script(){

	$cip_request_deposit_table_list_url = add_query_arg( [

		'action'	=>	'cip_request_deposit_table_list_loader',

		'pageid'	=>	get_the_ID(),

	], admin_url( 'admin-ajax.php' ) );

	$cip_request_deposit_table_list_usdt_url = add_query_arg( [

		'action'	=>	'cip_request_deposit_table_list_usdt_loader',

		'pageid'	=>	get_the_ID(),

	], admin_url( 'admin-ajax.php' ) );

?><script>

  jQuery(document).ready(function($){

	if( $('#cip_request_deposit_table_list').length > 0 ){		

		var cip_request_deposit_table_list_url = "<?php echo $cip_request_deposit_table_list_url ?>";

		var wpadminbar = isNaN( parseInt( $('#wpadminbar').height() ) ) ? 0 : parseInt( $('#wpadminbar').height() ) ;

		stickyHeaderOffset = wpadminbar;

		var $tablePendinReview = $('#cip_request_deposit_table_list');

		$tablePendinReview.bootstrapTable({

			method: 'post',

			contentType: 'application/x-www-form-urlencoded',

			url: cip_request_deposit_table_list_url,

			queryParams: function (p) {

				return {

					columnfilter: p.filter,

					limit: p.limit,

					offset: p.offset,

					sort: p.sort,

					order: p.order,

				};

			},

			stickyHeader: false,

			stickyHeaderOffsetY: stickyHeaderOffset,

			onPostBody: function (){

				if( $('[data-toggle-tt="tooltip"]').length > 0 ){

					$('[data-toggle-tt="tooltip"]').tooltip();

				}

				$('.filter-control input.search-input').prop('readonly',false);

			},

			onSearch: function( search ){

				$('.filter-control input.search-input').prop('readonly',true);

			}

		});

	}

	if( $('#cip_request_deposit_table_list_usdt').length > 0 ){		

		var cip_request_deposit_table_list_usdt_url = "<?php echo $cip_request_deposit_table_list_usdt_url ?>";

		var wpadminbar = isNaN( parseInt( $('#wpadminbar').height() ) ) ? 0 : parseInt( $('#wpadminbar').height() ) ;

		stickyHeaderOffset = wpadminbar;

		var $tablePendinReview = $('#cip_request_deposit_table_list_usdt');

		$tablePendinReview.bootstrapTable({

			method: 'post',

			contentType: 'application/x-www-form-urlencoded',

			url: cip_request_deposit_table_list_usdt_url,

			queryParams: function (p) {

				return {

					columnfilter: p.filter,

					limit: p.limit,

					offset: p.offset,

					sort: p.sort,

					order: p.order,

				};

			},

			stickyHeader: false,

			stickyHeaderOffsetY: stickyHeaderOffset,

			onPostBody: function (){

				if( $('[data-toggle-tt="tooltip"]').length > 0 ){

					$('[data-toggle-tt="tooltip"]').tooltip();

				}

				$('.filter-control input.search-input').prop('readonly',false);

			},

			onSearch: function( search ){

				$('.filter-control input.search-input').prop('readonly',true);

			}

		});

	}

	$('body').on('click', '.cad_toggle_de', function(){
		$('body').find('.de_toggle').removeClass('active');
		$('body').find('.cad_toggle_de').addClass('active');
		$('section#de_cad_only').show();
		$('section#de_usdt_only').hide();

	});
	$('body').on('click', '#customToolbar_table .de_t_toggle', function(){
		$('body').find('.de_t_toggle').removeClass('active');
		$(this).addClass('active');

	});
	$('body').on('click', '.mtdt_de_toggle', function(){
		$('body').find('.mtdt_de_toggle').removeClass('active');
		$(this).addClass('active');
		// var get_value = jQuery(this).val();
		var get_value = jQuery(".mtdt_de_toggle.active").attr('value');
		console.log(get_value);
		if(get_value == 'USDT'){
			jQuery("#member_transaction__detail_table").bootstrapTable("showAllColumns");
			jQuery("#member_transaction__detail_table").bootstrapTable("hideColumn","exchange_amount");
			jQuery("#member_transaction__detail_table").bootstrapTable("hideColumn","type_of_deposit");
			jQuery("#member_transaction__detail_table").bootstrapTable("hideColumn","confimation_password");
			jQuery("#member_transaction_w_detail_table").bootstrapTable("showAllColumns");
			jQuery("#member_transaction_w_detail_table").bootstrapTable("hideColumn","cad_amount_euro");
			jQuery("#member_transaction_w_detail_table").bootstrapTable("hideColumn","bank_name");
			jQuery("#member_transaction_w_detail_table").bootstrapTable("hideColumn","bank_address");
			jQuery("#member_transaction_w_detail_table").bootstrapTable("hideColumn","account_holder");
			jQuery("#member_transaction_w_detail_table").bootstrapTable("hideColumn","bank_iban");
			jQuery("#member_transaction_w_detail_table").bootstrapTable("hideColumn","bank_bic");
			jQuery("#member_transaction_w_detail_table").bootstrapTable("hideColumn","type_of_withdrawal");
			// jQuery("#member_transaction_w_detail_table").bootstrapTable("showColumn","usdt_block_chain,usdt_blockchain_address,usdt_amount_euro");
		}else if(get_value == 'CAD'){
			jQuery("#member_transaction__detail_table").bootstrapTable("showAllColumns");
			jQuery("#member_transaction__detail_table").bootstrapTable("hideColumn","blockchain_address");
			jQuery("#member_transaction__detail_table").bootstrapTable("hideColumn","transaction_hash");
			jQuery("#member_transaction__detail_table").bootstrapTable("hideColumn","block_chain");
			jQuery("#member_transaction__detail_table").bootstrapTable("hideColumn","usdt");
			jQuery("#member_transaction__detail_table").bootstrapTable("hideColumn","type_of_deposit");

			jQuery("#member_transaction_w_detail_table").bootstrapTable("showAllColumns");
			jQuery("#member_transaction_w_detail_table").bootstrapTable("hideColumn","usdt_blockchain_address");
			// jQuery("#member_transaction_w_detail_table").bootstrapTable("hideColumn","usdt_block_chain");`
			
			jQuery("#member_transaction_w_detail_table").bootstrapTable("hideColumn","usdt_amount_euro");
			jQuery("#member_transaction_w_detail_table").bootstrapTable("hideColumn","usdt_block_chain");
			jQuery("#member_transaction_w_detail_table").bootstrapTable("hideColumn","type_of_withdrawal");

			// jQuery("#member_transaction_w_detail_table").bootstrapTable("showColumn","cad_amount_euro");
		}else{
			jQuery("#member_transaction__detail_table").bootstrapTable("showAllColumns");
			jQuery("#member_transaction_w_detail_table").bootstrapTable("showAllColumns");
		}

		let eve = jQuery.Event("keyup");
		eve.which = 13
		eve.keyCode = 13
		$('#member_transaction__detail_table .bootstrap-table-filter-control-reference').trigger(eve);
		
		let eve2 = jQuery.Event("keyup");
		eve2.which = 13
		eve2.keyCode = 13
		$('#member_transaction_w_detail_table .bootstrap-table-filter-control-reference').trigger(eve2);
	});
	
	$('body').on('click', '.usdt_toggle_de', function(){
		$('body').find('.de_toggle').removeClass('active');
		$('body').find('.usdt_toggle_de').addClass('active');
		$('section#de_usdt_only').show();
		$('section#de_cad_only').hide();
	});



    jQuery(document).on('change', "#type_of_deposit",function(){
        var type = jQuery(this).val();
        if(type == 'USDT'){

            jQuery("#cad_type_seleted").hide();
            jQuery("#usdt_type_seleted").show();
            
        }else{
            
            jQuery("#cad_type_seleted").show();
            jQuery("#usdt_type_seleted").hide();
        }
    });
    jQuery(document).on('change', "#usdt_block_chain",function(){
        var content = jQuery(this).val();

       
        
        jQuery(".withdrawal_request_blockchain_txt span").text(content);
    });
    jQuery(document).on('change',"#usdt_blockchain_address",function(){
        var content = jQuery(this).val();
        jQuery(".withdrawal_request_blockchain_address_txt span").text(content);
    });
	
    $('body').on('change', '#type_of_deposit', function(){
        if( $(this).val() == 'USDT' ){
            $('body').find('.usdt_section').show();
            $('body').find('.usdt_section_final').show();
            $('body').find('.cad_section').hide();
            $('body').find('.cad_section_final').hide();
        }else if( $(this).val() == 'CAD' ){
            $('body').find('.usdt_section').hide();
            $('body').find('.usdt_section_final').hide();
            $('body').find('.cad_section').show();
            $('body').find('.cad_section_final').show();
        }else{
            $('body').find('.usdt_section').hide();
            $('body').find('.usdt_section_final').hide();
            $('body').find('.cad_section').hide ();
            $('body').find('.cad_section_final').hide ();
        }
    });

  });

</script>

<?php

}





add_action('wp_ajax_cipMemberdepositRequestSubmitAct', 'cipMemberdepositRequestSubmitAct');
add_action('wp_ajax_nopriv_cipMemberdepositRequestSubmitAct', 'cipMemberdepositRequestSubmitAct'); // For non-logged-in users
function cipMemberdepositRequestSubmitAct() {
    global $wpdb;

    $table_name = $wpdb->prefix . 'request_deposit';

    $current_user = wp_get_current_user();
    $user_email = $current_user->user_email;

    
    if($_REQUEST['is_fieldmap'] == '1'){

        // Sanitize and validate form data
        $username = sanitize_text_field($_POST['username']);
        $name = sanitize_text_field($_POST['name']);
        $type_of_deposit = sanitize_text_field($_POST['type_of_deposit']);

        // Validate form fields
        $errors = array();

        if (empty($username)) {
            $errors['username'] = 'Username';
        }

        if (empty($name)) {
            $errors['name'] = 'Name';
        }

        if (empty($type_of_deposit)) {
            $errors['type_of_deposit'] = 'Type of Deposit';
        }

        // Check for errors
        if (empty($errors)) {
            // Insert data into the custom table
            if($_REQUEST['id'] == ''){
        
                $result = $wpdb->insert(
                    $table_name,
                    array(
                        'username' => $username,
                        'name' => $name,
                        'type_of_deposit' => $type_of_deposit,
                        'email' => $user_email
                    )
                );
                if($result){
                    $inserted_row_id = $wpdb->insert_id;
                }

            }else{
                $data_to_update = array(
                    'username' => $username,
                    'name' => $name,
                    'type_of_deposit' => $type_of_deposit,
                    'email' => $user_email
                );
            
                // Define the WHERE condition
                $where = array('id' => $_REQUEST['id']);
                $inserted_row_id = $_REQUEST['id'];
                // Perform the update
                $result = $wpdb->update($table_name, $data_to_update, $where);
            }

            if($type_of_deposit == 'CAD')
            {
            	$coinbase_request_url = add_query_arg( 'currency', 'CAD', 'https://api.coinbase.com/v2/exchange-rates' );
            }
            if($type_of_deposit == 'USDT')
            {
            	$coinbase_request_url = add_query_arg( 'currency', 'USDT', 'https://api.coinbase.com/v2/exchange-rates' );
            }

            $coinbase_response = wp_remote_get( $coinbase_request_url );
            $exchangeRate = 0;
            if( !is_wp_error( $coinbase_response ) ) {
                $coinbase_response_body = wp_remote_retrieve_body( $coinbase_response );
                $data = json_decode( $coinbase_response_body );
                if( is_object( $data ) ){
                    $rates = $data->data->rates;
                    if( isset( $rates->EUR ) ){
                        $exchangeRate = round( $rates->EUR, 4 );
                    }
                }
            }
            if ($result) {
                // Data inserted successfully
                wp_send_json_success(array('message' => 'Your package has been updated.','id'=>$inserted_row_id,'data' => $exchangeRate));
            } else {
                // Error while inserting data
                wp_send_json_success(array('message' => 'Your package has been updated.','data' => $exchangeRate ));
            }
        } else {
            // Validation errors
            wp_send_json_error(array('message' => 'Please select type of deposit.'));
        }


    }elseif($_REQUEST['is_fieldmap'] == '2'){
        
        // Sanitize and validate form data
        $usdt_block_chain_value = isset($_POST['usdt_block_chain']) ? sanitize_text_field($_POST['usdt_block_chain']) : '';
        $usdt_amount_euro_value = isset($_POST['usdt_amount_euro']) ? sanitize_text_field($_POST['usdt_amount_euro']) : '';
        $usdt_exchange_rate_value = isset($_POST['usdt_exchange_rate']) ? sanitize_text_field($_POST['usdt_exchange_rate']) : '';
        $usdt_exchange_amount_value = isset($_POST['usdt_exchange_amount']) ? sanitize_text_field($_POST['usdt_exchange_amount']) : '';
        $usdt_blockchain_address_value = isset($_POST['usdt_blockchain_address']) ? sanitize_text_field($_POST['usdt_blockchain_address']) : '';

        // Validation for 'usdt_block_chain'
		$type_of_deposit = sanitize_text_field($_POST['type_of_deposit']);
		$errors_message = '';

        if($type_of_deposit == 'USDT'){
			if (empty($usdt_block_chain_value)) {
                $errors['usdt_block_chain'] = 'Block Chain';
				$errors_message = 'Block Chain';
            }
            if (empty($usdt_blockchain_address_value)) {
                $errors['usdt_blockchain_address'] = 'USDT Blockchain';
				$errors_message = 'USDT Blockchain';
            }
			if (empty($usdt_exchange_amount_value)) {
				$errors_message = 'Amount (USDT)';
			}
        }else{
			if (empty($usdt_exchange_amount_value)) {
				$errors_message = 'Amount (CAD)';
			}
			
		}
        // Validation for 'usdt_amount_euro'
        // if (empty($usdt_amount_euro_value)) {
        //     $errors['usdt_amount_euro'] = 'Exchange Amount';
        // }
        // // Validation for 'usdt_exchange_rate'
        // if (empty($usdt_exchange_rate_value)) {
        //     $errors['usdt_exchange_rate'] = 'Exchange Rate';
        // }
        // Validation for 'usdt_exchange_amount'
        

        // Check for errors
        if ($errors_message == '') {
            // Insert data into the custom table
            $data_to_update = array(
                'block_chain' => $usdt_block_chain_value,
				'blockchain_address' => $usdt_blockchain_address_value,
                'amount_euro' => $usdt_amount_euro_value,
                'exchange_rate' => $usdt_exchange_rate_value,
                'exchange_amount' => $usdt_exchange_amount_value
            );
        
            // Define the WHERE condition
            $where = array('id' => $_REQUEST['id']);
        
            // Perform the update
            $result = $wpdb->update($table_name, $data_to_update, $where);

            if ($result ) {
                // Data inserted successfully
                wp_send_json_success(array('message' => 'Your package has been updated.','data'=>$result));
            } else {
                // Error while inserting data
                wp_send_json_success(array('message' => 'Your package has been updated.' ));
            }
        } else {
            // Validation errors
            wp_send_json_error(array('message' => $errors_message.' is required.'));
        }
    }elseif($_REQUEST['is_fieldmap'] == '3'){
		
        // Sanitize and validate form data// confimation_password // transaction_hash
        if($_REQUEST['type_of_deposit'] == "USDT"){
            $transaction_hash = isset($_POST['transaction_hash']) ? sanitize_text_field($_POST['transaction_hash']) : '';
            $confirm_withdrawal_request_usdt = isset($_POST['confirm_withdrawal_request_usdt']) ? sanitize_text_field($_POST['confirm_withdrawal_request_usdt']) : '';

            if (empty($transaction_hash) ) {
                $errors_message = 'Transaction Hash';
            }
        
        }else{
            $confimation_password = isset($_POST['confimation_password']) ? sanitize_text_field($_POST['confimation_password']) : '';
            $confirm_withdrawal_request_cad = isset($_POST['confirm_withdrawal_request_cad']) ? sanitize_text_field($_POST['confirm_withdrawal_request_cad']) : '';
            
            if (empty($confimation_password) ) {
                $errors_message = 'Confimation Password';
            }
        }
        
        $transaction_hash = isset($_POST['transaction_hash']) ? sanitize_text_field($_POST['transaction_hash']) : '';
        $confimation_password = isset($_POST['confimation_password']) ? sanitize_text_field($_POST['confimation_password']) : '';
                
        // Check for errors
        if ($errors_message == '') {
            // Insert data into the custom table
            $data_to_update = array(
                'transaction_hash' => $transaction_hash,
                'confimation_password' => $confimation_password,
            );
            if($_REQUEST['type_of_deposit'] == 'CAD')
            {
            	$coinbase_request_url = add_query_arg( 'currency', 'CAD', 'https://api.coinbase.com/v2/exchange-rates' );
            }
            if($_REQUEST['type_of_deposit'] == 'USDT')
            {
            	$coinbase_request_url = add_query_arg( 'currency', 'USDT', 'https://api.coinbase.com/v2/exchange-rates' );
            }

            $coinbase_response = wp_remote_get( $coinbase_request_url );
            $exchangeRate = 0;
            if( !is_wp_error( $coinbase_response ) ) {
                $coinbase_response_body = wp_remote_retrieve_body( $coinbase_response );
                $data = json_decode( $coinbase_response_body );
                if( is_object( $data ) ){
                    $rates = $data->data->rates;
                    if( isset( $rates->EUR ) ){
                        $exchangeRate = round( $rates->EUR, 4 );
                    }
                }
            }
            $usdt_exchange_amount = $exchangeRate * $_REQUEST['usdt_exchange_amount'];
            // Define the WHERE condition
            $where = array('id' => $_REQUEST['id']);
        
            // Perform the update
            
			$log_type = 'deposit_request';
			$user = wp_get_current_user();
			$data_array = array(
				'id' => $_REQUEST['id'],
				'username' => $_REQUEST['username'],
				'name' => $_REQUEST['name'],
				'type_of_deposit' => $_REQUEST['type_of_deposit'],
				'email' => $user_email,
				'block_chain' => $_REQUEST['usdt_block_chain'],
                'amount_euro' => $_REQUEST['usdt_exchange_amount'],
                'exchange_rate' => $exchangeRate,
                'exchange_amount' => $usdt_exchange_amount,
				'blockchain_address' => $_REQUEST['usdt_blockchain_address'],
                'transaction_hash' => $transaction_hash,
                'confimation_password' => $confimation_password,
			);
			$token_id = token_create_for_withdrawal_and_deposit_request('deposit',$data_array);
			if($token_id != ''){
				$data_to_update['reference'] = $token_id;
			}
			$result = $wpdb->update($table_name, $data_to_update, $where);
			$message = "insert ".json_encode($data_array)." deposit request";
			create_cip_logs_entery( $user->ID, $log_type,$message );
            if ($result) {
                // Data inserted successfully
                wp_send_json_success(array('message' => 'Your package has been updated.','data'=>$result));
            } else {
                // Error while inserting data
                wp_send_json_success(array('message' => 'Your package has been updated.' ));
            }
        } else {
            // Validation errors
            wp_send_json_error(array('message' => $errors_message.' is required.'));
        }
    }
}